/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityPortletPaneledAction;
import org.chefproject.core.UserEdit;
import org.chefproject.exception.IdInvalidException;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.IdUsedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.util.EventObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.StringUtil;

public class UsersAction
extends VelocityPortletPaneledAction {
    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        super.initState(state, portlet, rundata);
        if (state.getAttribute("obsever") == null) {
            String deliveryId = this.clientWindowId(state, portlet.getID());
            String elementId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
            String pattern = UserDirectoryService.userReference("");
            state.setAttribute("obsever", (Object)new EventObservingCourier(deliveryId, elementId, pattern));
        }
        this.updateObservationOfChannel(state, portlet.getID());
    }

    private void updateObservationOfChannel(SessionState state, String peid) {
        EventObservingCourier observer = (EventObservingCourier)state.getAttribute("obsever");
        String deliveryId = this.clientWindowId(state, peid);
        observer.setDeliveryId(deliveryId);
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String template = null;
        context.put("action", state.getAttribute("action"));
        String mode = (String)state.getAttribute("mode");
        if (mode == null) {
            template = this.buildListContext(state, context);
        } else if (mode.equals("new")) {
            template = this.buildNewContext(state, context);
        } else if (mode.equals("edit")) {
            template = this.buildEditContext(state, context);
        } else if (mode.equals("confirm")) {
            template = this.buildConfirmRemoveContext(state, context);
        } else {
            Log.warn("chef", "UsersAction: mode: " + mode);
            template = this.buildListContext(state, context);
        }
        return template;
    }

    private String buildListContext(SessionState state, Context context) {
        context.put("service", UserDirectoryService.getInstance());
        context.put("users", UserDirectoryService.getUsers());
        boolean menuPopulated = false;
        Menu bar = new Menu();
        if (UserDirectoryService.allowAddUser("")) {
            bar.add(new MenuEntry("New User", null, true, 0, "doNew"));
            menuPopulated = true;
        }
        if (menuPopulated) {
            state.setAttribute("menu", (Object)bar);
            context.put("menu", bar);
        }
        return "chef_users_list";
    }

    private String buildNewContext(SessionState state, Context context) {
        return "chef_users_edit";
    }

    private String buildEditContext(SessionState state, Context context) {
        context.put("form-name", "user-form");
        UserEdit user = (UserEdit)state.getAttribute("user");
        context.put("user", user);
        boolean menuPopulated = false;
        Menu bar = new Menu();
        if (UserDirectoryService.allowRemoveUser(user.getId())) {
            bar.add(new MenuEntry("Remove User", null, true, 0, "doRemove", "user-form"));
            menuPopulated = true;
        }
        if (menuPopulated) {
            state.setAttribute("menu", (Object)bar);
            context.put("menu", bar);
        }
        return "chef_users_edit";
    }

    private String buildConfirmRemoveContext(SessionState state, Context context) {
        UserEdit user = (UserEdit)state.getAttribute("user");
        context.put("user", user);
        return "chef_users_confirm_remove";
    }

    public void doNew(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"new");
        state.setAttribute("new", (Object)"true");
        ((EventObservingCourier)state.getAttribute("obsever")).disable();
    }

    public void doEdit(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String id = data.getParameters().getString("id");
        try {
            UserEdit user = UserDirectoryService.editUser(id);
            state.setAttribute("user", (Object)user);
            state.setAttribute("mode", (Object)"edit");
            ((EventObservingCourier)state.getAttribute("obsever")).disable();
        }
        catch (IdUnusedException e) {
            Log.warn("chef", "UsersAction.doEdit: user not found: " + id);
            this.addAlert(state, "User " + id + " not found");
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to edit User " + id);
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
        catch (InUseException e) {
            this.addAlert(state, "Someone else is currently editing this User: " + id);
            state.removeAttribute("mode");
            ((EventObservingCourier)state.getAttribute("obsever")).enable();
        }
    }

    public void doSave(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readUserForm(data, state)) {
            return;
        }
        UserEdit user = (UserEdit)state.getAttribute("user");
        if (user != null) {
            UserDirectoryService.commitEdit(user);
        }
        state.removeAttribute("user");
        state.removeAttribute("new");
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doCancel(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        UserEdit user = (UserEdit)state.getAttribute("user");
        if (user != null) {
            if ("true".equals(state.getAttribute("new"))) {
                try {
                    UserDirectoryService.removeUser(user);
                }
                catch (PermissionException e) {
                    this.addAlert(state, "You do not have permission to remove User " + user.getId());
                }
            } else {
                UserDirectoryService.cancelEdit(user);
            }
        }
        state.removeAttribute("user");
        state.removeAttribute("new");
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doRemove(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        if (!this.readUserForm(data, state)) {
            return;
        }
        state.setAttribute("mode", (Object)"confirm");
    }

    public void doRemove_confirmed(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        UserEdit user = (UserEdit)state.getAttribute("user");
        try {
            UserDirectoryService.removeUser(user);
        }
        catch (PermissionException e) {
            this.addAlert(state, "You do not have permission to remove User " + user.getId());
        }
        state.removeAttribute("user");
        state.removeAttribute("new");
        state.removeAttribute("mode");
        ((EventObservingCourier)state.getAttribute("obsever")).enable();
    }

    public void doCancel_remove(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        state.setAttribute("mode", (Object)"edit");
    }

    private boolean readUserForm(RunData data, SessionState state) {
        String id = StringUtil.trimToNull(data.getParameters().getString("id"));
        String firstName = StringUtil.trimToNull(data.getParameters().getString("first-name"));
        String lastName = StringUtil.trimToNull(data.getParameters().getString("last-name"));
        String email = StringUtil.trimToNull(data.getParameters().getString("email"));
        String pw = StringUtil.trimToNull(data.getParameters().getString("pw"));
        UserEdit user = (UserEdit)state.getAttribute("user");
        if (user == null) {
            try {
                user = UserDirectoryService.addUser(id);
                state.setAttribute("user", (Object)user);
            }
            catch (IdUsedException e) {
                this.addAlert(state, "The user id is already in use");
                return false;
            }
            catch (IdInvalidException e) {
                this.addAlert(state, "The user id is invalid");
                return false;
            }
            catch (PermissionException e) {
                this.addAlert(state, "You do not have permission to edit this User");
                return false;
            }
        }
        if (user != null) {
            user.setFirstName(firstName);
            user.setLastName(lastName);
            user.setEmail(email);
            if (pw != null) {
                user.setPassword(pw);
            }
        }
        return true;
    }
}

