/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.util.Log;
import org.chefproject.core.Site;
import org.chefproject.core.User;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.service.PortalService;
import org.chefproject.service.SecurityService;
import org.chefproject.service.ServerConfigurationService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.service.UserDirectoryService;
import org.chefproject.service.generic.GenericContentHostingService;
import org.chefproject.util.Reference;
import org.chefproject.util.StringUtil;
import org.chefproject.util.Validator;

public class MyPortalsTool
implements ApplicationTool {
    public static final int DEFAULT = 0;
    public static final int USER = 1;
    public static final int GROUP = 2;
    protected Vector m_pages = null;
    protected boolean m_allowReset = false;
    public static final int TAB_PAGE_SIZE = 5;

    public static final int getDefault() {
        return 0;
    }

    public static final int getUser() {
        return 1;
    }

    public static final int getGroup() {
        return 2;
    }

    public void init(Object data) {
        this.refresh();
        this.reset();
    }

    public void refresh() {
        this.m_allowReset = true;
    }

    protected void reset() {
        if (!this.m_allowReset) {
            return;
        }
        this.m_allowReset = false;
        if (Log.getLogger("chef").isDebugEnabled()) {
            Log.debug("chef", this + ".reset()");
        }
        this.m_pages = new Vector();
        User user = UsageSessionService.getSessionUser();
        if (user.equals(UserDirectoryService.getAnonymousUser())) {
            return;
        }
        this.m_pages.add(new PortalPage("My Workspace", user.getId(), 0, "My Workspace", false));
        List sites = SiteService.getSites();
        Collections.sort(sites);
        Iterator iSites = sites.iterator();
        while (iSites.hasNext()) {
            Site site = (Site)iSites.next();
            if (SiteService.isUserSite(site.getId()) || !SiteService.allowAccessSite(site.getId())) continue;
            this.m_pages.add(new PortalPage(site.getTitle(), site.getId(), 2, site.getDescription(), site.isJoinable()));
        }
    }

    public List getPages() {
        this.reset();
        if (this.m_pages.size() == 0) {
            return new Vector();
        }
        return this.m_pages;
    }

    public List getPrimaryPages() {
        this.reset();
        int n = 5;
        if (n > this.m_pages.size()) {
            n = this.m_pages.size();
        }
        if (n == 0) {
            return new Vector();
        }
        Vector pages = new Vector();
        int i = 0;
        while (i < n) {
            pages.add(this.m_pages.elementAt(i));
            ++i;
        }
        return pages;
    }

    public List getMorePages() {
        this.reset();
        int n = this.m_pages.size() - 5;
        if (n <= 0) {
            return new Vector();
        }
        Vector pages = new Vector();
        int i = 0;
        while (i < n) {
            pages.add(this.m_pages.elementAt(i + 5));
            ++i;
        }
        return pages;
    }

    public String getSiteTitle() {
        String siteId = PortalService.getCurrentSiteId();
        try {
            Site site = SiteService.getSite(siteId);
            return StringUtil.trimToNull(site.getTitle());
        }
        catch (IdUnusedException e) {
            return null;
        }
    }

    public String getSiteIcon() {
        String rv = null;
        String siteId = PortalService.getCurrentSiteId();
        try {
            Site site = SiteService.getSite(siteId);
            rv = StringUtil.trimToNull(site.getIconUrl());
        }
        catch (IdUnusedException e) {
            return null;
        }
        Reference ref = new Reference(rv);
        if (GenericContentHostingService.SERVICE_NAME.equals(ref.getType())) {
            rv = ref.getUrl();
        }
        return rv;
    }

    public static boolean getCustomize() {
        String siteId = PortalService.getCurrentSiteId();
        return SiteService.allowUpdateSite(siteId);
    }

    public boolean getSuperUser() {
        return SecurityService.isSuperUser();
    }

    public static String getSiteId() {
        return PortalService.getCurrentSiteId();
    }

    public String getSitePage(String link) {
        int pos = link.indexOf("js_pane");
        if (pos == -1) {
            Log.warn("chef", this + "getPane: no js_pane in: " + link);
            return link;
        }
        int nextSlash = link.indexOf("/", pos += 8);
        if (nextSlash == -1) {
            nextSlash = link.length();
        }
        String pane = link.substring(pos, nextSlash);
        return pane;
    }

    public String getSitePageUrl(String site, String sitePage) {
        String link = ServerConfigurationService.getPortalUrl();
        link = SiteService.isUserSite(site) ? link + "/user/" + SiteService.getSiteUserId(site) : link + "/group/" + site;
        link = link + "/js_pane/" + sitePage;
        return link;
    }

    public static String getSiteUrl() {
        String siteId = PortalService.getCurrentSiteId();
        String link = ServerConfigurationService.getPortalUrl();
        link = SiteService.isUserSite(siteId) ? link + "/user/" + SiteService.getSiteUserId(siteId) : link + "/group/" + siteId;
        return link;
    }

    public String getLoginUrl(JetspeedRunData data) {
        HttpServletRequest req = data.getRequest();
        String root = req.getRequestURI();
        String servletPath = req.getServletPath();
        int pos = root.indexOf(servletPath);
        String webappRoot = root.substring(0, pos);
        String login = webappRoot + "/portal/template/Login";
        return login;
    }

    public String getNow() {
        return Long.toString(System.currentTimeMillis());
    }

    public boolean getFloating(JetspeedRunData data, String portletId) {
        SessionState state = data.getPortletSessionState(portletId);
        return state.getAttribute("float") != null;
    }

    public static boolean getFloating(JetspeedRunData data) {
        boolean floating;
        boolean bl = floating = data.getParameters().getString("float") != null;
        if (!floating) {
            String template = data.getParameters().getString("template");
            floating = "/html/float.vm".equals(template);
        }
        return floating;
    }

    public static String getServerUrl() {
        return ServerConfigurationService.getServerUrl();
    }

    public static String getCssUrl() {
        String root = ServerConfigurationService.getServerUrl() + "/css/";
        String skin = null;
        String siteId = PortalService.getCurrentSiteId();
        if (siteId != null) {
            try {
                Site site = SiteService.getSite(siteId);
                skin = site.getSkin();
            }
            catch (IdUnusedException idUnusedException) {
                // empty catch block
            }
        }
        if (skin == null) {
            skin = "chef.css";
        }
        return root + skin;
    }

    static {
        DEFAULT = 0;
        USER = 1;
        GROUP = 2;
        TAB_PAGE_SIZE = 5;
    }

    public class PortalPage {
        protected String m_title = null;
        protected String m_description = null;
        protected boolean m_open = false;
        protected String m_id = null;
        protected int m_type = 0;

        public void setTitle(String title) {
            this.m_title = title;
        }

        public String getTitle() {
            return this.m_title;
        }

        public void setDescription(String description) {
            this.m_description = description;
        }

        public String getDescription() {
            return this.m_description;
        }

        public void setOpen(boolean open) {
            this.m_open = open;
        }

        public boolean getOpen() {
            return this.m_open;
        }

        public void setId(String id) {
            this.m_id = id;
        }

        public String getId() {
            return this.m_id;
        }

        public void setType(int type) {
            this.m_type = type;
        }

        public int getType() {
            return this.m_type;
        }

        public PortalPage(String title, String id, int type, String description, boolean open) {
            this.setTitle(title);
            this.setId(id);
            this.setType(type);
            this.setDescription(description);
            this.setOpen(open);
        }

        public boolean getCurrent() {
            String siteId = PortalService.getCurrentSiteId();
            switch (this.getType()) {
                case 0: 
                case 1: {
                    if (!SiteService.isUserSite(siteId) || !this.getId().equals(SiteService.getSiteUserId(siteId))) break;
                    return true;
                }
                case 2: {
                    if (SiteService.isUserSite(siteId) || !this.getId().equals(siteId)) break;
                    return true;
                }
            }
            return false;
        }

        public String getUrl() {
            StringBuffer url = new StringBuffer(ServerConfigurationService.getPortalUrl());
            if (this.getType() != 0) {
                switch (this.getType()) {
                    case 2: {
                        url.append("/group/");
                        url.append(Validator.escapeUrl(this.getId()));
                        break;
                    }
                    case 1: {
                        url.append("/user/");
                        url.append(Validator.escapeUrl(this.getId()));
                    }
                }
            }
            url.append("/action/Select?site=");
            switch (this.getType()) {
                case 2: {
                    url.append(Validator.escapeUrl(Validator.escapeUrl(this.getId())));
                    break;
                }
                case 1: {
                    url.append(Validator.escapeUrl(SiteService.getUserSiteId(this.getId())));
                    break;
                }
                case 0: {
                    url.append(Validator.escapeUrl(SiteService.getUserSiteId(UsageSessionService.safelyGetSessionUserId())));
                }
            }
            return url.toString();
        }
    }
}

