// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _BRepLib_FindSurface_HeaderFile
#define _BRepLib_FindSurface_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _TopLoc_Location_HeaderFile
#include <TopLoc_Location.hxx>
#endif
class Geom_Surface;
class Standard_NoSuchObject;
class TopoDS_Shape;
class TopLoc_Location;


//! Provides an  algorithm to find  a Surface  through a <br>
//!          set of edges. <br>
//! <br>
//!          The edges  of  the  shape  given  as  argument are <br>
//!          explored if they are not coplanar at  the required <br>
//!          tolerance  the method Found returns false. <br>
//! <br>
//!          If a null tolerance is given the max of the  edges <br>
//!          tolerances is used. <br>
//! <br>
//!          The method Tolerance returns the true distance  of <br>
//!          the edges to the Surface. <br>
//! <br>
//!          The method Surface returns the Surface if found. <br>
//! <br>
//!          The method Existed  returns returns  True  if  the <br>
//!          Surface was already attached to some of the edges. <br>
//! <br>
//!          When Existed  returns True  the  Surface  may have a <br>
//!          location given by the Location method. <br>
class BRepLib_FindSurface  {
public:

  DEFINE_STANDARD_ALLOC

  
  Standard_EXPORT   BRepLib_FindSurface();
  //! Computes the Surface from the edges of  <S> with the <br>
//!          given tolerance. <br>
//!          if <OnlyPlane> is true, the computed surface will be <br>
//!          a plane. If it is not possible to find a plane, the <br>
//!          flag NotDone will be set. <br>
//!          If <OnlyClosed> is true,  then  S  sould be a wire <br>
//!          and the existing surface,  on  which wire S is not <br>
//!          closed in 2D, will be ignored. <br>
  Standard_EXPORT   BRepLib_FindSurface(const TopoDS_Shape& S,const Standard_Real Tol = -1,const Standard_Boolean OnlyPlane = Standard_False,const Standard_Boolean OnlyClosed = Standard_False);
  //! Computes the Surface from the edges of  <S> with the <br>
//!          given tolerance. <br>
//!          if <OnlyPlane> is true, the computed surface will be <br>
//!          a plane. If it is not possible to find a plane, the <br>
//!          flag NotDone will be set. <br>
//!          If <OnlyClosed> is true,  then  S  sould be a wire <br>
//!          and the existing surface,  on  which wire S is not <br>
//!          closed in 2D, will be ignored. <br>
  Standard_EXPORT     void Init(const TopoDS_Shape& S,const Standard_Real Tol = -1,const Standard_Boolean OnlyPlane = Standard_False,const Standard_Boolean OnlyClosed = Standard_False) ;
  
  Standard_EXPORT     Standard_Boolean Found() const;
  
  Standard_EXPORT     Handle_Geom_Surface Surface() const;
  
  Standard_EXPORT     Standard_Real Tolerance() const;
  
  Standard_EXPORT     Standard_Real ToleranceReached() const;
  
  Standard_EXPORT     Standard_Boolean Existed() const;
  
  Standard_EXPORT     TopLoc_Location Location() const;





protected:





private:



Handle_Geom_Surface mySurface;
Standard_Real myTolerance;
Standard_Real myTolReached;
Standard_Boolean isExisted;
TopLoc_Location myLocation;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
