// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IFSelect_SelectRootComps_HeaderFile
#define _IFSelect_SelectRootComps_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_IFSelect_SelectRootComps.hxx>

#include <IFSelect_SelectExtract.hxx>
#include <Standard_Boolean.hxx>
#include <Standard_Integer.hxx>
#include <Handle_Standard_Transient.hxx>
#include <Handle_Interface_InterfaceModel.hxx>
class Interface_EntityIterator;
class Interface_Graph;
class Standard_Transient;
class Interface_InterfaceModel;
class TCollection_AsciiString;


//! A SelectRootComps sorts the Entities which are part of Strong
//! Componants, local roots of a set of Entities : they can be
//! Single Componants (containing one Entity) or Cycles
//! This class gives a more secure result than SelectRoots (which
//! considers only Single Componants) but is longer to work : it
//! can be used when there can be or there are cycles in a Model
//! For each cycle, one Entity is given arbitrarily
//! Reject works as for SelectRoots : Strong Componants defined in
//! the input list which are not local roots are given
class IFSelect_SelectRootComps : public IFSelect_SelectExtract
{

public:

  
  //! Creates a SelectRootComps
  Standard_EXPORT IFSelect_SelectRootComps();
  
  //! Returns the list of local root strong componants, by one
  //! Entity par componant. It is redefined for a purpose of
  //! effeciency : calling a Sort routine for each Entity would
  //! cost more ressource than to work in once using a Map
  //! RootResult takes in account the Direct status
  Standard_EXPORT virtual   Interface_EntityIterator RootResult (const Interface_Graph& G)  const;
  
  //! Returns always True, because RootResult has done work
  Standard_EXPORT   Standard_Boolean Sort (const Standard_Integer rank, const Handle(Standard_Transient)& ent, const Handle(Interface_InterfaceModel)& model)  const;
  
  //! Returns a text defining the criterium : "Local Root Componants"
  Standard_EXPORT   TCollection_AsciiString ExtractLabel()  const;




  DEFINE_STANDARD_RTTI(IFSelect_SelectRootComps)

protected:

  
  //! Returns True, RootResult assuring uniqueness
  Standard_EXPORT virtual   Standard_Boolean HasUniqueResult()  const;



private: 




};







#endif // _IFSelect_SelectRootComps_HeaderFile
