#!/bin/bash
#
# Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
# DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
#
# This code is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 only, as
# published by the Free Software Foundation.
#
# This code is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# version 2 for more details (a copy is included in the LICENSE file that
# accompanied this code).
#
# You should have received a copy of the GNU General Public License version
# 2 along with this work; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
# Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
# or visit www.oracle.com if you need additional information or have any
# questions.
#

while read -r -a TEST_ARGS
do
   set -- "${TEST_ARGS[@]}"

   action="main/othervm"
   flags="-XX:+UnlockExperimentalVMOptions -XX:+EnableJVMCI"
   requireInfo=""
   vmargs=""

   if [ "$#" -ge 2 ] ; then
     fName="$1Test.java"; shift
     pName=$1; shift

     echo "Generate $fName for $pName ..."

     while [ $# -gt 0 ]; do
        case $1 in
           --requires)
             shift
             requireInfo="@requires $1"
             shift
           ;;

           --timeout)
             shift
             action="$action/timeout=$1"
             shift
           ;;

           --vmargs)
             shift
             vmargs="-vmargs $1"
             shift
           ;;

           *)
             echo "WARN: unknown option $1 in line \"$TEST_ARGS\" will be ignored"
             shift
           ;;
        esac
     done
  else
     echo "ERROR in line \"$TEST_ARGS\""
  fi


  cat << EOF | sed 's/[[:blank:]]*$//' > $fName
/*
 * Copyright (c) 2018, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * @test
 * @requires vm.jvmci
 * $requireInfo
 * @modules jdk.internal.vm.compiler
 *
 * @library /test/lib /compiler/graalunit /
 *
 * @run $action $flags compiler.graalunit.common.GraalUnitTestLauncher -prefix $pName -exclude \${test.root}/ProblemList-graal.txt $vmargs
 */

/* DO NOT MODIFY THIS FILE. GENERATED BY generateTests.sh */
EOF

done < TestPackages.txt

