#!/usr/bin/env bash
. $builddir/tests/test_common.sh

set -e
set -o pipefail

name=$(basename $0 .sh)
result=$(make_temp_file /tmp ${name}.out)
stderr=$(make_temp_file /tmp ${name}.out)

ret=0

input_xml="$srcdir/${name}.xccdf.xml"
valid_toml="$srcdir/${name}.toml"

expected_result=$(mktemp)
sed "s;TEST_XCCDF_FILE_NAME;$input_xml;" "$valid_toml" > "$expected_result"

echo "Stderr file = $stderr"
echo "Result file = $result"
[ -f $stderr ]; [ ! -s $stderr ]; :> $stderr

# The expected file was generated without ' # This file was generated by OpenSCAP 1.3.5 using:' line
# to make the test independent from the scanner version. We have to filter this line from the output as well.

$OSCAP xccdf generate fix --fix-type blueprint --profile 'common' "$input_xml" | grep -v "OpenSCAP" > "$result"

diff "$expected_result" "$result"

rm "$result"
rm "$expected_result"
