// This file is a part of the OpenSurgSim project.
// Copyright 2012-2013, SimQuest Solutions Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include <math.h>

#include "SurgSim/Math/GaussLegendreQuadrature.h"

namespace SurgSim
{
namespace Math
{

std::array<gaussQuadraturePoint, 1> gaussQuadrature1Point =
{{
	gaussQuadraturePoint(0.0, 2.0)
}};

std::array<gaussQuadraturePoint, 2> gaussQuadrature2Points =
{{
	gaussQuadraturePoint( 1.0 / sqrt(3.0), 1.0),
	gaussQuadraturePoint(-1.0 / sqrt(3.0), 1.0)
}};

std::array<gaussQuadraturePoint, 3> gaussQuadrature3Points =
{{
	gaussQuadraturePoint(             0.0, 8.0 / 9.0),
	gaussQuadraturePoint( sqrt(3.0 / 5.0), 5.0 / 9.0),
	gaussQuadraturePoint(-sqrt(3.0 / 5.0), 5.0 / 9.0)
}};

std::array<gaussQuadraturePoint, 4> gaussQuadrature4Points =
{{
	gaussQuadraturePoint( sqrt((3.0 - 2.0 * sqrt(6.0 / 5.0)) / 7.0), (18.0 + sqrt(30.0)) / 36.0),
	gaussQuadraturePoint(-sqrt((3.0 - 2.0 * sqrt(6.0 / 5.0)) / 7.0), (18.0 + sqrt(30.0)) / 36.0),
	gaussQuadraturePoint( sqrt((3.0 + 2.0 * sqrt(6.0 / 5.0)) / 7.0), (18.0 - sqrt(30.0)) / 36.0),
	gaussQuadraturePoint(-sqrt((3.0 + 2.0 * sqrt(6.0 / 5.0)) / 7.0), (18.0 - sqrt(30.0)) / 36.0)
}};

std::array<gaussQuadraturePoint, 5> gaussQuadrature5Points =
{{
	gaussQuadraturePoint( 0.0, 128.0 / 225.0),
	gaussQuadraturePoint( sqrt(5.0 - 2.0 * sqrt(10.0 / 7.0)) / 3.0, (322.0 + 13.0 * sqrt(70.0)) / 900.0),
	gaussQuadraturePoint(-sqrt(5.0 - 2.0 * sqrt(10.0 / 7.0)) / 3.0, (322.0 + 13.0 * sqrt(70.0)) / 900.0),
	gaussQuadraturePoint( sqrt(5.0 + 2.0 * sqrt(10.0 / 7.0)) / 3.0, (322.0 - 13.0 * sqrt(70.0)) / 900.0),
	gaussQuadraturePoint(-sqrt(5.0 + 2.0 * sqrt(10.0 / 7.0)) / 3.0, (322.0 - 13.0 * sqrt(70.0)) / 900.0)
}};

std::array<gaussQuadraturePoint, 100> gaussQuadrature100Points =
{{
	gaussQuadraturePoint( 0.0156289844215430828722167, 0.0312554234538633569476425),
	gaussQuadraturePoint(-0.0156289844215430828722167, 0.0312554234538633569476425),
	gaussQuadraturePoint( 0.0468716824215916316149239, 0.0312248842548493577323765),
	gaussQuadraturePoint(-0.0468716824215916316149239, 0.0312248842548493577323765),
	gaussQuadraturePoint( 0.0780685828134366366948174, 0.0311638356962099067838183),
	gaussQuadraturePoint(-0.0780685828134366366948174, 0.0311638356962099067838183),
	gaussQuadraturePoint( 0.1091892035800611150034260, 0.0310723374275665165878102),
	gaussQuadraturePoint(-0.1091892035800611150034260, 0.0310723374275665165878102),
	gaussQuadraturePoint( 0.1402031372361139732075146, 0.0309504788504909882340635),
	gaussQuadraturePoint(-0.1402031372361139732075146, 0.0309504788504909882340635),
	gaussQuadraturePoint( 0.1710800805386032748875324, 0.0307983790311525904277139),
	gaussQuadraturePoint(-0.1710800805386032748875324, 0.0307983790311525904277139),
	gaussQuadraturePoint( 0.2017898640957359972360489, 0.0306161865839804484964594),
	gaussQuadraturePoint(-0.2017898640957359972360489, 0.0306161865839804484964594),
	gaussQuadraturePoint( 0.2323024818449739696495100, 0.0304040795264548200165079),
	gaussQuadraturePoint(-0.2323024818449739696495100, 0.0304040795264548200165079),
	gaussQuadraturePoint( 0.2625881203715034791689293, 0.0301622651051691449190687),
	gaussQuadraturePoint(-0.2625881203715034791689293, 0.0301622651051691449190687),
	gaussQuadraturePoint( 0.2926171880384719647375559, 0.0298909795933328309168368),
	gaussQuadraturePoint(-0.2926171880384719647375559, 0.0298909795933328309168368),
	gaussQuadraturePoint( 0.3223603439005291517224766, 0.0295904880599126425117545),
	gaussQuadraturePoint(-0.3223603439005291517224766, 0.0295904880599126425117545),
	gaussQuadraturePoint( 0.3517885263724217209723438, 0.0292610841106382766201190),
	gaussQuadraturePoint(-0.3517885263724217209723438, 0.0292610841106382766201190),
	gaussQuadraturePoint( 0.3808729816246299567633625, 0.0289030896011252031348762),
	gaussQuadraturePoint(-0.3808729816246299567633625, 0.0289030896011252031348762),
	gaussQuadraturePoint( 0.4095852916783015425288684, 0.0285168543223950979909368),
	gaussQuadraturePoint(-0.4095852916783015425288684, 0.0285168543223950979909368),
	gaussQuadraturePoint( 0.4378974021720315131089780, 0.0281027556591011733176483),
	gaussQuadraturePoint(-0.4378974021720315131089780, 0.0281027556591011733176483),
	gaussQuadraturePoint( 0.4657816497733580422492166, 0.0276611982207923882942042),
	gaussQuadraturePoint(-0.4657816497733580422492166, 0.0276611982207923882942042),
	gaussQuadraturePoint( 0.4932107892081909335693088, 0.0271926134465768801364916),
	gaussQuadraturePoint(-0.4932107892081909335693088, 0.0271926134465768801364916),
	gaussQuadraturePoint( 0.5201580198817630566468157, 0.0266974591835709626603847),
	gaussQuadraturePoint(-0.5201580198817630566468157, 0.0266974591835709626603847),
	gaussQuadraturePoint( 0.5465970120650941674679943, 0.0261762192395456763423087),
	gaussQuadraturePoint(-0.5465970120650941674679943, 0.0261762192395456763423087),
	gaussQuadraturePoint( 0.5725019326213811913168704, 0.0256294029102081160756420),
	gaussQuadraturePoint(-0.5725019326213811913168704, 0.0256294029102081160756420),
	gaussQuadraturePoint( 0.5978474702471787212648065, 0.0250575444815795897037642),
	gaussQuadraturePoint(-0.5978474702471787212648065, 0.0250575444815795897037642),
	gaussQuadraturePoint( 0.6226088602037077716041908, 0.0244612027079570527199750),
	gaussQuadraturePoint(-0.6226088602037077716041908, 0.0244612027079570527199750),
	gaussQuadraturePoint( 0.6467619085141292798326303, 0.0238409602659682059625604),
	gaussQuadraturePoint(-0.6467619085141292798326303, 0.0238409602659682059625604),
	gaussQuadraturePoint( 0.6702830156031410158025870, 0.0231974231852541216224889),
	gaussQuadraturePoint(-0.6702830156031410158025870, 0.0231974231852541216224889),
	gaussQuadraturePoint( 0.6931491993558019659486479, 0.0225312202563362727017970),
	gaussQuadraturePoint(-0.6931491993558019659486479, 0.0225312202563362727017970),
	gaussQuadraturePoint( 0.7153381175730564464599671, 0.0218430024162473863139537),
	gaussQuadraturePoint(-0.7153381175730564464599671, 0.0218430024162473863139537),
	gaussQuadraturePoint( 0.7368280898020207055124277, 0.0211334421125276415426723),
	gaussQuadraturePoint(-0.7368280898020207055124277, 0.0211334421125276415426723),
	gaussQuadraturePoint( 0.7575981185197071760356680, 0.0204032326462094327668389),
	gaussQuadraturePoint(-0.7575981185197071760356680, 0.0204032326462094327668389),
	gaussQuadraturePoint( 0.7776279096494954756275514, 0.0196530874944353058653815),
	gaussQuadraturePoint(-0.7776279096494954756275514, 0.0196530874944353058653815),
	gaussQuadraturePoint( 0.7968978923903144763895729, 0.0188837396133749045529412),
	gaussQuadraturePoint(-0.7968978923903144763895729, 0.0188837396133749045529412),
	gaussQuadraturePoint( 0.8153892383391762543939888, 0.0180959407221281166643908),
	gaussQuadraturePoint(-0.8153892383391762543939888, 0.0180959407221281166643908),
	gaussQuadraturePoint( 0.8330838798884008235429158, 0.0172904605683235824393442),
	gaussQuadraturePoint(-0.8330838798884008235429158, 0.0172904605683235824393442),
	gaussQuadraturePoint( 0.8499645278795912842933626, 0.0164680861761452126431050),
	gaussQuadraturePoint(-0.8499645278795912842933626, 0.0164680861761452126431050),
	gaussQuadraturePoint( 0.8660146884971646234107400, 0.0156296210775460027239369),
	gaussQuadraturePoint(-0.8660146884971646234107400, 0.0156296210775460027239369),
	gaussQuadraturePoint( 0.8812186793850184155733168, 0.0147758845274413017688800),
	gaussQuadraturePoint(-0.8812186793850184155733168, 0.0147758845274413017688800),
	gaussQuadraturePoint( 0.8955616449707269866985210, 0.0139077107037187726879541),
	gaussQuadraturePoint(-0.8955616449707269866985210, 0.0139077107037187726879541),
	gaussQuadraturePoint( 0.9090295709825296904671263, 0.0130259478929715422855586),
	gaussQuadraturePoint(-0.9090295709825296904671263, 0.0130259478929715422855586),
	gaussQuadraturePoint( 0.9216092981453339526669513, 0.0121314576629794974077448),
	gaussQuadraturePoint(-0.9216092981453339526669513, 0.0121314576629794974077448),
	gaussQuadraturePoint( 0.9332885350430795459243337, 0.0112251140231859771172216),
	gaussQuadraturePoint(-0.9332885350430795459243337, 0.0112251140231859771172216),
	gaussQuadraturePoint( 0.9440558701362559779627747, 0.0103078025748689695857821),
	gaussQuadraturePoint(-0.9440558701362559779627747, 0.0103078025748689695857821),
	gaussQuadraturePoint( 0.9539007829254917428493369, 0.0093804196536944579514182),
	gaussQuadraturePoint(-0.9539007829254917428493369, 0.0093804196536944579514182),
	gaussQuadraturePoint( 0.9628136542558155272936593, 0.0084438714696689714026208),
	gaussQuadraturePoint(-0.9628136542558155272936593, 0.0084438714696689714026208),
	gaussQuadraturePoint( 0.9707857757637063319308979, 0.0074990732554647115788287),
	gaussQuadraturePoint(-0.9707857757637063319308979, 0.0074990732554647115788287),
	gaussQuadraturePoint( 0.9778093584869182885537811, 0.0065469484508453227641521),
	gaussQuadraturePoint(-0.9778093584869182885537811, 0.0065469484508453227641521),
	gaussQuadraturePoint( 0.9838775407060570154961002, 0.0055884280038655151572119),
	gaussQuadraturePoint(-0.9838775407060570154961002, 0.0055884280038655151572119),
	gaussQuadraturePoint( 0.9889843952429917480044187, 0.0046244500634221193510958),
	gaussQuadraturePoint(-0.9889843952429917480044187, 0.0046244500634221193510958),
	gaussQuadraturePoint( 0.9931249370374434596520099, 0.0036559612013263751823425),
	gaussQuadraturePoint(-0.9931249370374434596520099, 0.0036559612013263751823425),
	gaussQuadraturePoint( 0.9962951347331251491861317, 0.0026839253715534824194396),
	gaussQuadraturePoint(-0.9962951347331251491861317, 0.0026839253715534824194396),
	gaussQuadraturePoint( 0.9984919506395958184001634, 0.0017093926535181052395294),
	gaussQuadraturePoint(-0.9984919506395958184001634, 0.0017093926535181052395294),
	gaussQuadraturePoint( 0.9997137267734412336782285, 0.0007346344905056717304063),
	gaussQuadraturePoint(-0.9997137267734412336782285, 0.0007346344905056717304063)
}};

};  // namespace Math
};  // namespace SurgSim
