#define LEAK_DETECTIVE
#define USE_SHA2
#include "../../programs/pluto/crypt_dh.c"

char *progname;

void exit_tool(int stat)
{
    exit(stat);
}

struct skey_pskcalc {
    chunk_t pss;
    chunk_t ni;
    chunk_t nr;
    chunk_t expected;
} psksc[]={
    {{"this is a pre-shared", 0},
     {"asdfasdfasdfasdf",0}, 
     {"dasdfasdfasdfasd",0},
    }
};

/* | DH shared secret: */
unsigned char shared1[]=
    { 0x0e, 0x64, 0x6b, 0x94, 0x15, 0x58, 0x0f, 0xb0, 0x5d, 0x38, 0x0a, 0x09, 0x0a, 0xae, 0xfc, 0xc3,
      0xfc, 0x5a, 0x1a, 0xf8, 0x9f, 0xb9, 0x2b, 0xb8, 0xf4, 0xbe, 0xf1, 0xaf, 0x79, 0xf5, 0x34, 0x7c,
      0xbd, 0xf8, 0x0e, 0x35, 0xab, 0x40, 0x84, 0x85, 0x95, 0xd5, 0x28, 0xc3, 0xdf, 0x06, 0x31, 0x7d,
      0xa0, 0x53, 0xff, 0xad, 0x75, 0x3f, 0xed, 0xb6, 0x74, 0x6f, 0x38, 0x14, 0x89, 0x97, 0xe7, 0x80,
      0x16, 0x8a, 0x89, 0x17, 0xd4, 0xea, 0x02, 0x85, 0xc2, 0x9d, 0xe5, 0x29, 0x54, 0xf9, 0xd0, 0x74,
      0x7a, 0x32, 0x7e, 0x6b, 0x9a, 0xf0, 0x11, 0x5b, 0xde, 0x3d, 0x22, 0xd2, 0xdc, 0x44, 0xc6, 0xae,
      0x76, 0xa2, 0x48, 0x1b, 0x56, 0x9b, 0x65, 0x59, 0x2b, 0x7c, 0xb6, 0x6f, 0x00, 0xad, 0x06, 0x50,
      0x17, 0x3d, 0xda, 0xdf, 0xb4, 0x60, 0xdb, 0x98, 0xb8, 0xf5, 0x85, 0x85, 0x55, 0x13, 0x97, 0x9e,
      0xc8, 0x2e, 0x75, 0x65, 0xbe, 0x71, 0xf8, 0xc0, 0x16, 0xcf, 0xc7, 0x1b, 0x70, 0xef, 0x43, 0x36,
      0x22, 0xb5, 0xd2, 0xe9, 0x9b, 0x81, 0x46, 0x23, 0x83, 0xf9, 0x9a, 0xc4, 0x05, 0x28, 0xae, 0x69,
      0x56, 0x12, 0xa1, 0xbf, 0x69, 0xac, 0x1a, 0x81, 0x06, 0xd7, 0x56, 0xb7, 0x00, 0x3a, 0xe9, 0x2a,
      0x37, 0x97, 0x23, 0xb4, 0x5b, 0xd0, 0x02, 0x63, 0x43, 0x46, 0xe3, 0x44, 0x74, 0xad, 0x93, 0x4f};

/* ni */
unsigned char ni1[]=
    { 0x12, 0xca, 0x48, 0x08, 0x79, 0x4d, 0x20, 0x8f, 0xb1, 0x54, 0x86, 0xd4, 0xe2, 0x0f, 0x94, 0x01};

/* nr */
unsigned char nr1[]=
    { 0x40, 0xe7, 0xd3, 0x1d, 0x5f, 0x0e, 0x51, 0x22, 0x54, 0xc4, 0x89, 0xd5, 0x6e, 0xeb, 0x16, 0x14};

/* GI */
unsigned char gi1[]=
    { 0x75, 0xea, 0x5f, 0x22, 0x04, 0xea, 0xca, 0x4e, 0x39, 0xf7, 0xf8, 0x4d, 0x96, 0x2b, 0x98, 0x7a,
      0xd7, 0xd2, 0xad, 0xc8, 0xea, 0x01, 0x6c, 0xc3, 0x20, 0x03, 0x5b, 0x6e, 0xd8, 0x05, 0x76, 0x2b,
      0x29, 0xcf, 0x1b, 0x24, 0x9e, 0x21, 0xd3, 0xb9, 0xc8, 0x45, 0x9c, 0x27, 0x27, 0x29, 0x21, 0x16,
      0x46, 0x8b, 0x75, 0x40, 0x40, 0xa9, 0x24, 0x2a, 0x3f, 0x52, 0xa6, 0x02, 0x6e, 0xd3, 0x31, 0xaf,
      0x4d, 0x58, 0x45, 0x5a, 0x82, 0x68, 0x0a, 0xc4, 0xe7, 0x0a, 0x12, 0xa4, 0xe1, 0x2b, 0x9f, 0xa5,
      0x74, 0x7f, 0x39, 0x78, 0x8a, 0xe6, 0x54, 0x0b, 0x02, 0x57, 0x40, 0xbe, 0x4e, 0x4b, 0x0d, 0xc2,
      0x01, 0x6e, 0x30, 0x69, 0x39, 0x73, 0x78, 0xf2, 0x47, 0xbd, 0x8f, 0x1a, 0x7f, 0x01, 0x9a, 0x38,
      0x35, 0xb3, 0x44, 0x95, 0xf3, 0x7d, 0xd4, 0x73, 0xa1, 0xe2, 0x67, 0xc2, 0x44, 0xf2, 0x57, 0x76,
      0x5d, 0x9d, 0x7e, 0xcb, 0xfc, 0x25, 0x5a, 0x87, 0xdd, 0x08, 0x9d, 0x36, 0x7a, 0xe7, 0xf3, 0x72,
      0x6a, 0x8c, 0x0e, 0x13, 0x10, 0x2a, 0xda, 0x9a, 0xd2, 0x31, 0x81, 0x59, 0x0c, 0xb1, 0x12, 0xd4,
      0x47, 0x25, 0xf4, 0x77, 0x61, 0xfb, 0xc7, 0xb6, 0x74, 0x7c, 0x6c, 0x9a, 0xe7, 0x96, 0xfc, 0x3a,
      0xab, 0x8f, 0x59, 0x2b, 0x9d, 0x56, 0x4a, 0xb0, 0x6b, 0x98, 0xc4, 0xf6, 0x42, 0x29, 0x5f, 0x58
    };

/* GR */
unsigned char gr1[]=
    { 0x91, 0x32, 0xda, 0x9b, 0x02, 0x06, 0x9a, 0x80, 0x74, 0xcf, 0xbd, 0x93, 0x7b, 0x74, 0x63, 0xa3,
      0x1e, 0x58, 0xbc, 0x88, 0xda, 0xb8, 0x9a, 0x53, 0x06, 0x8e, 0xce, 0x6b, 0x4f, 0xd2, 0x23, 0x1d,
      0xb7, 0x6d, 0xdb, 0xf0, 0xf0, 0x24, 0x49, 0xfe, 0x1b, 0xeb, 0xdd, 0xf8, 0x43, 0x7b, 0x7d, 0xe3,
      0x39, 0x5d, 0x7a, 0x1a, 0xa4, 0xef, 0xdf, 0xdd, 0x72, 0x2f, 0x54, 0xc6, 0x0c, 0xa6, 0xb5, 0x73,
      0x6f, 0x43, 0xae, 0x23, 0xab, 0x8e, 0xce, 0xe7, 0xc1, 0xf6, 0xfa, 0x63, 0x1a, 0x07, 0x2f, 0xa1,
      0xba, 0x0b, 0x2d, 0xdd, 0x70, 0xc6, 0xaa, 0x74, 0x88, 0x12, 0xb1, 0x13, 0x90, 0x5f, 0xa7, 0xa0,
      0xf6, 0x16, 0xdf, 0xe3, 0x51, 0x72, 0x7d, 0x99, 0x6d, 0x75, 0xa0, 0xfc, 0x2a, 0x09, 0xa8, 0xab,
      0x62, 0xac, 0xe3, 0x8d, 0x36, 0xee, 0x5e, 0x2e, 0xaa, 0x8a, 0xb6, 0xa2, 0xe5, 0xbf, 0x1a, 0x8c,
      0xcd, 0x95, 0x16, 0xa0, 0x04, 0x3d, 0xf8, 0x0d, 0x74, 0x6d, 0x95, 0x8f, 0xa7, 0xfc, 0x01, 0x67,
      0x37, 0x98, 0x84, 0x15, 0xda, 0x57, 0xd3, 0xf7, 0x89, 0xf4, 0xcf, 0xc3, 0x36, 0xc7, 0xf7, 0xe4,
      0xb2, 0xf8, 0x2d, 0xf0, 0xcb, 0xae, 0xf9, 0x9e, 0x9b, 0xc9, 0x66, 0xb1, 0xf2, 0x6b, 0x4b, 0x78,
      0xa9, 0x6b, 0xbe, 0x1b, 0x43, 0x56, 0xc5, 0x25, 0x8d, 0x50, 0xc4, 0x4b, 0x75, 0xa4, 0x7c, 0x46
    };

 
/* icookie */
unsigned char ic1[]=
    { 0xa7, 0xd6, 0xc1, 0x13, 0x3d, 0x55, 0x20, 0x05 };
 
/* rcookie */
unsigned char rc1[]=
    { 0x4a, 0xca, 0x03, 0x96, 0xab, 0xd4, 0xd4, 0x97 };


struct skey_rsacalc {
    chunk_t shared;
    chunk_t ni, nr;
    chunk_t gi, gr;
    chunk_t icookie, rcookie;
    size_t  keysize;
    oakley_auth_t auth;
    oakley_hash_t prf_hash;
    u_int16_t oakley_group;
} rsasc[]={
    {
	shared: { shared1, sizeof(shared1)},
	ni:     { ni1, sizeof(ni1)}, 
	nr:     { nr1, sizeof(nr1)},
	gi: { gi1, sizeof(gi1) },
	gr: { gr1, sizeof(gr1) },
	icookie: { ic1, sizeof(ic1) },
	rcookie: { rc1, sizeof(rc1) },
	keysize: 8*3,
	auth: OAKLEY_RSA_SIG,
	prf_hash: OAKLEY_MD5,
	oakley_group: OAKLEY_GROUP_MODP1536
    }
};

const chunk_t *
get_preshared_secret(const struct connection *c)
{
    osw_abort();
    return NULL;
}

void exit_log(const char *msg, ...)
{
    osw_abort();
}

struct state *
state_with_serialno(so_serial_t sn)
{
    osw_abort();
    return NULL;
}

void whack_log(int rc, const char *msg, ...)
{
    osw_abort();
}

main(int argc, char *argv[])
{
    int i;
    chunk_t expected;
    const struct hash_desc *hasher;

    progname = argv[0];
    leak_detective=1;

    cur_debugging = DBG_ALL;

    init_crypto();
    hasher = crypto_get_hasher(OAKLEY_SHA1);

    zero(&expected);

    tool_init_log();

    for(i=0; i<elemsof(psksc); i++) {
	psksc[i].pss.len = strlen(psksc[i].pss.ptr);
	psksc[i].ni.len = strlen(psksc[i].ni.ptr);
	psksc[i].nr.len = strlen(psksc[i].nr.ptr);
	skeyid_preshared(psksc[i].pss, psksc[i].ni, psksc[i].nr, hasher, &expected);
    }

    for(i=0; i<elemsof(rsasc); i++) {
	struct pcr_skeyid_q skq;
	struct pcr_skeyid_q *dhq = &skq;
	chunk_t skeyid, skeyid_d, skeyid_a, skeyid_e, new_iv, enc_key;

	DBG_log("rsa test %d\n", i);

	zero(&skq);
	dhq->thespace.start = 0;
	dhq->thespace.len   = sizeof(dhq->space);

	/* convert appropriate data to dhq */
	skq.auth = rsasc[i].auth;
	skq.prf_hash = rsasc[i].prf_hash;
	skq.oakley_group = rsasc[i].oakley_group;
	skq.keysize = rsasc[i].keysize;
	pluto_crypto_copychunk(&dhq->thespace, dhq->space, &dhq->ni,  rsasc[i].ni);
	pluto_crypto_copychunk(&dhq->thespace, dhq->space, &dhq->nr,  rsasc[i].nr);
	pluto_crypto_copychunk(&dhq->thespace, dhq->space, &dhq->gi,  rsasc[i].gi);
	pluto_crypto_copychunk(&dhq->thespace, dhq->space, &dhq->gr,  rsasc[i].gr);
	pluto_crypto_copychunk(&dhq->thespace, dhq->space, &dhq->icookie, rsasc[i].icookie);
	pluto_crypto_copychunk(&dhq->thespace, dhq->space, &dhq->rcookie, rsasc[i].rcookie);

	memset(&skeyid, 0, sizeof(skeyid));
	memset(&skeyid_d, 0, sizeof(skeyid_d));
	memset(&skeyid_a, 0, sizeof(skeyid_a));
	memset(&skeyid_e, 0, sizeof(skeyid_e));
	memset(&new_iv,   0, sizeof(new_iv));
	memset(&enc_key,  0, sizeof(enc_key));
	
	calc_skeyids_iv(&skq
			, rsasc[i].shared
			, skq.keysize
			, &skeyid, &skeyid_d, &skeyid_a, &skeyid_e
			, &new_iv, &enc_key);

	/* calc_dh_iv(dhq); */
    }

    tool_close_log();
    exit(0);
}

/*
 * Local Variables:
 * c-style: pluto
 * c-basic-offset: 4
 * compile-command: "make TEST=skeyidcalc one"
 * End:
 */
