/*
    scconfig - detection of standard library features (processes)
    Copyright (C) 2016  Tibor Palinkas

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

		Project page: http://repo.hu/projects/scconfig
		Contact via email: scconfig [at] igor2.repo.hu
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libs.h"
#include "log.h"
#include "db.h"
#include "dep.h"

int find_proc__spawnvp(int logdepth, int fatal)
{
	char *test_c =
		NL "#include <stdlib.h>"
		NL "int main() {"
		NL "	const char *a[3] = {\"/c\", \"echo OK\", NULL};"
		NL "	_spawnvp(_P_WAIT, \"cmd\", a);"
		NL "	return 0;"
		NL "}"
		NL ;

	require("cc/cc", logdepth, fatal);

	report("Checking for _spawnvp... ");
	logprintf(logdepth, "find_proc__spawnvp: trying to find _spawnvp...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/proc/_spawnvp", test_c, "#include <process.h>", NULL, NULL)) return 0;

	return try_fail(logdepth, "libs/proc/_spawnvp");
}



int find_proc_fork(int logdepth, int fatal)
{
	char *test_c =
		NL "#include <stdlib.h>"
		NL "#include <stdio.h>"
		NL "int main() {"
		NL "	if (fork() == 0) { return 0; }"
		NL "	puts(\"OK\");"
		NL "	return 0;"
		NL "}"
		NL ;

	/* NOTE: can't print OK from the child process because of a possible race
	   with the parent immediately exiting without wait(). */

	require("cc/cc", logdepth, fatal);

	report("Checking for fork... ");
	logprintf(logdepth, "find_proc_fork: trying to find fork...\n");
	logdepth++;

	if (try_icl(logdepth, "libs/proc/fork", test_c, "#include <unistd.h>", NULL, NULL)) return 0;

	return try_fail(logdepth, "libs/proc/fork");
}


int find_proc_wait(int logdepth, int fatal)
{
	char *inc;
	const char *inc1;
	char test_c[1024];
	char *test_c_in =
		NL "%s\n"
		NL "#include <stdlib.h>"
		NL "#include <stdio.h>"
		NL "int main() {"
		NL "	int st = 0;"
		NL "	if (fork() == 0) {"
		NL "		printf(\"O\");"
		NL "		return 42;"
		NL "	}"
		NL "	wait(&st);"
		NL "	if (WIFEXITED(st) && (WEXITSTATUS(st) == 42))"
		NL "		printf(\"K\");"
		NL "	else"
		NL "		printf(\"%%d\", st);"
		NL "	printf(\"\\n\");"
		NL "	return 0;"
		NL "}"
		NL ;

	require("cc/cc", logdepth, fatal);
	if (require("libs/proc/fork", logdepth, fatal))
		return try_fail(logdepth, "libs/proc/wait");

	report("Checking for wait... ");
	logprintf(logdepth, "find_proc_wait: trying to find wait...\n");
	logdepth++;

	inc1 = get("libs/proc/fork/includes");
	if (inc1 != NULL) {
		char *i, *o;
		inc = strclone(inc1);
		for(i = o = inc; *i != '\0'; i++,o++) {
			if ((i[0] == '\\') && (i[1] == 'n')) {
				*o = '\n';
				i++;
			}
			else
				*o = *i;
		}
		*o = '\0';
		sprintf(test_c, test_c_in, inc);
		free(inc);
	}
	else
		sprintf(test_c, test_c_in, "");

	if (try_icl(logdepth, "libs/proc/wait", test_c, "#include <sys/types.h>\n#include <sys/wait.h>", NULL, NULL)) return 0;

	return try_fail(logdepth, "libs/proc/wait");
}
