DEJATOOL = `pwd`/$(PROJECT)
RUNTESTFLAGS =
RUNTESTDEFAULTFLAGS = --all --tool $(PROJECT) --srcdir $$srcdir/testsuite 
EXPECT = /usr/bin/expect
RUNTEST = /usr/bin/runtest
srcdir = $(top_srcdir)

check: site.exp
	@srcdir=`cd $(srcdir) && pwd`; export srcdir; \
        EXPECT=$(EXPECT); export EXPECT; \
        if [ -x $(RUNTEST) ]; then \
            $(RUNTEST) $(RUNTESTDEFAULTFLAGS) $(RUNTESTFLAGS); exit 0; \
        else \
  	    echo "Could not find $(RUNTEST).  Is dejagnu installed?" 1>&2; :;\
        fi

site.exp: Makefile
	@echo 'Making a new site.exp file...'
	@test ! -f site.bak || rm -f site.bak
	@echo '## these variables are automatically generated by make ##' > $@-t
	@echo '# Do not edit here.  If you wish to override these values' >> $@-t
	@echo '# edit the last section' >> $@-t
	@echo 'set tool $(DEJATOOL)' >> $@-t
	@echo 'set srcdir $(srcdir)' >> $@-t
	@echo 'set objdir' `pwd` >> $@-t
	@echo '## All variables above are generated by configure. Do Not Edit ##' >> $@-t
	@test ! -f site.exp || sed '1,/^## All variables above are.*##/ d' site.exp >> $@-t
	@test ! -f site.exp || mv site.exp site.bak
	@mv $@-t site.exp
