/*	test_Animator

CVS ID: test_Animator.java,v 1.4 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Viewers.Animator;
import	PIRL.Viewers.Icons;

import	javax.swing.JFrame;
import	javax.swing.JPanel;
import	javax.swing.JButton;
import	javax.swing.JLabel;
import	javax.swing.ImageIcon;
import	java.awt.BorderLayout;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;
import	java.util.Vector;


public class test_Animator
	extends JFrame
{

private JButton
	Start_Stop_Button;
private Animator
	Animation;
private static ImageIcon[]
	Animated_Icons = new ImageIcon[0];

public test_Animator ()
{
super ("test_Animator");
JPanel
	panel = new JPanel ();

Start_Stop_Button = new JButton ("Start");
Start_Stop_Button.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent e)
	{
	if (Animation.isRunning ())
		{
		Start_Stop_Button.setText ("Start");
		Animation.stop ();
		}
	else
		{
		Start_Stop_Button.setText ("Stop");
		Animation.start ();
		}
	}});
panel.add (Start_Stop_Button);

Animation = new Animator (Animated_Icons);
Animation.setDelay (1000);
panel.add (Animation);

getContentPane ().add (panel, BorderLayout.CENTER);
setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
pack ();
}


public static void main (String[] args)
{
Load_Icons ();
test_Animator
	test = new test_Animator ();
test.setVisible (true);
}


private static void Load_Icons ()
{
int
	index = 0;
Vector
	icons = new Vector ();
ImageIcon
	icon;
System.out.println
	("Loading icons from the " + Icons.Directory () + " directory -");
while (true)
	{
	System.out.println ("Loading \"animation_" + index + ".png\"");
	icon = Icons.Load_Icon ("animation_" + index + ".png");
	if (icon == null)
		break;
	icons.add (icon);
	index++;
	}
System.out.println ("Loaded " + index + " icons.");
if (index == 0)
	{
	System.out.println ("A set of \"animation_N.png\" files are needed.");
	System.exit (1);
	}

Animated_Icons = (ImageIcon[])icons.toArray (Animated_Icons);
}

}
