/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) Andrew Howard 2003
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/***************************************************************************
 * Desc: Tests for the joystick device
 * Author: Andrew Howard
 * Date: 26 May 2002
 # CVS: $Id: test_joystick.c 8106 2009-07-23 19:14:37Z thjc $
 **************************************************************************/

#include "test.h"
#include "playerc.h"


// Basic test for joystick device.
int test_joystick(playerc_client_t *client, int index)
{
  int t;
  void *rdevice;
  playerc_joystick_t *device;

  printf("device [joystick] index [%d]\n", index);

  device = playerc_joystick_create(client, index);

  TEST("subscribing (read)");
  if (playerc_joystick_subscribe(device, PLAYER_READ_MODE) != 0)
  {
    FAIL();
    return -1;
  }
  PASS();

  for (t = 0; t < 3; t++)
  {
    TEST1("reading data (attempt %d)", t);

    do
      rdevice = playerc_client_read(client);
    while (rdevice == client);

    if (rdevice == device)
    {
      PASS();
      printf("joystick: [%.3f] [%.3f] [%X]\n",
             device->px, device->py, device->buttons);
    }
    else
      FAIL();
  }
  
  TEST("unsubscribing");
  if (playerc_joystick_unsubscribe(device) != 0)
  {
    FAIL();
    return -1;
  }
  PASS();
  
  playerc_joystick_destroy(device);
  
  return 0;
}

