;
;  Plee the Bear -- gfx script tools
;
;  Copyright (C) 2005-2010 Julien Jorge, Sebastien Angibaud
;
;  This program is free software; you can redistribute it and/or modify it
;  under the terms of the GNU General Public License as published by the
;  Free Software Foundation; either version 2 of the License, or (at your
;  option) any later version.
;
;  This program is distributed in the hope that it will be useful, but WITHOUT
;  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
;  more details.
;
;  You should have received a copy of the GNU General Public License along
;  with this program; if not, write to the Free Software Foundation, Inc.,
;  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
;
;  contact: plee-the-bear@gamned.org
;
;  Please add the tag [PTB] in the subject of your mails.
;
; --
;
; This script is intended to be run in this directory and via gimp-console:
;
;   gimp-console -b - < this_script.scm
;
(load "../common.scm")

(let ( (src_name "bouncy.xcf.bz2")
       (dest_name "bouncy.png") )
  (let ( (src_image (car (gimp-file-load 1 src_name src_name)))
         (dest_image (car (gimp-image-new 512 32 RGB)))
         )
    (let ( (bk (car (gimp-layer-new dest_image 512 32 1 "background" 100 0)))
           )
      (gimp-image-add-layer dest_image bk 0)
      )

    (create-layer src_image   '(0)   0   0 23 30 dest_image) ; 0
    (create-layer src_image   '(1)  23   0 23 30 dest_image) ; 1
    (create-layer src_image   '(2)  46   0 23 30 dest_image) ; 2
    (create-layer src_image   '(3)  69   0 23 30 dest_image) ; 3
    (create-layer src_image   '(4)  92   0 23 30 dest_image) ; 4
    (create-layer src_image   '(5) 115   0 23 30 dest_image) ; 5
    (create-layer src_image   '(6) 138   0 23 30 dest_image) ; 6
    (create-layer src_image   '(7) 161   0 23 30 dest_image) ; 7
    (create-layer src_image   '(8) 184   0 23 30 dest_image) ; 8
    (create-layer src_image   '(9) 207   0 23 30 dest_image) ; 9
    (create-layer src_image    '() 230   0 23 30 dest_image) ; space
    (create-layer src_image  '(10) 253   0 23 30 dest_image) ; p
    (create-layer src_image  '(11) 276   0 23 30 dest_image) ; s
    (create-layer src_image  '(12) 299   0 23 30 dest_image) ; t
    (create-layer src_image  '(13) 322   0 23 30 dest_image) ; u
    (create-layer src_image  '(14) 345   0 23 30 dest_image) ; :
    (create-layer src_image  '(15) 368   0 23 30 dest_image) ; /
    (create-layer src_image  '(16) 391   0 23 30 dest_image) ; .
    
    (save-frames-and-exit dest_name dest_image)
    ) ; let
  ) ; let
