#ifndef _DurationTierEditor_h_
#define _DurationTierEditor_h_
/* DurationTierEditor.h
 *
 * Copyright (C) 1992-2011,2012,2014,2015 Paul Boersma
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "RealTierEditor.h"
#include "DurationTier.h"
#include "Sound.h"

Thing_define (DurationTierEditor, RealTierEditor) {
	void v_createHelpMenuItems (EditorMenu menu)
		override;
	void v_play (double fromTime, double toTime)
		override;
	double v_minimumLegalValue ()
		override { return 0.0; }
	const char32 * v_quantityText ()
		override { return U"Relative duration"; }
	const char32 * v_quantityKey ()
		override { return U"Relative duration"; }
	const char32 * v_rightTickUnits ()
		override { return U""; }
	double v_defaultYmin ()
		override { return 0.25; }
	double v_defaultYmax ()
		override { return 3.0; }
	const char32 * v_setRangeTitle ()
		override { return U"Set duration range..."; }
	const char32 * v_defaultYminText ()
		override { return U"0.25"; }
	const char32 * v_defaultYmaxText ()
		override { return U"3.0"; }
	const char32 * v_yminText ()
		override { return U"Minimum duration"; }
	const char32 * v_ymaxText ()
		override { return U"Maximum duration"; }
	const char32 * v_yminKey ()
		override { return U"Minimum duration"; }
	const char32 * v_ymaxKey ()
		override { return U"Maximum duration"; }
};

autoDurationTierEditor DurationTierEditor_create (const char32 *title,
	DurationTier duration, Sound sound, bool ownSound);
/*
	'sound' may be null.
*/

/* End of file DurationTierEditor.h */
#endif
