/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableInfo;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeInfo;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationElementValue;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ArrayElementValue;
import proguard.classfile.attribute.annotation.ClassElementValue;
import proguard.classfile.attribute.annotation.ConstantElementValue;
import proguard.classfile.attribute.annotation.EnumConstantElementValue;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.annotation.visitor.AnnotationVisitor;
import proguard.classfile.attribute.annotation.visitor.ElementValueVisitor;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableInfoVisitor;
import proguard.classfile.attribute.visitor.LocalVariableTypeInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolRemapper;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class Utf8Shrinker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
LocalVariableInfoVisitor,
LocalVariableTypeInfoVisitor,
AnnotationVisitor,
ElementValueVisitor {
    private static final Object USED = new Object();
    private int[] constantIndexMap = new int[256];
    private final ConstantPoolRemapper constantPoolRemapper = new ConstantPoolRemapper();

    public void visitProgramClass(ProgramClass programClass) {
        programClass.constantPoolEntriesAccept(this);
        programClass.fieldsAccept(this);
        programClass.methodsAccept(this);
        programClass.attributesAccept(this);
        int n = this.shrinkConstantPool(programClass.constantPool, programClass.u2constantPoolCount);
        if (n < programClass.u2constantPoolCount) {
            programClass.u2constantPoolCount = n;
            this.constantPoolRemapper.setConstantIndexMap(this.constantIndexMap);
            this.constantPoolRemapper.visitProgramClass(programClass);
        }
    }

    public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
        this.markCpUtf8Entry(programClass, programMember.u2nameIndex);
        this.markCpUtf8Entry(programClass, programMember.u2descriptorIndex);
        programMember.attributesAccept(programClass, this);
    }

    public void visitAnyConstant(Clazz clazz, Constant constant) {
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.markCpUtf8Entry(clazz, stringConstant.u2stringIndex);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.markCpUtf8Entry(clazz, classConstant.u2nameIndex);
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.markCpUtf8Entry(clazz, nameAndTypeConstant.u2nameIndex);
        this.markCpUtf8Entry(clazz, nameAndTypeConstant.u2descriptorIndex);
    }

    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        this.markCpUtf8Entry(clazz, unknownAttribute.u2attributeNameIndex);
    }

    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.markCpUtf8Entry(clazz, sourceFileAttribute.u2attributeNameIndex);
        this.markCpUtf8Entry(clazz, sourceFileAttribute.u2sourceFileIndex);
    }

    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.markCpUtf8Entry(clazz, sourceDirAttribute.u2attributeNameIndex);
        this.markCpUtf8Entry(clazz, sourceDirAttribute.u2sourceDirIndex);
    }

    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        this.markCpUtf8Entry(clazz, innerClassesAttribute.u2attributeNameIndex);
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.markCpUtf8Entry(clazz, enclosingMethodAttribute.u2attributeNameIndex);
    }

    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        this.markCpUtf8Entry(clazz, deprecatedAttribute.u2attributeNameIndex);
    }

    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        this.markCpUtf8Entry(clazz, syntheticAttribute.u2attributeNameIndex);
    }

    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.markCpUtf8Entry(clazz, signatureAttribute.u2attributeNameIndex);
        this.markCpUtf8Entry(clazz, signatureAttribute.u2signatureIndex);
    }

    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.markCpUtf8Entry(clazz, constantValueAttribute.u2attributeNameIndex);
    }

    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.markCpUtf8Entry(clazz, exceptionsAttribute.u2attributeNameIndex);
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.markCpUtf8Entry(clazz, codeAttribute.u2attributeNameIndex);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.markCpUtf8Entry(clazz, stackMapAttribute.u2attributeNameIndex);
    }

    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.markCpUtf8Entry(clazz, stackMapTableAttribute.u2attributeNameIndex);
    }

    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.markCpUtf8Entry(clazz, lineNumberTableAttribute.u2attributeNameIndex);
    }

    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
        this.markCpUtf8Entry(clazz, localVariableTableAttribute.u2attributeNameIndex);
        localVariableTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
        this.markCpUtf8Entry(clazz, localVariableTypeTableAttribute.u2attributeNameIndex);
        localVariableTypeTableAttribute.localVariablesAccept(clazz, method, codeAttribute, this);
    }

    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
        this.markCpUtf8Entry(clazz, annotationsAttribute.u2attributeNameIndex);
        annotationsAttribute.annotationsAccept(clazz, this);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        this.markCpUtf8Entry(clazz, parameterAnnotationsAttribute.u2attributeNameIndex);
        parameterAnnotationsAttribute.annotationsAccept(clazz, method, this);
    }

    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
        this.markCpUtf8Entry(clazz, annotationDefaultAttribute.u2attributeNameIndex);
        annotationDefaultAttribute.defaultValueAccept(clazz, this);
    }

    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerNameIndex != 0) {
            this.markCpUtf8Entry(clazz, innerClassesInfo.u2innerNameIndex);
        }
    }

    public void visitLocalVariableInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableInfo localVariableInfo) {
        this.markCpUtf8Entry(clazz, localVariableInfo.u2nameIndex);
        this.markCpUtf8Entry(clazz, localVariableInfo.u2descriptorIndex);
    }

    public void visitLocalVariableTypeInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeInfo localVariableTypeInfo) {
        this.markCpUtf8Entry(clazz, localVariableTypeInfo.u2nameIndex);
        this.markCpUtf8Entry(clazz, localVariableTypeInfo.u2signatureIndex);
    }

    public void visitAnnotation(Clazz clazz, Annotation annotation) {
        this.markCpUtf8Entry(clazz, annotation.u2typeIndex);
        annotation.elementValuesAccept(clazz, this);
    }

    public void visitConstantElementValue(Clazz clazz, Annotation annotation, ConstantElementValue constantElementValue) {
        if (constantElementValue.u2elementNameIndex != 0) {
            this.markCpUtf8Entry(clazz, constantElementValue.u2elementNameIndex);
        }
        if (constantElementValue.u1tag == 115) {
            this.markCpUtf8Entry(clazz, constantElementValue.u2constantValueIndex);
        }
    }

    public void visitEnumConstantElementValue(Clazz clazz, Annotation annotation, EnumConstantElementValue enumConstantElementValue) {
        if (enumConstantElementValue.u2elementNameIndex != 0) {
            this.markCpUtf8Entry(clazz, enumConstantElementValue.u2elementNameIndex);
        }
        this.markCpUtf8Entry(clazz, enumConstantElementValue.u2typeNameIndex);
        this.markCpUtf8Entry(clazz, enumConstantElementValue.u2constantNameIndex);
    }

    public void visitClassElementValue(Clazz clazz, Annotation annotation, ClassElementValue classElementValue) {
        if (classElementValue.u2elementNameIndex != 0) {
            this.markCpUtf8Entry(clazz, classElementValue.u2elementNameIndex);
        }
        this.markCpUtf8Entry(clazz, classElementValue.u2classInfoIndex);
    }

    public void visitAnnotationElementValue(Clazz clazz, Annotation annotation, AnnotationElementValue annotationElementValue) {
        if (annotationElementValue.u2elementNameIndex != 0) {
            this.markCpUtf8Entry(clazz, annotationElementValue.u2elementNameIndex);
        }
        annotationElementValue.annotationAccept(clazz, this);
    }

    public void visitArrayElementValue(Clazz clazz, Annotation annotation, ArrayElementValue arrayElementValue) {
        if (arrayElementValue.u2elementNameIndex != 0) {
            this.markCpUtf8Entry(clazz, arrayElementValue.u2elementNameIndex);
        }
        arrayElementValue.elementValuesAccept(clazz, annotation, this);
    }

    private void markCpUtf8Entry(Clazz clazz, int n) {
        this.markAsUsed((Utf8Constant)((ProgramClass)clazz).getConstant(n));
    }

    private void markAsUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(USED);
    }

    private boolean isUsed(VisitorAccepter visitorAccepter) {
        return visitorAccepter.getVisitorInfo() == USED;
    }

    private int shrinkConstantPool(Constant[] constantArray, int n) {
        if (this.constantIndexMap.length < n) {
            this.constantIndexMap = new int[n];
        }
        int n2 = 1;
        boolean bl = false;
        for (int i = 1; i < n; ++i) {
            this.constantIndexMap[i] = n2;
            Constant constant = constantArray[i];
            if (constant != null) {
                boolean bl2 = bl = constant.getTag() != 1 || this.isUsed(constant);
            }
            if (!bl) continue;
            constantArray[n2++] = constant;
        }
        Arrays.fill(constantArray, n2, n, null);
        return n2;
    }
}

