//  Copyright (c) 2014 Anton Bikineev
//  Use, modification and distribution are subject to the
//  Boost Software License, Version 1.0. (See accompanying file
//  LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

   static const boost::array<boost::array<typename table_type<T>::type, 3>, 450
#if LDBL_MAX_10_EXP < 370
      - 36
#endif
   > bessel_i_prime_data = {{
      {{ SC_(-0.8049192047119140625e2), SC_(0.24750102996826171875e2), SC_(-142534136299562130024973134221.99005521993999868526) }}, 
      {{ SC_(-0.8049192047119140625e2), SC_(0.637722015380859375e2), SC_(3266802.8196736368245987228932389940584716010368863) }}, 
      {{ SC_(-0.7460263824462890625e2), SC_(0.24750102996826171875e2), SC_(-2291130167743201604923486.7470168394180873251146683) }}, 
      {{ SC_(-0.7460263824462890625e2), SC_(0.637722015380859375e2), SC_(1344490102.0814298977326531771280029458266767233075) }}, 
      {{ SC_(-0.7290460205078125e2), SC_(0.24750102996826171875e2), SC_(-32540376529649616064637.054384142008796248247633549) }}, 
      {{ SC_(-0.7290460205078125e2), SC_(0.637722015380859375e2), SC_(7147268346.3248078929703647247611304885252038670462) }}, 
      {{ SC_(-0.62323604583740234375e2), SC_(0.24750102996826171875e2), SC_(-990349288161909.27877000203289482196681509723184343) }}, 
      {{ SC_(-0.62323604583740234375e2), SC_(0.637722015380859375e2), SC_(119443067019517.62291415298106980016813953495181988) }}, 
      {{ SC_(-0.5579319000244140625e2), SC_(0.24750102996826171875e2), SC_(19023942618.631889641004140617446508059806168301492) }}, 
      {{ SC_(-0.5579319000244140625e2), SC_(0.637722015380859375e2), SC_(25951554033686744.924489835522535920574130661280939) }}, 
      {{ SC_(-0.4430035400390625e2), SC_(0.95070552825927734375e1), SC_(-139935955680816392142241.6017739312504406079396547) }}, 
      {{ SC_(-0.4430035400390625e2), SC_(0.24750102996826171875e2), SC_(-1316.4819205264052438206308151294983883218464343657) }}, 
      {{ SC_(-0.4430035400390625e2), SC_(0.637722015380859375e2), SC_(97659860560077602476.5334648266576340476103312936) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.51139926910400390625e1), SC_(-21886385122041931939808640058.436968667167426884987) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.95070552825927734375e1), SC_(-366409917635868618.57259467125590453834420202165244) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.24750102996826171875e2), SC_(-0.65676331363722000059647957905593102805970617578866) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.637722015380859375e2), SC_(3557012660759047650461.532327709948603014817941907) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.177219114266335964202880859375e-2), SC_(1.4833367404804201575176799553131990442005390200221e-31) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.22177286446094512939453125e-2), SC_(9.7067363329468854142395046595693155072217998479942e-31) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.7444499991834163665771484375e-2), SC_(2.4682929270337628797042098965059154632607360182696e-26) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.1433600485324859619140625e-1), SC_(5.9735339257834716574183494832987740754773091009375e-24) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.1760916970670223236083984375e-1), SC_(3.3444608178960899374763518228608434403750200803958e-23) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.6152711808681488037109375e-1), SC_(1.1897217647554727497828427765278925609778771252694e-18) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.11958599090576171875e0), SC_(3.112388457299505077603547753672491840287143218901e-16) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.15262925624847412109375e0), SC_(2.4029211462799040331579944694685556203211458958864e-15) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.408089816570281982421875e0), SC_(9.1248397371567801754347274160120968479044369622808e-12) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.6540834903717041015625e0), SC_(4.7824858061924877937035072754189112286627442784541e-10) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.1097540378570556640625e1), SC_(3.7357157150377308603849917033639687198183694823432e-08) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.30944411754608154296875e1), SC_(0.00028020048280478142178576824790264733624837467921411) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.51139926910400390625e1), SC_(0.029788046942789361031443182853628675678245310369738) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.95070552825927734375e1), SC_(26.790075656171534352605317140741843098322239283698) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.24750102996826171875e2), SC_(793253115.04894282077189591606690873895096254021978) }}, 
      {{ SC_(0.93762989044189453125e1), SC_(0.637722015380859375e2), SC_(124597532591880012929558741.1798487805702969053126) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.177219114266335964202880859375e-2), SC_(7.9393797427103935193312904118641365643393472110682e-32) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.22177286446094512939453125e-2), SC_(5.2750361873309848688111983240733858118506477606492e-31) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.7444499991834163665771484375e-2), SC_(1.4561850484459152000175324059092409330365341115566e-26) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.1433600485324859619140625e-1), SC_(3.6842735867028953425506020308884251003040007247277e-24) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.1760916970670223236083984375e-1), SC_(2.0917201163762906692944412202556845245361847731237e-23) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.6152711808681488037109375e-1), SC_(8.099724957137276546627350759114925458695705536831e-19) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.11958599090576171875e0), SC_(2.2166188303591576397287172828602526472428149190877e-16) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.15262925624847412109375e0), SC_(1.7398898295816921704025845808278773511501789661039e-15) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.408089816570281982421875e0), SC_(7.0625243779726096513575976577390827520115876914691e-12) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.6540834903717041015625e0), SC_(3.8217061180073757347806489526965144626367691098288e-10) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.1097540378570556640625e1), SC_(3.0913372973610985976471301589555712666730023107543e-08) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.30944411754608154296875e1), SC_(0.00024830676215071733631164447908300056546252338891911) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.51139926910400390625e1), SC_(0.027225037364339635343941718253802560863885329512512) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.95070552825927734375e1), SC_(25.296697292204887546137285781211352894138008158535) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.24750102996826171875e2), SC_(773887818.69440844099959239658824877395876924432055) }}, 
      {{ SC_(0.944411754608154296875e1), SC_(0.637722015380859375e2), SC_(123371059205722849456522471.39199589118773988433275) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2286252390380290844561278210597794601482999571983e-104) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.22177286446094512939453125e-2), SC_(3.7181168789004272463796407464346105515848606922329e-102) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.7444499991834163665771484375e-2), SC_(9.2610851221489173483182330607686343001719727741597e-89) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.1433600485324859619140625e-1), SC_(1.643476887122182179956901151590609432640352852077e-81) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.1760916970670223236083984375e-1), SC_(3.0950958199468447682336413996941870547152191981674e-79) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.6152711808681488037109375e-1), SC_(2.1392038603823891823422157728886539760760291580653e-65) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.11958599090576171875e0), SC_(4.8064400564807594070701023433867803573129630888345e-58) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.15262925624847412109375e0), SC_(2.4032291539568302335053149943843587858638571389874e-55) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.408089816570281982421875e0), SC_(1.8234350315474405459152584644263976003971834673721e-44) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.6540834903717041015625e0), SC_(3.0241871675691159181451491339277900952524486071002e-39) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.1097540378570556640625e1), SC_(1.6205375716163189419960176666595505199258671513103e-33) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.30944411754608154296875e1), SC_(5.1477930447574412268206532943451913765254330040223e-22) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.51139926910400390625e1), SC_(2.1827206165702638933845082222556521417430730380844e-16) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.95070552825927734375e1), SC_(2.9195970485656579467760872558336916432951033483332e-09) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.24750102996826171875e2), SC_(10826.527068717066528491846218450353760561479759982) }}, 
      {{ SC_(0.264718532562255859375e2), SC_(0.637722015380859375e2), SC_(1138075386232486817219014.8052993051304724020136075) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.177219114266335964202880859375e-2), SC_(1.632362010614025868688932327750627876605396014588e-275) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.22177286446094512939453125e-2), SC_(1.762381436841527011849001278447617221768896515477e-269) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.7444499991834163665771484375e-2), SC_(6.6759847143868307027065445521849777871007306954136e-237) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.1433600485324859619140625e-1), SC_(2.8413744248913192676665654065072379053073155149995e-219) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.1760916970670223236083984375e-1), SC_(9.6796251519365738433769389146932410237305854016773e-214) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.6152711808681488037109375e-1), SC_(4.3868562810147839682491489589259890784816573040545e-180) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.11958599090576171875e0), SC_(3.3133885952180986858287524787023329689682116102751e-162) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.15262925624847412109375e0), SC_(1.2128190016563561979755446838988618653681374993639e-155) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.408089816570281982421875e0), SC_(3.4814116521283384702517328106396550498484169139948e-129) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.6540834903717041015625e0), SC_(1.7111604293099981058811517931076833381871921804211e-116) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.1097540378570556640625e1), SC_(1.4422544328066011890557231387613912785242406476365e-102) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.30944411754608154296875e1), SC_(1.1451154629918412504592632865401292332327654879585e-74) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.51139926910400390625e1), SC_(4.0070673607625816553677715219345898864142088217776e-61) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.95070552825927734375e1), SC_(2.4875262867594197642521228223206333835260900106824e-44) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.24750102996826171875e2), SC_(1.0725853101609339090593117055019026769846147589987e-17) }}, 
      {{ SC_(0.62944732666015625e2), SC_(0.637722015380859375e2), SC_(69806774000991.981050098476617116562579929772726245) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.177219114266335964202880859375e-2), SC_(3.0795075713373245170564693209507552885531668052322e-295) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.22177286446094512939453125e-2), SC_(8.2585814147621235194686725245004192244997424675025e-289) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.7444499991834163665771484375e-2), SC_(4.2559329352980990333465412959416506363209167587173e-254) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.1433600485324859619140625e-1), SC_(2.5857906110824316476302796916108192832705011750687e-235) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.1760916970670223236083984375e-1), SC_(2.0288735053710467855117165534842590974767207207859e-229) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.6152711808681488037109375e-1), SC_(1.4716924210346402659960982541246335667937580263824e-193) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.11958599090576171875e0), SC_(1.6475324190637916449886602361066243304687776777444e-174) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.15262925624847412109375e0), SC_(1.6226453660019147553054614873926171882634928426372e-167) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.408089816570281982421875e0), SC_(2.5175324481503500570184737845026562070532546627185e-139) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.6540834903717041015625e0), SC_(8.3881308654401361699945722134397500006097045735341e-126) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.1097540378570556640625e1), SC_(5.7715122879778170240728020870949990083309248355342e-111) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.30944411754608154296875e1), SC_(3.0654395547893837002052218519388992244041349516261e-81) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.51139926910400390625e1), SC_(8.2003984081112594307363027866319782488192555860671e-67) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.95070552825927734375e1), SC_(6.200490108030621481717367383544868119732779991649e-49) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.24750102996826171875e2), SC_(1.1484072822157114435741678836431453415625281354583e-20) }}, 
      {{ SC_(0.67001708984375e2), SC_(0.637722015380859375e2), SC_(1882431939202.1648135308211699453194754099827646073) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.177219114266335964202880859375e-2), SC_(7.1993058715176692707909545977542101576978902629997e-365) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.22177286446094512939453125e-2), SC_(4.6189647675920818228477787495300927648880227749548e-357) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.7444499991834163665771484375e-2), SC_(6.637653229579832943601390616060165246442539943324e-315) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.1433600485324859619140625e-1), SC_(4.3102132572399443285127078566331609500823755904228e-292) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.1760916970670223236083984375e-1), SC_(6.2158948593041667580197386192485645449767163129178e-285) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.6152711808681488037109375e-1), SC_(2.2170706972561526295259801840425237167479458891492e-241) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.11958599090576171875e0), SC_(3.0241607708249140489586281304097109739647176465164e-218) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.15262925624847412109375e0), SC_(9.418847738799939103168386855858431832591248936811e-210) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.408089816570281982421875e0), SC_(1.6265930491345472772111976569894816356870485147153e-175) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.6540834903717041015625e0), SC_(4.3080115194438098150087717213388986951797779271287e-159) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.1097540378570556640625e1), SC_(4.5073098911157230329481517944589083374841589800605e-141) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.30944411754608154296875e1), SC_(5.6167794494214786296478563730194863567468472683289e-105) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.51139926910400390625e1), SC_(1.822656617706300448539503357453364760270365438864e-87) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.95070552825927734375e1), SC_(8.5704891337692157403434649287602372160066937779083e-66) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.24750102996826171875e2), SC_(8.6881113707816421353442513653795258602893726841149e-32) }}, 
      {{ SC_(0.8115838623046875e2), SC_(0.637722015380859375e2), SC_(1617649.4354678485627380481219136110430921391331897) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.177219114266335964202880859375e-2), SC_(2.1337314780433023071253830818680635341102390423424e-372) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.22177286446094512939453125e-2), SC_(1.9236468477598653871005466718621584242716472509795e-364) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.7444499991834163665771484375e-2), SC_(1.7350558469277704916806297676840604397934753883088e-321) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.1433600485324859619140625e-1), SC_(3.044131111243828481505732791395440428410252467497e-298) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.1760916970670223236083984375e-1), SC_(5.9969912201526959957889453725088739277567897075027e-291) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.6152711808681488037109375e-1), SC_(1.4266594725898433542013786706157135640259186846101e-246) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.11958599090576171875e0), SC_(5.3322472505503945805669306065156969299274872366813e-223) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.15262925624847412109375e0), SC_(2.4044604452865816807064344460494732181924838017599e-214) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.408089816570281982421875e0), SC_(1.845615210278874980268444611142904946297868235348e-179) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.6540834903717041015625e0), SC_(9.9974095177384560300881151990910235045207409722762e-163) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.1097540378570556640625e1), SC_(2.2933085190276181755163341575742980201744586021307e-144) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.30944411754608154296875e1), SC_(1.3760068297929422035121422541344836370023463362112e-107) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.51139926910400390625e1), SC_(9.5576508613049726576106420556767384976606107970553e-90) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.95070552825927734375e1), SC_(1.146825152638600062498145160892476430739737467161e-67) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.24750102996826171875e2), SC_(4.8202778062425803121906942399051869824382907581079e-33) }}, 
      {{ SC_(0.826751708984375e2), SC_(0.637722015380859375e2), SC_(321545.92541685474819558905268688047015358187110107) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.177219114266335964202880859375e-2), SC_(1.9420356342138526889257234094828532249379931857193e-416) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.22177286446094512939453125e-2), SC_(1.2673457667528725255614876439435750775206880096062e-407) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.7444499991834163665771484375e-2), SC_(5.0120856794029180893564370961271669747845203722658e-360) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.1433600485324859619140625e-1), SC_(2.8578414266328775608393218254761072916472326765375e-334) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.1760916970670223236083984375e-1), SC_(3.4576589617854072255491833815950179765493097214576e-326) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.6152711808681488037109375e-1), SC_(5.1367055010288925434184639689708542128550374448043e-277) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.11958599090576171875e0), SC_(6.7707110514152055469426755384612859295996162434507e-251) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.15262925624847412109375e0), SC_(2.6299157791650666290094679911691206263072932777858e-241) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.408089816570281982421875e0), SC_(1.1881552611574945474151890493098342570198940780072e-202) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.6540834903717041015625e0), SC_(4.1387935853828150079064007340994906098391763595023e-184) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.1097540378570556640625e1), SC_(9.1488143720178502044269620748256985678652513304794e-164) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.30944411754608154296875e1), SC_(5.1481853461542550612979530615983083899789511977363e-123) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.51139926910400390625e1), SC_(2.9986211058440061810577069363569118709007799757606e-103) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.95070552825927734375e1), SC_(8.4055558601500789473580514095070639830784144103471e-79) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.24750102996826171875e2), SC_(1.4138089014232647985841023858383320068408072754542e-40) }}, 
      {{ SC_(0.9150136566162109375e2), SC_(0.637722015380859375e2), SC_(17.28589515499288087293873997915746434993105371068) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.177219114266335964202880859375e-2), SC_(7.6618863611058558853122002433870633875250464831379e-424) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.22177286446094512939453125e-2), SC_(6.962502149506368312787985506753589166487217730338e-415) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.7444499991834163665771484375e-2), SC_(1.6456315640366475428477104383402048686105366825932e-366) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.1433600485324859619140625e-1), SC_(2.4689135196236308311980218814818473304652627086375e-340) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.1760916970670223236083984375e-1), SC_(4.0467125031170780221174588410861383946818829905602e-332) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.6152711808681488037109375e-1), SC_(3.8118669818966907957780884496228282993229577709856e-282) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.11958599090576171875e0), SC_(1.3402237339470433362399803365824856869577484600303e-255) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.15262925624847412109375e0), SC_(7.4629972928947281844431866187302467357712130198734e-246) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.408089816570281982421875e0), SC_(1.4401591890850019248433932932485186260115263118742e-206) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.6540834903717041015625e0), SC_(1.0066383715499410337341678883003839879567113504005e-187) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.1097540378570556640625e1), SC_(4.7776096177154649384991611413700359005353321203558e-167) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.30944411754608154296875e1), SC_(1.2414461979488675628422602830370682216021538848639e-125) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.51139926910400390625e1), SC_(1.5169811003777042945959637574955936357347003287343e-105) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.95070552825927734375e1), SC_(1.059135167534398759163888143455767603228133421273e-80) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.24750102996826171875e2), SC_(7.1531683828857561354263752868485539030922509279303e-42) }}, 
      {{ SC_(0.9297769927978515625e2), SC_(0.637722015380859375e2), SC_(3.1140752263668997442734896574305738869767905751981) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.177219114266335964202880859375e-2), SC_(1.1661277757218256260409430215822949722914656717031e-426) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.22177286446094512939453125e-2), SC_(1.2018324123453446354096977880675155644270790204158e-417) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.7444499991834163665771484375e-2), SC_(5.6054076194175039575244446266311430330206643551553e-369) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.1433600485324859619140625e-1), SC_(1.2148385824756112587081375497421817138615867641022e-342) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.1760916970670223236083984375e-1), SC_(2.2348274624894144625770117300774428742332446484079e-334) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.6152711808681488037109375e-1), SC_(4.2485632890109563179987324153449202788837008882968e-284) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.11958599090576171875e0), SC_(2.1690856412592241284676264176655596346119701828162e-257) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.15262925624847412109375e0), SC_(1.3851128670629291186758575024616184151857112539491e-247) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.408089816570281982421875e0), SC_(4.6421277384739523422371340222665902147491772786676e-208) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.6540834903717041015625e0), SC_(4.2283723224704485547956045759458418333219191488477e-189) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.1097540378570556640625e1), SC_(2.6833358132717840691517100908105954462406974502051e-168) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.30944411754608154296875e1), SC_(1.247390104924330321042470965173720099076338502325e-126) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.51139926910400390625e1), SC_(2.020210047102409613023936980279078597139872222018e-106) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.95070552825927734375e1), SC_(1.9955251551926842925930555683640515631686061422485e-81) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.24750102996826171875e2), SC_(2.2867175418426324837359952674106145152422588783687e-42) }}, 
      {{ SC_(0.935389862060546875e2), SC_(0.637722015380859375e2), SC_(1.6147998222697175519782091211015094728796977518207) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.177219114266335964202880859375e-2), SC_(7.7407174681492540071999304897751173868684457437001e-428) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.22177286446094512939453125e-2), SC_(8.4086432798610158915026658254613097148281508578832e-419) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.7444499991834163665771484375e-2), SC_(5.2102397935309216070908245075051523777780039797954e-370) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.1433600485324859619140625e-1), SC_(1.3168215731211130848666344876761031623388840757876e-343) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.1760916970670223236083984375e-1), SC_(2.542156460770037475292219713467756455481900491816e-335) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.6152711808681488037109375e-1), SC_(6.4811274794530063129506457913591001481117097235721e-285) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.11958599090576171875e0), SC_(3.8671074049480457796226812986921044241949880135038e-258) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.15262925624847412109375e0), SC_(2.6148662205325438996486588632560171879973109944242e-248) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.408089816570281982421875e0), SC_(1.1037519208447777671705164118921036226392271960928e-208) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.6540834903717041015625e0), SC_(1.1230151633521670238426547982117929969308447859491e-189) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.1097540378570556640625e1), SC_(8.0466338727228345610326173987873011127073893987258e-169) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.30944411754608154296875e1), SC_(4.7699371229309282685368620449590413606875117758542e-127) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.51139926910400390625e1), SC_(8.6903353584621284959691334563490081337002544783555e-107) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.95070552825927734375e1), SC_(9.9237330880770727584989103434947342823156386680536e-82) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.24750102996826171875e2), SC_(1.4184074632248481117747733128461549835737275401749e-42) }}, 
      {{ SC_(0.937735595703125e2), SC_(0.637722015380859375e2), SC_(1.2262087826458825244894568674316053325965399278318) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.177219114266335964202880859375e-2), SC_(5.1934668546157384097187677930546335775551093249245e-452) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.22177286446094512939453125e-2), SC_(1.6564375965270384518417875777876145019824624752511e-442) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.7444499991834163665771484375e-2), SC_(3.4449197120473817490306315407857492468933163272697e-391) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.1433600485324859619140625e-1), SC_(2.0261067427217268882764404798020620490244315528898e-363) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.1760916970670223236083984375e-1), SC_(1.0501968055478962199726801014833998389731255645277e-354) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.6152711808681488037109375e-1), SC_(1.0893333354890297332144228152538296498299371883906e-301) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.11958599090576171875e0), SC_(1.5813286841700678191351937520033292476413518543747e-273) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.15262925624847412109375e0), SC_(3.4511773402735000615146412720239233966192751056587e-263) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.408089816570281982421875e0), SC_(1.639464995580696838283506031532612591832810098039e-221) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.6540834903717041015625e0), SC_(1.6075588383847372939491059578822319391219082116837e-201) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.1097540378570556640625e1), SC_(1.383367960474755330837001872339252895647146189204e-179) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.30944411754608154296875e1), SC_(1.1894547122266173284580504405934836255140398237346e-135) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.51139926910400390625e1), SC_(2.4141410173177178007591210449414366774973156433676e-114) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.95070552825927734375e1), SC_(5.3705913195666332157368504472534602682347597904246e-88) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.24750102996826171875e2), SC_(7.1057971431288206847704264194041343716457271036256e-47) }}, 
      {{ SC_(0.98576263427734375e2), SC_(0.637722015380859375e2), SC_(0.0039345019880193955268905974769199918011548388459448) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.177219114266335964202880859375e-2), SC_(1.2669013491383325664362949890567337966880131879219e-455) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.22177286446094512939453125e-2), SC_(4.7445792264691913698239760210387810671521193426311e-446) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.7444499991834163665771484375e-2), SC_(2.3483744633355519061337833910315333769185413776926e-394) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.1433600485324859619140625e-1), SC_(2.2081056218712490205081864702951174353423511390333e-366) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.1760916970670223236083984375e-1), SC_(1.3260961326906320083521649120762449877306863066949e-357) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.6152711808681488037109375e-1), SC_(3.3689112308888555541155780863328611537293119215684e-304) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.11958599090576171875e0), SC_(7.8704444271803266449410224277205927589659149607199e-276) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.15262925624847412109375e0), SC_(2.0455506154335438653697128280863307177593737433096e-265) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.408089816570281982421875e0), SC_(1.9649968937054947083507693323325306115786423657801e-223) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.6540834903717041015625e0), SC_(2.7009554486387227542069707937331979556217406548287e-203) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.1097540378570556640625e1), SC_(3.3669018281214257622929975926519987609804001563885e-181) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.30944411754608154296875e1), SC_(6.0798127566409819483912000773989019132264961627001e-137) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.51139926910400390625e1), SC_(1.7676119678602966764380062800375583149171867312673e-115) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.95070552825927734375e1), SC_(6.1226313979466826145691556576771473978778277352618e-89) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.24750102996826171875e2), SC_(1.5919660033638893814293912578681090424440634920881e-47) }}, 
      {{ SC_(0.99292266845703125e2), SC_(0.637722015380859375e2), SC_(0.001643352512064229232537155624609682872404513604206) }},
      {{ SC_(-0.8049192047119140625e2), SC_(0.24750102996826171875e2), SC_(-142534136299562130024973134221.99005521993999868526) }}, 
      {{ SC_(-0.8049192047119140625e2), SC_(0.637722015380859375e2), SC_(3266802.8196736368245987228932389940584716010368864) }}, 
      {{ SC_(-0.7460263824462890625e2), SC_(0.24750102996826171875e2), SC_(-2291130167743201604923486.7470168394180873251146681) }}, 
      {{ SC_(-0.7460263824462890625e2), SC_(0.637722015380859375e2), SC_(1344490102.0814298977272341572892204840223370775278) }}, 
      {{ SC_(-0.7290460205078125e2), SC_(0.24750102996826171875e2), SC_(-32540376529649616064637.054384142008796248247633547) }}, 
      {{ SC_(-0.7290460205078125e2), SC_(0.637722015380859375e2), SC_(7147268346.3248078929700515659440325768166931925406) }}, 
      {{ SC_(-0.62323604583740234375e2), SC_(0.24750102996826171875e2), SC_(-990349288161909.27877000203289482196681509723184338) }}, 
      {{ SC_(-0.62323604583740234375e2), SC_(0.637722015380859375e2), SC_(119443067019517.62291415298106975048197554107039373) }}, 
      {{ SC_(-0.5579319000244140625e2), SC_(0.24750102996826171875e2), SC_(19023942618.63188964100414061744650805980616830149) }}, 
      {{ SC_(-0.5579319000244140625e2), SC_(0.637722015380859375e2), SC_(25951554033686744.924489835522535920728728882015316) }}, 
      {{ SC_(-0.4430035400390625e2), SC_(0.95070552825927734375e1), SC_(-139935955680816392142241.60177393125044060793965467) }}, 
      {{ SC_(-0.4430035400390625e2), SC_(0.24750102996826171875e2), SC_(-1316.4819205264052438206308151294983883218464343657) }}, 
      {{ SC_(-0.4430035400390625e2), SC_(0.637722015380859375e2), SC_(97659860560077602476.533464826657634047610280907291) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.51139926910400390625e1), SC_(-21886385122041931939808640058.436968667167426884978) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.95070552825927734375e1), SC_(-366409917635868618.57259467125590453834420202165236) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.24750102996826171875e2), SC_(-0.6567633136372200005964795790559310280597061757886) }}, 
      {{ SC_(-0.383665924072265625e2), SC_(0.637722015380859375e2), SC_(3557012660759047650461.5323277099486030148179404112) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.177219114266335964202880859375e-2), SC_(5928787480108492273386443973502201613.2104226142045) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.22177286446094512939453125e-2), SC_(578544434222930227012211526728290601.67692334689962) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.7444499991834163665771484375e-2), SC_(2019106024338782072782272346827.7397893450443720171) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.1433600485324859619140625e-1), SC_(2249777932840906941081387011.8592620899288436489217) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.1760916970670223236083984375e-1), SC_(266332187950518179744316053.33048498267580575321332) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.6152711808681488037109375e-1), SC_(613278382880584235716.63862864283403037030270136651) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.11958599090576171875e0), SC_(620594709872032084.62142009260190981637108304577042) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.15262925624847412109375e0), SC_(49348033460312345.550253266028646878127007507781007) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.408089816570281982421875e0), SC_(1819305541880.6175746955948729073107365105870071701) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.6540834903717041015625e0), SC_(13532335926.658068996843002543835788336523147488057) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.1097540378570556640625e1), SC_(61801568.108314261951666324064578498185658122747007) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.30944411754608154296875e1), SC_(1084.4874571704103314624633698779779585749183060697) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.51139926910400390625e1), SC_(4.0706523491953985430915865382707182818496973019714) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.95070552825927734375e1), SC_(26.79170035854544765328152997059591620396081015675) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.24750102996826171875e2), SC_(793253115.04894282078793518265852873411745046750291) }}, 
      {{ SC_(-0.93762989044189453125e1), SC_(0.637722015380859375e2), SC_(124597532591880012929558741.1798487805702969053126) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.177219114266335964202880859375e-2), SC_(11870701914724842965194669916327701131.111840859821) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.22177286446094512939453125e-2), SC_(1140884938788284296084979810184674007.6366447698394) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.7444499991834163665771484375e-2), SC_(3667723528588485205714315779958.3063861649905112593) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.1433600485324859619140625e-1), SC_(3909096978895984818921041899.8191320873607036987618) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.1760916970670223236083984375e-1), SC_(456355745302161343536567751.76956955007850507294856) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.6152711808681488037109375e-1), SC_(965361539479369750508.56484522640607318330844354314) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.11958599090576171875e0), SC_(933829668081199677.26358508845402817098996576995208) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.15262925624847412109375e0), SC_(73037200065805757.733169112925360069442635405483859) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.408089816570281982421875e0), SC_(2518965714687.7696670995135554526164544979014221313) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.6540834903717041015625e0), SC_(18147262562.295332045114732062710295772042786857805) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.1097540378570556640625e1), SC_(80027886.603886422772495691225695338614045140777889) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.30944411754608154296875e1), SC_(1310.5469354285125789356457692777860602279344600227) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.51139926910400390625e1), SC_(4.757514563416710981803710625424785534165034543161) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.95070552825927734375e1), SC_(25.298534520252848859340530281359818905979421880685) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.24750102996826171875e2), SC_(773887818.69440844101710062758038002632576657267) }}, 
      {{ SC_(-0.944411754608154296875e1), SC_(0.637722015380859375e2), SC_(123371059205722849456522471.39199589118773988433275) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.177219114266335964202880859375e-2), SC_(-2.1751730239996037998402370047417815154802286090672e+110) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.22177286446094512939453125e-2), SC_(-4.5898079665211512903977572880548217813170151922414e+107) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.7444499991834163665771484375e-2), SC_(-1.6353150631751658694079459804859213337246715783426e+93) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.1433600485324859619140625e-1), SC_(-2.4849322229625889034431233440642338653899498830157e+85) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.1760916970670223236083984375e-1), SC_(-8.7454588988563154461495834998823425954748930956891e+82) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.6152711808681488037109375e-1), SC_(-1.0364544437424619262245615760036930677335297563156e+68) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.11958599090576171875e0), SC_(-1.2211096345203577463660938657353700536987732728768e+60) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.15262925624847412109375e0), SC_(-1.499238867403323448115733971215370840685965820221e+57) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.408089816570281982421875e0), SC_(-2764293976288744039510706623444218136026400198.2126) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.6540834903717041015625e0), SC_(-6489213204725977265215129630972885208931.7047324612) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.1097540378570556640625e1), SC_(-4303360485458128363716387921690997.3217489487710586) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.30944411754608154296875e1), SC_(-1714351938583329400496.4174686930951444045367252487) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.51139926910400390625e1), SC_(-1497554511106978.6413164698379263226769543182250566) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.95070552825927734375e1), SC_(-33797740.978790739801009558248759228383299554227922) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.24750102996826171875e2), SC_(10826.527066984430387952652561356481081377800520229) }}, 
      {{ SC_(-0.264718532562255859375e2), SC_(0.637722015380859375e2), SC_(1138075386232486817219014.8052993051304724020136075) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.177219114266335964202880859375e-2), SC_(-6.7515895735809066871214529723905715437908503383118e+280) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.22177286446094512939453125e-2), SC_(-3.9932538092585975496494729489045725705184449689373e+274) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.7444499991834163665771484375e-2), SC_(-9.3552896404712560124419918813505896861787425839659e+240) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.1433600485324859619140625e-1), SC_(-5.9273271957102624485347496431705870053301810885809e+222) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.1760916970670223236083984375e-1), SC_(-1.153207227833258672553374555903941230159216498121e+217) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.6152711808681488037109375e-1), SC_(-2.0842858984182053388047788639623901565569513682494e+182) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.11958599090576171875e0), SC_(-7.3048522112941081038934715569042013623958506239867e+163) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.15262925624847412109375e0), SC_(-1.2251050909789724436075350819675522361111116006141e+157) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.408089816570281982421875e0), SC_(-5.9701586451617060021522434220986032096708176834276e+129) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.6540834903717041015625e0), SC_(-4.728354017284186911399703339493637011862999946826e+116) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.1097540378570556640625e1), SC_(-1.9926304675659648565814683124221957471074002163378e+102) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.30944411754608154296875e1), SC_(-3.1604883938754236820131022262632377085597169426002e+73) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.51139926910400390625e1), SC_(-3.3137961673903813979855222305759692274465828133345e+59) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.95070552825927734375e1), SC_(-1556980182699205789141878500990820981351344.7558558) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.24750102996826171875e2), SC_(-566083031323896.3875812367042139902390038495937828) }}, 
      {{ SC_(-0.62944732666015625e2), SC_(0.637722015380859375e2), SC_(69806774000991.981050098476617099206392598300624042) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.177219114266335964202880859375e-2), SC_(1.1839121742842485104988098823330437428852602049832e+299) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.22177286446094512939453125e-2), SC_(2.81902949371739010374345957855831735940984861534e+292) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.7444499991834163665771484375e-2), SC_(4.8546289918185101042103883969307473026908530607992e+256) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.1433600485324859619140625e-1), SC_(2.1546278190064339067674826633353063739271301221998e+237) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.1760916970670223236083984375e-1), SC_(1.8200745294223299719259645343795820790086104600145e+231) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.6152711808681488037109375e-1), SC_(2.0552841306010258245904712429908698970209138298791e+194) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.11958599090576171875e0), SC_(4.8599074136394357477738859362200322327686066925173e+174) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.15262925624847412109375e0), SC_(3.0291712283242750374950591308689793715705627264649e+167) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.408089816570281982421875e0), SC_(2.7311361518237004467096782289378169109700518547074e+138) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.6540834903717041015625e0), SC_(3.1908839655190757699675391873689315010487055768747e+124) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.1097540378570556640625e1), SC_(1.6472120838529387950355967953886848057267684941894e+109) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.30944411754608154296875e1), SC_(3.9050576738763162147813896680294510397469818259809e+78) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.51139926910400390625e1), SC_(5.3546164511152300822211475272202193195389734723646e+63) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.95070552825927734375e1), SC_(2063636717424277900786624014685823705355667145.4769) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.24750102996826171875e2), SC_(17352084482088788.487115525087156830261883569699237) }}, 
      {{ SC_(-0.67001708984375e2), SC_(0.637722015380859375e2), SC_(1882431939202.1648135308211699659682571426859828426) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.8115838623046875e2), SC_(0.177219114266335964202880859375e-2), SC_(5.4534028432761118007192924772575239045191902394704e+370) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.22177286446094512939453125e-2), SC_(5.4277253994376798514542354703405103943629816857712e+362) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.7444499991834163665771484375e-2), SC_(3.3519204517241688133176213581123468664876899502254e+319) }}, 
#endif
      {{ SC_(-0.8115838623046875e2), SC_(0.1433600485324859619140625e-1), SC_(1.3919521259627573812888913112386014488812170293336e+296) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.1760916970670223236083984375e-1), SC_(6.3973177361791839803876463324989774282107643381539e+288) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.6152711808681488037109375e-1), SC_(1.469152116429485146808535540983280079580954020274e+244) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.11958599090576171875e0), SC_(2.8511122230996487961690173652685484920725224243098e+220) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.15262925624847412109375e0), SC_(5.619617351979676575330554848862555516412060445716e+211) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.408089816570281982421875e0), SC_(4.5519176106779604525307972631027227044957665270988e+176) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.6540834903717041015625e0), SC_(6.6903710486678328388174061602778428129323021420939e+159) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.1097540378570556640625e1), SC_(2.2712273637429638291780059369921894631251180655941e+141) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.30944411754608154296875e1), SC_(2.2942619227544780341172279887214301587559519747559e+104) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.51139926910400390625e1), SC_(2.5918799812048500972623559251340558435277335398624e+86) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.95070552825927734375e1), SC_(1.6026607476891554347045540272329236130901801631704e+64) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.24750102996826171875e2), SC_(242221324852426376730984312833.83772575601709413801) }}, 
      {{ SC_(-0.8115838623046875e2), SC_(0.637722015380859375e2), SC_(1617649.4354678509464238515107223191694738842428809) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.826751708984375e2), SC_(0.177219114266335964202880859375e-2), SC_(-3.3472423300617235905698843965441527482467443038007e+378) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.22177286446094512939453125e-2), SC_(-2.3708598693694264773788581512651012619352646209957e+370) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.7444499991834163665771484375e-2), SC_(-2.332724864540381393542054312015638284662343068144e+326) }}, 
#endif
      {{ SC_(-0.826751708984375e2), SC_(0.1433600485324859619140625e-1), SC_(-3.5853240695218770414340026925487536695026202308763e+302) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.1760916970670223236083984375e-1), SC_(-1.2062487642384866408885787920125470555828675792864e+295) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.6152711808681488037109375e-1), SC_(-4.1533132902226430058335777291251915410642650796069e+249) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.11958599090576171875e0), SC_(-2.9415592795451145762879834114133541803377334779173e+225) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.15262925624847412109375e0), SC_(-4.004567050888019716885840798964015187609154101286e+216) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.408089816570281982421875e0), SC_(-7.2979462110682988677653256370271393721462139889743e+180) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.6540834903717041015625e0), SC_(-5.2445445491935403760402688945078936122362998361533e+163) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.1097540378570556640625e1), SC_(-8.1205008350040740161924361771242389152554616754157e+144) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.30944411754608154296875e1), SC_(-1.7035976344726289794779047688107441677132607819582e+107) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.51139926910400390625e1), SC_(-8.9909599334196588720376409319670479241448485707598e+88) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.95070552825927734375e1), SC_(-2.1782704068871946390314388322315401827432575178739e+66) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.24750102996826171875e2), SC_(-7929786464052873454694960787901.4667046107734177419) }}, 
      {{ SC_(-0.826751708984375e2), SC_(0.637722015380859375e2), SC_(321545.92541683308491005482853962116432717512366683) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.9150136566162109375e2), SC_(0.177219114266335964202880859375e-2), SC_(4.7752420315052949336918939109644955940954303442772e+422) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.22177286446094512939453125e-2), SC_(4.672634120247836025594825390538921093160126252829e+413) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.7444499991834163665771484375e-2), SC_(1.0485379500582573783963422858182793176684843645978e+365) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.1433600485324859619140625e-1), SC_(4.9588309767452414656587518060761482771140983489273e+338) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.1760916970670223236083984375e-1), SC_(2.7165255928105224887542359416164700903104546889451e+330) }}, 
#endif
      {{ SC_(-0.9150136566162109375e2), SC_(0.6152711808681488037109375e-1), SC_(1.497807463748589761253650413784068920373567963589e+280) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.11958599090576171875e0), SC_(3.0080093649297924281671604031447884036156057482282e+253) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.15262925624847412109375e0), SC_(4.7539750027411551907109895223967893837587731749743e+243) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.408089816570281982421875e0), SC_(1.4719508727838863380520715026742213519071684890979e+204) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.6540834903717041015625e0), SC_(1.6449195464092670640967089522948926701897555960104e+185) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.1097540378570556640625e1), SC_(2.6430119091530033396732708140520765341274049733711e+164) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.30944411754608154296875e1), SC_(5.9115764027661312131195221326888531041451116633443e+122) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.51139926910400390625e1), SC_(3.7197112296952982305915131248565370184780285801752e+102) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.95070552825927734375e1), SC_(3.8543142124302116693843918034725003223456148718633e+77) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.24750102996826171875e2), SC_(348388267420102255285974747952173178611.13131031835) }}, 
      {{ SC_(-0.9150136566162109375e2), SC_(0.637722015380859375e2), SC_(17.286400157439880497643287768282457262827648723116) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.9297769927978515625e2), SC_(0.177219114266335964202880859375e-2), SC_(-8.6096503980045084060631217028712438055165886911886e+428) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.22177286446094512939453125e-2), SC_(-6.0500671156098795514612090856936433237677542773942e+419) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.7444499991834163665771484375e-2), SC_(-2.2716356285334738243587570010741763016518621060347e+370) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.1433600485324859619140625e-1), SC_(-4.0830076639538008822282564946296990530674259214769e+343) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.1760916970670223236083984375e-1), SC_(-1.6510576779808657903130227693644157913033679531897e+335) }}, 
#endif
      {{ SC_(-0.9297769927978515625e2), SC_(0.6152711808681488037109375e-1), SC_(-1.4357259752754892006168374205755635802741696352597e+284) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.11958599090576171875e0), SC_(-1.0809479648045584015360423564277119098233754619995e+257) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.15262925624847412109375e0), SC_(-1.1916646919576189758414592652440107018980490261704e+247) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.408089816570281982421875e0), SC_(-8.638225064394914906037494545527579038861486712648e+206) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.6540834903717041015625e0), SC_(-4.8107549813714765444834945102664921009336662482178e+187) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.1097540378570556640625e1), SC_(-3.6001527815737350249976258665050022440889901660339e+166) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.30944411754608154296875e1), SC_(-1.7437748164739759092994632686626404780818636870767e+124) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.51139926910400390625e1), SC_(-5.2299553434507716896730033035515525827291712767745e+103) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.95070552825927734375e1), SC_(-2.1754931209540505657945584435590968999379346502128e+78) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.24750102996826171875e2), SC_(-489279975179337971319178373473616570531.3971439032) }}, 
      {{ SC_(-0.9297769927978515625e2), SC_(0.637722015380859375e2), SC_(3.1138768560695466319423973048004231865346267449754) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.935389862060546875e2), SC_(0.177219114266335964202880859375e-2), SC_(8.0688178046660875366942050870249859577328716707511e+432) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.22177286446094512939453125e-2), SC_(4.999383448280047113055758331657707347238205486511e+423) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.7444499991834163665771484375e-2), SC_(9.5125927980583022867114515572337437495117399461392e+373) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.1433600485324859619140625e-1), SC_(1.1835928207186201022385742289755442651959073066336e+347) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.1760916970670223236083984375e-1), SC_(4.2643753321755758261525152291365839944990421740241e+338) }}, 
#endif
      {{ SC_(-0.935389862060546875e2), SC_(0.6152711808681488037109375e-1), SC_(1.8373928724038541221126334929154886623721723225705e+287) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.11958599090576171875e0), SC_(9.5266501035622313460240539374572419922108689547011e+259) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.15262925624847412109375e0), SC_(9.1583452362584887942448014227032834584018777075674e+249) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.408089816570281982421875e0), SC_(3.8225458537373042747497871921768347574435957648151e+209) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.6540834903717041015625e0), SC_(1.6336092915853506194085733396806169927574155053434e+190) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.1097540378570556640625e1), SC_(9.1430486034815972347229929299380544940594950080099e+168) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.30944411754608154296875e1), SC_(2.4754146661833103046325727586668305634458514331458e+126) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.51139926910400390625e1), SC_(5.6015550870361440436224381624665089671870099327921e+105) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.95070552825927734375e1), SC_(1.6468719424732049243330466077339660623811177581325e+80) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.24750102996826171875e2), SC_(21822583907358811053037130811818444812165.178319021) }}, 
      {{ SC_(-0.935389862060546875e2), SC_(0.637722015380859375e2), SC_(1.6202459650338070290292631729656915863467175104946) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.937735595703125e2), SC_(0.177219114266335964202880859375e-2), SC_(8.0161005650496153150047602127695384877112619587771e+433) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.22177286446094512939453125e-2), SC_(4.7121895935941112733161283913395552581627000221943e+424) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.7444499991834163665771484375e-2), SC_(6.7489578948819796465279387263947172505484245391434e+374) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.1433600485324859619140625e-1), SC_(7.2008255544846527802962931875418402546205058253594e+347) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.1760916970670223236083984375e-1), SC_(2.4722106319771409981962202279713651177220922375277e+339) }}, 
#endif
      {{ SC_(-0.937735595703125e2), SC_(0.6152711808681488037109375e-1), SC_(7.9429509269228682729842128076134590951021297525739e+287) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.11958599090576171875e0), SC_(3.5238628911760857836542016779741351841590639829531e+260) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.15262925624847412109375e0), SC_(3.1991972739448358110204969011793063969564333100632e+250) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.408089816570281982421875e0), SC_(1.0601971240221022602354878280169624328874560634695e+210) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.6540834903717041015625e0), SC_(4.0562439575631012229052052124587844501312876653207e+190) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.1097540378570556640625e1), SC_(2.0106662549288149711576408799795159621946914414786e+169) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.30944411754608154296875e1), SC_(4.2689860721575865482937882844305926904950034096776e+126) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.51139926910400390625e1), SC_(8.5872417960685100852575406225311225858427442486195e+105) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.95070552825927734375e1), SC_(2.1838318227167159909330661401578980127070318992242e+80) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.24750102996826171875e2), SC_(23197169448600179547441723720594978575753.138073162) }}, 
      {{ SC_(-0.937735595703125e2), SC_(0.637722015380859375e2), SC_(1.2309347099719344463490707583889826485511714653677) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.98576263427734375e2), SC_(0.177219114266335964202880859375e-2), SC_(-1.8687794147885167928527457277252388516835959859959e+458) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.22177286446094512939453125e-2), SC_(-3.7414904239690255067784103942976601925541849352047e+448) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.7444499991834163665771484375e-2), SC_(-1.5965640944808407725667136065189840039921892348426e+396) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.1433600485324859619140625e-1), SC_(-7.320115491126747037846038905532129894444596315101e+367) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.1760916970670223236083984375e-1), SC_(-9.3602637245910292284844431270402505539514808231614e+358) }}, 
#endif
      {{ SC_(-0.98576263427734375e2), SC_(0.6152711808681488037109375e-1), SC_(-7.3916717585913259321075581039832457225596218078505e+304) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.11958599090576171875e0), SC_(-1.3478888688116558023036374939459624612058097364704e+276) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.15262925624847412109375e0), SC_(-3.791352786070543556669495535901730962928262885919e+265) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.408089816570281982421875e0), SC_(-1.1164173761672894180446421860085507515466492816839e+223) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.6540834903717041015625e0), SC_(-4.4321335487082397473738992166756126236385391918427e+202) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.1097540378570556640625e1), SC_(-1.829299104513549751728801775792881677237395895807e+180) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.30944411754608154296875e1), SC_(-2.6775528532240954412317728650817376261367725674457e+135) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.51139926910400390625e1), SC_(-4.8343422017701947848142128610412996313627434863865e+113) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.95070552825927734375e1), SC_(-6.3086003964539024134807127345692279596917514234278e+86) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.24750102996826171875e2), SC_(-722013668091161834419632839820300702927946133.81195) }}, 
      {{ SC_(-0.98576263427734375e2), SC_(0.637722015380859375e2), SC_(-2.264907219938045514228468755131021109411846811226) }}, 
#if LDBL_MAX_10_EXP > 370
      {{ SC_(-0.99292266845703125e2), SC_(0.177219114266335964202880859375e-2), SC_(6.3109596228461854872163520399343533802066007997273e+461) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.22177286446094512939453125e-2), SC_(1.0760806168556900026257767345625819795477073735971e+452) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.7444499991834163665771484375e-2), SC_(1.9293939304434194212309231302798614709350838661324e+399) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.1433600485324859619140625e-1), SC_(5.5332871155247746211972566869224511531763443385132e+370) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.1760916970670223236083984375e-1), SC_(6.1066996996345030466111316476839821983070251825003e+361) }}, 
#endif
      {{ SC_(-0.99292266845703125e2), SC_(0.6152711808681488037109375e-1), SC_(1.9689590890048331266297095417142100126704729765354e+307) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.11958599090576171875e0), SC_(2.2310010193239478024976147029553786935350536128785e+278) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.15262925624847412109375e0), SC_(5.2695560767780991495852973930021573106179477154802e+267) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.408089816570281982421875e0), SC_(7.6734312870111071659149478157472838872919150437324e+224) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.6540834903717041015625e0), SC_(2.1731262202261953183006104408586425895083500928828e+204) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.1097540378570556640625e1), SC_(6.1917639155808956800674607699793506771122938889882e+181) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.30944411754608154296875e1), SC_(4.3153445924488455539179250312521041882346379117739e+136) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.51139926910400390625e1), SC_(5.4391058088796766856830688105169584088705696305955e+114) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.95070552825927734375e1), SC_(4.558385392397380699165520108576973779945146181354e+87) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.24750102996826171875e2), SC_(2653762654218899644996572642732864700666903231.4459) }}, 
      {{ SC_(-0.99292266845703125e2), SC_(0.637722015380859375e2), SC_(4.4670744813706185429763687583551679887281326495188) }},
   }};