# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient

from . import models as _models
from ._configuration import RecoveryServicesClientConfiguration
from ._serialization import Deserializer, Serializer
from .operations import (
    Operations,
    PrivateLinkResourcesOperations,
    RecoveryServicesClientOperationsMixin,
    RecoveryServicesOperations,
    RegisteredIdentitiesOperations,
    ReplicationUsagesOperations,
    UsagesOperations,
    VaultCertificatesOperations,
    VaultExtendedInfoOperations,
    VaultsOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential


class RecoveryServicesClient(
    RecoveryServicesClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Recovery Services Client.

    :ivar vault_certificates: VaultCertificatesOperations operations
    :vartype vault_certificates: azure.mgmt.recoveryservices.operations.VaultCertificatesOperations
    :ivar registered_identities: RegisteredIdentitiesOperations operations
    :vartype registered_identities:
     azure.mgmt.recoveryservices.operations.RegisteredIdentitiesOperations
    :ivar replication_usages: ReplicationUsagesOperations operations
    :vartype replication_usages: azure.mgmt.recoveryservices.operations.ReplicationUsagesOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.recoveryservices.operations.PrivateLinkResourcesOperations
    :ivar recovery_services: RecoveryServicesOperations operations
    :vartype recovery_services: azure.mgmt.recoveryservices.operations.RecoveryServicesOperations
    :ivar vaults: VaultsOperations operations
    :vartype vaults: azure.mgmt.recoveryservices.operations.VaultsOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.recoveryservices.operations.Operations
    :ivar vault_extended_info: VaultExtendedInfoOperations operations
    :vartype vault_extended_info:
     azure.mgmt.recoveryservices.operations.VaultExtendedInfoOperations
    :ivar usages: UsagesOperations operations
    :vartype usages: azure.mgmt.recoveryservices.operations.UsagesOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: The ID of the target subscription. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2023-02-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = RecoveryServicesClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: ARMPipelineClient = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.vault_certificates = VaultCertificatesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.registered_identities = RegisteredIdentitiesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.replication_usages = ReplicationUsagesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.recovery_services = RecoveryServicesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.vaults = VaultsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.vault_extended_info = VaultExtendedInfoOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.usages = UsagesOperations(self._client, self._config, self._serialize, self._deserialize)

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self) -> None:
        self._client.close()

    def __enter__(self) -> "RecoveryServicesClient":
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details: Any) -> None:
        self._client.__exit__(*exc_details)
