# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.webpubsub.aio import WebPubSubManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWebPubSubManagementWebPubSubOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WebPubSubManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_check_name_availability(self, resource_group):
        response = await self.client.web_pub_sub.check_name_availability(
            location="str",
            parameters={"name": "str", "type": "str"},
            api_version="2024-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_subscription(self, resource_group):
        response = self.client.web_pub_sub.list_by_subscription(
            api_version="2024-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_by_resource_group(self, resource_group):
        response = self.client.web_pub_sub.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-03-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.web_pub_sub.get(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2024-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.web_pub_sub.begin_create_or_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "location": "str",
                    "disableAadAuth": False,
                    "disableLocalAuth": False,
                    "externalIP": "str",
                    "hostName": "str",
                    "hostNamePrefix": "str",
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "kind": "str",
                    "liveTraceConfiguration": {"categories": [{"enabled": "str", "name": "str"}], "enabled": "false"},
                    "name": "str",
                    "networkACLs": {
                        "defaultAction": "str",
                        "ipRules": [{"action": "str", "value": "str"}],
                        "privateEndpoints": [{"name": "str", "allow": ["str"], "deny": ["str"]}],
                        "publicNetwork": {"allow": ["str"], "deny": ["str"]},
                    },
                    "privateEndpointConnections": [
                        {
                            "groupIds": ["str"],
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "Enabled",
                    "publicPort": 0,
                    "regionEndpointEnabled": "Enabled",
                    "resourceLogConfiguration": {"categories": [{"enabled": "str", "name": "str"}]},
                    "resourceStopped": "false",
                    "serverPort": 0,
                    "sharedPrivateLinkResources": [
                        {
                            "groupId": "str",
                            "id": "str",
                            "name": "str",
                            "privateLinkResourceId": "str",
                            "provisioningState": "str",
                            "requestMessage": "str",
                            "status": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                    "socketIO": {"serviceMode": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "tls": {"clientCertEnabled": False},
                    "type": "str",
                    "version": "str",
                },
                api_version="2024-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.web_pub_sub.begin_delete(
                resource_group_name=resource_group.name,
                resource_name="str",
                api_version="2024-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update(self, resource_group):
        response = await (
            await self.client.web_pub_sub.begin_update(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={
                    "location": "str",
                    "disableAadAuth": False,
                    "disableLocalAuth": False,
                    "externalIP": "str",
                    "hostName": "str",
                    "hostNamePrefix": "str",
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "kind": "str",
                    "liveTraceConfiguration": {"categories": [{"enabled": "str", "name": "str"}], "enabled": "false"},
                    "name": "str",
                    "networkACLs": {
                        "defaultAction": "str",
                        "ipRules": [{"action": "str", "value": "str"}],
                        "privateEndpoints": [{"name": "str", "allow": ["str"], "deny": ["str"]}],
                        "publicNetwork": {"allow": ["str"], "deny": ["str"]},
                    },
                    "privateEndpointConnections": [
                        {
                            "groupIds": ["str"],
                            "id": "str",
                            "name": "str",
                            "privateEndpoint": {"id": "str"},
                            "privateLinkServiceConnectionState": {
                                "actionsRequired": "str",
                                "description": "str",
                                "status": "str",
                            },
                            "provisioningState": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "provisioningState": "str",
                    "publicNetworkAccess": "Enabled",
                    "publicPort": 0,
                    "regionEndpointEnabled": "Enabled",
                    "resourceLogConfiguration": {"categories": [{"enabled": "str", "name": "str"}]},
                    "resourceStopped": "false",
                    "serverPort": 0,
                    "sharedPrivateLinkResources": [
                        {
                            "groupId": "str",
                            "id": "str",
                            "name": "str",
                            "privateLinkResourceId": "str",
                            "provisioningState": "str",
                            "requestMessage": "str",
                            "status": "str",
                            "systemData": {
                                "createdAt": "2020-02-20 00:00:00",
                                "createdBy": "str",
                                "createdByType": "str",
                                "lastModifiedAt": "2020-02-20 00:00:00",
                                "lastModifiedBy": "str",
                                "lastModifiedByType": "str",
                            },
                            "type": "str",
                        }
                    ],
                    "sku": {"name": "str", "capacity": 0, "family": "str", "size": "str", "tier": "str"},
                    "socketIO": {"serviceMode": "str"},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "tags": {"str": "str"},
                    "tls": {"clientCertEnabled": False},
                    "type": "str",
                    "version": "str",
                },
                api_version="2024-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_keys(self, resource_group):
        response = await self.client.web_pub_sub.list_keys(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2024-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_regenerate_key(self, resource_group):
        response = await (
            await self.client.web_pub_sub.begin_regenerate_key(
                resource_group_name=resource_group.name,
                resource_name="str",
                parameters={"keyType": "str"},
                api_version="2024-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_replica_skus(self, resource_group):
        response = await self.client.web_pub_sub.list_replica_skus(
            resource_group_name=resource_group.name,
            resource_name="str",
            replica_name="str",
            api_version="2024-03-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_restart(self, resource_group):
        response = await (
            await self.client.web_pub_sub.begin_restart(
                resource_group_name=resource_group.name,
                resource_name="str",
                api_version="2024-03-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_skus(self, resource_group):
        response = await self.client.web_pub_sub.list_skus(
            resource_group_name=resource_group.name,
            resource_name="str",
            api_version="2024-03-01",
        )

        # please add some check logic here by yourself
        # ...
