/***************************************************************************
 *   Copyright (C) 2004 by Johan Maes                                      *
 *   on4qz@telenet.be                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "ftp.h"
#include "global.h"
#include <qmessagebox.h>
#include <qfiledialog.h>

#include <qapplication.h>
#include "configparams.h"

ftpInterface *ftpIntf;

ftpInterface::ftpInterface()
{
	ftp=NULL;
  progress=new QProgressDialog ( tr("Uploading file..."),tr("Cancel"), 0, 0);
	init();

}

ftpInterface::~ftpInterface()
{
	destroy();
	if(ftp) delete ftp;

}

void ftpInterface::init()
{
		if(ftp)
			{
				destroy();
				delete ftp;
			}
    ftp = new QFtp( 0);
    connect( ftp, SIGNAL(commandStarted(int)),SLOT(ftp_commandStarted(int)) );
    connect( ftp, SIGNAL(commandFinished(int,bool)),SLOT(ftp_commandFinished(int,bool)) );
    connect( ftp, SIGNAL(done(bool)),SLOT(ftp_done(bool)) );
    connect( ftp, SIGNAL(stateChanged(int)),SLOT(ftp_stateChanged(int)) );
    connect( ftp, SIGNAL(listInfo(const QUrlInfo &)),SLOT(ftp_listInfo(const QUrlInfo &)) );
    connect( ftp, SIGNAL(rawCommandReply(int, const QString &)),SLOT(ftp_rawCommandReply(int, const QString &)) );
    connect( ftp, SIGNAL(dataTransferProgress(qint64,qint64)),SLOT(setProgress(qint64,qint64)) );
    connect( ftp, SIGNAL(commandFinished(int,bool)), progress, SLOT(reset()) );
    connect( progress, SIGNAL(canceled()),ftp, SLOT(abort()) );
}

void ftpInterface::destroy()
{
    if ( ftp->state() != QFtp::Unconnected )
			{
        addToLog("FTP destroy",DBFTP);
				 ftp->close();
			}
}

void ftpInterface::uploadFile(QString fileName,QString fixFilename,bool deleteSource)
{
		delSrc=deleteSource;
    progress->show();
    addToLog("FTP uploadFile",DBFTP);
    if ( fileName.isNull() )  return;
    ftpDone=FALSE;
    if(isUnconnected())
      {
        connectToHost();
      }

//    while(!isLoggedIn())
//    {
//      qApp->processEvents();
//    }
    while(!ftpDone)
     {
       qApp->processEvents();
     }

    sourceFn=new QFile(fileName);
    if ( !sourceFn->open( QIODevice::ReadOnly ) )
		 {
		   QMessageBox::critical( 0, tr("Upload error"),
                tr("Can't open file '%1' for reading.").arg(fileName) );
				delete sourceFn;
				sourceFn=NULL;
        return;
    }


    QFileInfo fi( fileName );
		QFileInfo fin(fixFilename);
    addToLog(QString("FTP bytes: %1").arg(sourceFn->size()),DBFTP);

    ftpDone=FALSE;
    int id=ftp->put( sourceFn, fi.fileName(),QFtp::Binary);
    addToLog(QString("FTP put file id: %1").arg(id),DBFTP);
    while(!ftpDone)
     {
       qApp->processEvents();
     }
		if(!fixFilename.isEmpty())
			{
			 ftp->rename(fi.fileName(),fin.fileName());
			}
     addToLog("FTP starting progress",DBFTP);
    //progress->exec(); // ### takes a lot of time!!!

}


void ftpInterface::connectToHost()
{
    destroy();
    ftp->connectToHost(ftpRemoteHost,ftpPort);
    ftp->login( ftpLogin, ftpPassword );
  //	changePath(ftpRemoteDirectory);
}

// This slot is connected to the QComboBox::activated() signal of the
// remotePath.
void ftpInterface::changePath( const QString &newPath )
{
    ftp->cd( newPath );
}


/****************************************************************************
**
** Slots connected to signals of the QFtp class
**
*****************************************************************************/

void ftpInterface::ftp_commandStarted(int id)
{
   addToLog(QString("FTP commandStarted id:%1, %2").arg(id).arg(ftp->currentCommand()),DBFTP);
 if ( ftp->currentCommand() == QFtp::List )
  {
  }
}

void ftpInterface::ftp_commandFinished(int id,bool err)
{
    addToLog(QString("FTP commandFinished id:%1, error:%2").arg(id).arg(err),DBFTP);
    if (delSrc) sourceFn->remove();
    delete ftp->currentDevice();
}

void ftpInterface::ftp_done( bool error )
{
		
    if ( error )
      {
        QMessageBox::critical( 0, tr("FTP Error"), ftp->errorString() );

        // If we are connected, but not logged in, it is not meaningful to stay
        // connected to the server since the error is a really fatal one (login
        // failed).
        destroy();
        return;
      }
    addToLog("FTP done:  no error",DBFTP);
    ftpDone=TRUE;
}

bool ftpInterface::isLoggedIn()
{
  return ftp->state() == QFtp::LoggedIn;
}

bool ftpInterface::isUnconnected()
{
  return ftp->state() == QFtp::Unconnected;
}

void ftpInterface::ftp_stateChanged( int state )
{
    switch ( (QFtp::State)state ) {
        case QFtp::Unconnected:
            addToLog("FTPss Unconnected",DBFTP);
            break;
        case QFtp::HostLookup:
            addToLog("FTPss Host lookup",DBFTP);
            break;
        case QFtp::Connecting:
            addToLog("FTPss Connecting",DBFTP);
            break;
        case QFtp::Connected:
            addToLog("FTPss Connected",DBFTP);
            break;
        case QFtp::LoggedIn:
            addToLog("FTPss Logged In",DBFTP);
            break;
        case QFtp::Closing:
            addToLog("FTPss Closing",DBFTP);
            break;
    default:
            addToLog(QString("FTPss uknown %1").arg(state),DBFTP);
     break;
    }
}

void ftpInterface::ftp_listInfo( const QUrlInfo &)
{
 
}

void ftpInterface::ftp_rawCommandReply( int code, const QString &text )
{
    addToLog(QString("FTP Raw Command Reply: code=%1 , %2").arg(code).arg(text),DBFTP);
}

void ftpInterface::setProgress(qint64 txfrBytes,qint64 totalBytes)
{
  progress->setMaximum(totalBytes);
  progress->setValue(txfrBytes);
}



