/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SOUNDIO_H
#define  SOUNDIO_H
#include <alsa/asoundlib.h>
#include <QString>
#include <QThread>
#include "buffermanag.h"
#include "wavio.h"



class soundIO:public QThread
{
public:
	enum edataSrc{SNDIN,SNDFILEIN,SNDINTOFILE};
	enum edataDst{SNDOUT,SNDFILEOUT};
  enum esoundStatus {SND_IDLE,SND_RECORD,SND_STARTPLAYBACK,SND_PLAYBACK,SND_STOP,SND_DELAYED_STOP,SND_FILE_STOP,SND_CALIBRATE};
	soundIO();
	bool setPlayBack(QString *errorstring,bool calibrating);
	bool setRecord(QString *errorstring,bool calibrating);
	int play();
	int record();
	void run();
	void stop();
	void abort()  {	if(isRunning()) abortRun=TRUE;}
  buffer<short int,24> rxBuffer;
  buffer<short int,24> txBuffer;
  wavIO waveIn;
	wavIO waveOut;
	edataSrc soundRoutingInput;
	edataDst soundRoutingOutput;
	int waveLen;
	void setSamplingrate(int sr);
	int clkRxCheck();
	int clkTxCheck();
  esoundStatus getStatus() {return status;}
  void logStatus();
private:
	snd_pcm_t *handle;
	bool startup;
	bool abortRun;
  esoundStatus status;
	bool output;
	void close();
	int smplrate;
	unsigned long storedFrames;

};

extern soundIO *sndIO;
#endif
