/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef SYNCPROCESSOR_H
#define SYNCPROCESSOR_H
#include "global.h"
#include "sstvparam.h"

#define SYNCWINDOW 37
#define FREQUENCY 1200
#define SYNCARRAYLEN 1024
#define SQUELCHLEVELS 3

class filter;

struct ssyncArray
{
	void clear()
		{
		startPosition=0;
		endPosition=0;
		length=0;
		closestLine=0;
		lineNumber=0;
		freq=0;
		maxVol=0;
		retrace=FALSE;
		keep=FALSE;
		inUse=0;
		}

	unsigned long startPosition;
	unsigned long endPosition;
	unsigned int length;
  int closestLine;
  int lineNumber;
  DSPFLOAT freq;
  DSPFLOAT maxVol;
	bool retrace;
	bool keep;
	int  inUse;
};

struct smodeArray
{
	void clear()
	{
		match=0;
		lineNumber=0;
		consecutiveSyncs=0;
		firstSyncIndex=0;
		ratio=0;
	}

	unsigned int match;
	unsigned int lineNumber;
	unsigned int consecutiveSyncs;
	unsigned int firstSyncIndex;
	DSPFLOAT ratio;
};

struct sslantArray
{
	DSPFLOAT x;
	DSPFLOAT y;
};

struct ssquelch
{
  uint consecSyncs;         // number of consecutive syncs needed before going inSync
  DSPFLOAT volumeTreshold;  // acts as DCD, volume must be above this level before sync detection will start
  DSPFLOAT syncOnTreshold; // higher is less sensitive, sync magnitude must be syncAvgTreshold times above average volume.
  DSPFLOAT syncOffTreshold; // higher is less sensitive, sync magnitude must be syncAvgTreshold times above average volume.
  DSPFLOAT maxVolTreshold;  // max Volume within a sync must reach at least this level
  uint missingSyncs;        // sync lost will be declared after that many missing syncs

};

class syncProcessor
{
public:
	syncProcessor(int len);
	~syncProcessor();
	void process(short int *buf);
	void init(unsigned int modeComboIdx);
/*!
		Returns true if a sync has been found. The mode is set 
	*/
  int isInSync();

	bool hasNewClock()
		 {
				bool nc=newClock;
				newClock=FALSE;
				return nc;
			}
	/*!
		Returns the syncposition (end of sync) of the first valid line
	*/
  unsigned long getSyncPosition() { return syncPosition;}
/*!
		Returns the detected sstv mode 
	*/
	esstvMode getMode() {return  mode ;}
	DSPFLOAT *getSyncBufferPtr() {return syncBufferPtr;}
	DSPFLOAT getNewClock() {return modifiedClock;}
  void logStatus();
  unsigned long getRewindPosition() {return rewindPosition;}

private:
	void analyze();
  bool addSync(int pos);
  void validate();
  void modeDetect(unsigned int visCde);
  void modeDetectByLine();
  void getMatchingSyncPulse(int modeIndex);
  int matchingSync(int start,unsigned int pos,DSPFLOAT syncWidth);
  void cleanupSyncArray(int modeIndex);
  void cleanNotInUse();
	void moveToTop(int index);
	void deleteSyncEntry(int index);
	bool validateSyncEntry();
	void initSignalQuality();
	bool signalQualityOK();
  bool slantAdjust();
	void dumpSyncArray();
  void regression(DSPFLOAT &a,DSPFLOAT &b,int start, int end);


	DSPFLOAT *syncBufferPtr;
	DSPFLOAT *volumeBufferPtr;
	DSPFLOAT *syncStateBuffer;
	DSPFLOAT *tAvgBuffer;
	DSPFLOAT prevTmp;
  DSPFLOAT volumeFiltered;
  DSPFLOAT volumeSync;
	DSPFLOAT modifiedClock;
	unsigned long sampleCounter;
	bool syncStarted;
	unsigned int stripeLength;

	unsigned int syncArrayIndex;
  unsigned int syncArrayCopyIndex;
  ssyncArray syncArray [SYNCARRAYLEN];
  ssyncArray syncArrayCopy [SYNCARRAYLEN];
	sslantArray slantArray [SYNCARRAYLEN];
	smodeArray modeArray[NUMSSTVMODES];
	bool syncFound;
	bool newClock;
	unsigned long syncPosition;
	unsigned int slantAdjustLine;


	esstvMode mode;
	DSPFLOAT samplesPerLine;
	DSPFLOAT syncWd;
  unsigned int visCode;
  unsigned int visCounter;
  DSPFLOAT visAvg;
  DSPFLOAT *volumeFreqPtr;

  void syncLost();

  void copySyncArray();
  void restoreSyncArray();
  filter *syncFilter;
  filter *volumeFilter;
  DSPFLOAT *filteredData;
  DSPFLOAT syncAvgFreq;
  DSPFLOAT syncMaxVol;
  int syncAvgCount;
  bool prevSyncRejected;
  unsigned long rewindPosition;
  DSPFLOAT syncTimeSpan;
  unsigned int modeComboIndex;
  // quality parameters
  int noSyncStripes;
  int noSyncInStripe;
  DSPFLOAT signalQuality;
 // unsigned int successiveSyncs;

  unsigned int rejectCounter;
  unsigned int avgVolume;
  unsigned int currentClosestLine;
};

#endif
