% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Interface.R
\name{write_airr}
\alias{write_airr}
\title{Write AIRR Data Model records to YAML or JSON files}
\usage{
write_airr(
  data,
  file,
  format = c("auto", "yaml", "json"),
  validate = TRUE,
  model = TRUE
)
}
\arguments{
\item{data}{\code{list} containing AIRR Model Records.}

\item{file}{output file name.}

\item{format}{format of the output file. Must be one of \code{"auto"}, \code{"yaml"}, or 
\code{"json"}. If \code{"auto"} (default), the format will be 
detected from the \code{file} extension.}

\item{validate}{run schema validation prior to write if \code{TRUE}.}

\item{model}{if \code{TRUE} validate and write only AIRR DataFile defined objects. 
If \code{FALSE} attempt validation and write of all objects in \code{data}.}
}
\description{
\code{write_airr} writes a YAML or JSON file containing AIRR Data Model records.
}
\examples{
# Get path to the repertoire-example file
file <- system.file("extdata", "repertoire-example.yaml", package="airr")

# Load data file
repertoire <- read_airr(file)

# Write a Rearrangement data file
outfile <- file.path(tempdir(), "output.yaml")
write_airr(repertoire, outfile)

}
\seealso{
See \link{Schema} for the AIRR schema definition objects.
See \link{read_airr} for reading to AIRR Data Model files.
}
