% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_categorical.R
\name{.table_as_df}
\alias{.table_as_df}
\title{Results from \code{table()} as Data Frame}
\usage{
.table_as_df(
  data,
  variable = NULL,
  by = NULL,
  strata = NULL,
  useNA = c("no", "always"),
  count_column = "...ard_n..."
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variable}{(\code{string})\cr
a string indicating a column in data}

\item{by}{(\code{character})\cr
a character vector indicating columns in data}

\item{strata}{(\code{character})\cr
a character vector indicating columns in data}

\item{useNA}{(\code{string})\cr
one of \code{"no"} and \code{"always"}. Will be passed to \code{table(useNA)}.}
}
\value{
data frame
}
\description{
Takes the results from \code{\link[=table]{table()}} and returns them as a data frame.
After the \code{\link[=table]{table()}} results are made into a data frame, all the variables
are made into character columns, and the function also restores the
column types to their original classes. For \code{strata} columns,
only observed combinations are returned.
}
\examples{
cards:::.table_as_df(ADSL, variable = "ARM", by = "AGEGR1", strata = NULL)
}
\keyword{internal}
