% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout_spectral.R, R/layouts.R
\name{layout_spectral}
\alias{layout_spectral}
\alias{layout_with_eigen}
\alias{layout_igraph_eigen}
\title{spectral graph layouts}
\usage{
layout_with_eigen(g, type = "laplacian", ev = "smallest")

layout_igraph_eigen(g, type = "laplacian", ev = "smallest", circular)
}
\arguments{
\item{g}{igraph object}

\item{type}{matrix to be used for spectral decomposition. either 'adjacency' or 'laplacian'}

\item{ev}{eigenvectors to be used. Either 'smallest' or 'largest'.}

\item{circular}{not used}
}
\value{
matrix of xy coordinates
}
\description{
Using a set of eigenvectors of matrices associated with a graph as coordinates
}
\details{
The layout_igraph_* function should not be used directly. It is only used as an argument for plotting with 'igraph'.
'ggraph' natively supports the layout.
}
\examples{
library(igraph)

g <- sample_gnp(50,0.2)

xy <- layout_with_eigen(g,type = "adjacency",ev = "largest")

xy <- layout_with_eigen(g,type = "adjacency",ev = "smallest")

xy <- layout_with_eigen(g,type = "laplacian",ev = "largest")

xy <- layout_with_eigen(g,type = "laplacian",ev = "smallest")
}
\author{
David Schoch
}
