% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psRace.R
\name{psRace}
\alias{psRace}
\title{Post-selection race}
\usage{
psRace(
  iraceResults,
  max_experiments,
  conf_ids = NULL,
  iteration_elites = FALSE,
  psrace_logFile = NULL
)
}
\arguments{
\item{iraceResults}{\code{list()}|\code{character(1)}\cr Object created by \pkg{irace} and typically saved in the log file \code{irace.Rdata}. If a character string is given, then it is interpreted as the path to the log file from which the \code{iraceResults} object will be loaded.}

\item{max_experiments}{\code{numeric(1)}\cr Number of experiments for the
post-selection race. If it is equal to or smaller than 1, then it is a
fraction of the total budget given by
\code{iraceResults$scenario$maxExperiments} or \code{iraceResults$scenario$maxTime / iraceResults$state$boundEstimate}.}

\item{conf_ids}{IDs of the configurations in \code{iraceResults$allConfigurations} to be used for the post-selection.
If \code{NULL}, then the configurations are automatically selected.}

\item{iteration_elites}{If \code{FALSE}, give priority to selecting the configurations that were elite in the last iteration.
If \code{TRUE}, select from all elite configurations of all iterations. This parameter only has an effect when \code{conf_ids} is not \code{NULL}.}

\item{psrace_logFile}{\code{character(1)}\cr Log file to save the post-selection race log. If \code{NULL}, the log is saved in \code{iraceResults$scenario$logFile}.}
}
\value{
The elite configurations after the post-selection. In addition, if \code{iraceResults$scenario$logFile} is defined,
it saves an updated copy of \code{iraceResults} in that file, where \code{iraceResults$psrace_log} is a list with the following elements:
\describe{
\item{configurations}{Configurations used in the post-selection race.}
\item{instances}{Data frame with the instances used in the post-selection race. First column has the
instances IDs from \code{iraceResults$scenario$instances}, second column the seed assigned to the instance.}
\item{max_experiments}{Configuration budget assigned to the post-selection race.}
\item{experiments}{Matrix of results generated by the post-selection  race, in the same format as the matrix \code{iraceResults$experiments}. Column names are the configuration IDs and  row names are the instance IDs.}
\item{elites}{Best configurations found in the experiments.}
}
}
\description{
\code{psRace} performs a post-selection race of a set of configurations.
}
\examples{
\donttest{
  irace_log <- read_logfile(system.file(package="irace", "exdata", "sann.rda"))
  # Use a temporary file to not change the original "sann.rda".
  psrace_logFile <- withr::local_tempfile(fileext = ".Rdata")
  # Execute the post-selection after the execution of irace. Use 10\% of the total budget.
  psRace(irace_log, max_experiments=0.1, psrace_logFile = psrace_logFile)
  # Print psrace_log
  irace_log <- read_logfile(psrace_logFile)
  str(irace_log$psrace_log)
}
}
\author{
Leslie Pérez Cáceres and Manuel López-Ibáñez
}
