% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish-package.R
\docType{data}
\name{trace}
\alias{trace}
\title{trace data}
\format{
A data frame with 1832 observations on the following 6 variables.
\describe{
\item{Time}{Time after myocardial infarction, in 6 months intervals}
\item{smoking}{Smoking status. A factor with levels (Never, Current, Previous)}
\item{sex}{A factor with levels (Female, Male)}
\item{age}{Age in years at the time of myocardial infarction}
\item{ObsTime}{Cumulative risk time in each split}
\item{dead}{Count of deaths}
}
}
\description{
These data are from screening to the TRACE study, a comparison between the angiotensin converting
enzyme inhibitor trandolapril and placebo ford large myocardial infarctions. A total of 6676
patients were screened for the study. Survival has been followed for the screened population for
16 years. The current data has been prepared for a poisson regression to examine survival. The data
has been "split" in 0.5 year intervals (plitLexis function from Epi package) and then collapsed
on all variables (aggregate function).
}
\examples{

data(trace)
Units(trace,list("age"="years"))
fit <- glm(dead ~ smoking+sex+age+Time+offset(log(ObsTime)), family="poisson",data=trace)
rtf <- regressionTable(fit,factor.reference = "inline")
summary(rtf)
publish(fit)

}
\references{
Kober et al 1995 Am. J. Cardiol 76,1-5
}
\keyword{datasets}
