% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{iload.molecules}
\alias{iload.molecules}
\title{Load molecules using an iterator.}
\usage{
iload.molecules(
  molfile,
  type = "smi",
  aromaticity = TRUE,
  typing = TRUE,
  isotopes = TRUE,
  skip = TRUE
)
}
\arguments{
\item{molfile}{A string containing the filename to load. Must be a local file}

\item{type}{Indicates whether the input file is SMILES or SDF. Valid values are
`"smi"` or `"sdf"`}

\item{aromaticity}{If `TRUE` then aromaticity detection is
performed on all loaded molecules. If this fails for a given
molecule, then the molecule is set to `NA` in the return list}

\item{typing}{If `TRUE` then atom typing is
performed on all loaded molecules. The assigned types will be CDK
internal types. If this fails for a given molecule, then the molecule 
is set to `NA` in the return list}

\item{isotopes}{If `TRUE` then atoms are configured with isotopic masses}

\item{skip}{If `TRUE`, then the reader will continue reading even when 
faced with an invalid molecule. If `FALSE`, the reader will stop at 
the fist invalid molecule}
}
\description{
The CDK can read a variety of molecular structure formats. Some file
formats support multiple molecules in a single file. If read using
\code{\link{load.molecules}}, all are read into memory. For very large
structure files, this can lead to out of memory errors. Instead it is 
recommended to use the iterating version of the loader so that only a
single molecule is read at a time.
}
\details{
Note that the iterating loader only supports SDF and SMILES file formats.
}
\examples{
\dontrun{
moliter <- iload.molecules("big.sdf", type="sdf")
while(hasNext(moliter)) {
mol <- nextElem(moliter)
  print(get.property(mol, "cdk:Title"))
}
}
}
\seealso{
\code{\link{write.molecules}}, \code{\link{load.molecules}}, \code{\link{parse.smiles}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
