% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc-example_jm.R
\name{example_jm}
\alias{example_jm}
\title{Example joint longitudinal and time-to-event model}
\format{Calling \code{example("example_jm")} will run the model in the 
  Examples section, below, and the resulting stanmvreg object will then be
  available in the global environment. The \code{chains} and \code{iter}
  arguments are specified to make this example be small in size. In practice,
  we recommend that they be left unspecified in order to use the default
  values or increased if there are convergence problems. The \code{cores} 
  argument is optional and on a multicore system, the user may well want 
  to set that equal to the number of chains being executed.}
\description{
A model for use in the \pkg{rstanarm} examples related to \code{\link{stan_jm}}.
}
\examples{
  set.seed(123)
  example_jm <- 
     stan_jm(formulaLong = logBili ~ year + (1 | id), 
             dataLong = pbcLong[1:101,],
             formulaEvent = survival::Surv(futimeYears, death) ~ sex + trt, 
             dataEvent = pbcSurv[1:15,],
             time_var = "year",
             # this next line is only to keep the example small in size!
             chains = 1, seed = 12345, iter = 200, refresh = 0)


}
