% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slide-period2.R, R/pslide-period.R
\name{slide_period2}
\alias{slide_period2}
\alias{slide_period2_vec}
\alias{slide_period2_dbl}
\alias{slide_period2_int}
\alias{slide_period2_lgl}
\alias{slide_period2_chr}
\alias{slide_period2_dfr}
\alias{slide_period2_dfc}
\alias{pslide_period}
\alias{pslide_period_vec}
\alias{pslide_period_dbl}
\alias{pslide_period_int}
\alias{pslide_period_lgl}
\alias{pslide_period_chr}
\alias{pslide_period_dfr}
\alias{pslide_period_dfc}
\title{Slide along multiple inputs simultaneously relative to an index chunked by period}
\usage{
slide_period2(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_period2_vec(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .ptype = NULL
)

slide_period2_dbl(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_period2_int(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_period2_lgl(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_period2_chr(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

slide_period2_dfr(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .names_to = rlang::zap(),
  .name_repair = c("unique", "universal", "check_unique")
)

slide_period2_dfc(
  .x,
  .y,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .size = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)

pslide_period(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

pslide_period_vec(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .ptype = NULL
)

pslide_period_dbl(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

pslide_period_int(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

pslide_period_lgl(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

pslide_period_chr(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE
)

pslide_period_dfr(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .names_to = rlang::zap(),
  .name_repair = c("unique", "universal", "check_unique")
)

pslide_period_dfc(
  .l,
  .i,
  .period,
  .f,
  ...,
  .every = 1L,
  .origin = NULL,
  .before = 0L,
  .after = 0L,
  .complete = FALSE,
  .size = NULL,
  .name_repair = c("unique", "universal", "check_unique", "minimal")
)
}
\arguments{
\item{.x, .y}{\verb{[vector]}

Vectors to iterate over. Vectors of size 1 will be recycled.}

\item{.i}{\verb{[Date / POSIXct / POSIXlt]}

A datetime index to break into periods.

There are 3 restrictions on the index:
\itemize{
\item The size of the index must match the size of \code{.x}, they will not be
recycled to their common size.
\item The index must be an \emph{increasing} vector, but duplicate values
are allowed.
\item The index cannot have missing values.
}}

\item{.period}{\verb{[character(1)]}

A string defining the period to group by. Valid inputs can be roughly
broken into:
\itemize{
\item \code{"year"}, \code{"quarter"}, \code{"month"}, \code{"week"}, \code{"day"}
\item \code{"hour"}, \code{"minute"}, \code{"second"}, \code{"millisecond"}
\item \code{"yweek"}, \code{"mweek"}
\item \code{"yday"}, \code{"mday"}
}}

\item{.f}{\verb{[function / formula]}

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function. There
are three ways to refer to the arguments:
\itemize{
\item For a single argument function, use \code{.}
\item For a two argument function, use \code{.x} and \code{.y}
\item For more arguments, use \code{..1}, \code{..2}, \code{..3} etc
}

This syntax allows you to create very compact anonymous functions.}

\item{...}{Additional arguments passed on to the mapped function.}

\item{.every}{\verb{[positive integer(1)]}

The number of periods to group together.

For example, if the period was set to \code{"year"} with an every value of \code{2},
then the years 1970 and 1971 would be placed in the same group.}

\item{.origin}{\verb{[Date(1) / POSIXct(1) / POSIXlt(1) / NULL]}

The reference date time value. The default when left as \code{NULL} is the
epoch time of \verb{1970-01-01 00:00:00}, \emph{in the time zone of the index}.

This is generally used to define the anchor time to count from, which is
relevant when the every value is \verb{> 1}.}

\item{.before, .after}{\verb{[integer(1) / Inf]}

The number of values before or after the current element to
include in the sliding window. Set to \code{Inf} to select all elements
before or after the current element. Negative values are allowed, which
allows you to "look forward" from the current element if used as the
\code{.before} value, or "look backwards" if used as \code{.after}.}

\item{.complete}{\verb{[logical(1)]}

Should the function be evaluated on complete windows only? If \code{FALSE},
the default, then partial computations will be allowed.}

\item{.ptype}{\verb{[vector(0) / NULL]}

A prototype corresponding to the type of the output.

If \code{NULL}, the default, the output type is determined by computing the
common type across the results of the calls to \code{.f}.

If supplied, the result of each call to \code{.f} will be cast to that type,
and the final output will have that type.

If \code{getOption("vctrs.no_guessing")} is \code{TRUE}, the \code{.ptype} must be
supplied. This is a way to make production code demand fixed types.}

\item{.names_to}{This controls what to do with input names supplied in \code{...}.
\itemize{
\item By default, input names are \link[rlang:zap]{zapped}.
\item If a string, specifies a column where the input names will be
copied. These names are often useful to identify rows with
their original input. If a column name is supplied and \code{...} is
not named, an integer column is used instead.
\item If \code{NULL}, the input names are used as row names.
}}

\item{.name_repair}{One of \code{"unique"}, \code{"universal"}, \code{"check_unique"},
\code{"unique_quiet"}, or  \code{"universal_quiet"}. See \code{\link[vctrs:vec_as_names]{vec_as_names()}} for the
meaning of these options.

With \code{vec_rbind()}, the repair function is applied to all inputs
separately. This is because \code{vec_rbind()} needs to align their
columns before binding the rows, and thus needs all inputs to
have unique names. On the other hand, \code{vec_cbind()} applies the
repair function after all inputs have been concatenated together
in a final data frame. Hence \code{vec_cbind()} allows the more
permissive minimal names repair.}

\item{.size}{If, \code{NULL}, the default, will determine the number of rows in
\code{vec_cbind()} output by using the tidyverse \link[vctrs:vector_recycling_rules]{recycling rules}.

Alternatively, specify the desired number of rows, and any inputs of length
1 will be recycled appropriately.}

\item{.l}{\verb{[list]}

A list of vectors. The length of \code{.l} determines the
number of arguments that \code{.f} will be called with. If \code{.l} has names,
they will be used as named arguments to \code{.f}. Elements of \code{.l} with size
1 will be recycled.}
}
\value{
A vector fulfilling the following invariants:

\subsection{\code{slide_period2()}}{
\itemize{
\item \code{vec_size(slide_period2(.x, .y)) == vec_size(unique(warp::warp_distance(.i)))}
\item \code{vec_ptype(slide_period2(.x, .y)) == list()}
}

}

\subsection{\code{slide_period2_vec()} and \verb{slide_period2_*()} variants}{
\itemize{
\item \code{vec_size(slide_period2_vec(.x, .y)) == vec_size(unique(warp::warp_distance(.i)))}
\item \code{vec_size(slide_period2_vec(.x, .y)[[1]]) == 1L}
\item \code{vec_ptype(slide_period2_vec(.x, .y, .ptype = ptype)) == ptype}
}

}

\subsection{\code{pslide_period()}}{
\itemize{
\item \code{vec_size(pslide_period(.l)) == vec_size(unique(warp::warp_distance(.i)))}
\item \code{vec_ptype(pslide_period(.l)) == list()}
}

}

\subsection{\code{pslide_period_vec()} and \verb{pslide_period_*()} variants}{
\itemize{
\item \code{vec_size(pslide_period_vec(.l)) == vec_size(unique(warp::warp_distance(.i)))}
\item \code{vec_size(pslide_period_vec(.l)[[1]]) == 1L}
\item \code{vec_ptype(pslide_period_vec(.l, .ptype = ptype)) == ptype}
}

}
}
\description{
\code{slide_period2()} and \code{pslide_period()} represent the combination
of \code{\link[=slide2]{slide2()}} and \code{\link[=pslide]{pslide()}} with \code{\link[=slide_period]{slide_period()}}, allowing you to slide
over multiple vectors at once, using indices defined by breaking up the
\code{.i}-ndex by \code{.period}.
}
\examples{
i <- as.Date("2019-01-28") + 0:5

slide_period2(
  .x = 1:6,
  .y = i,
  .i = i,
  .period = "month",
  .f = ~data.frame(x = .x, i = .y)
)

pslide_period(
  .l = list(1:6, 7:12, i),
  .i = i,
  .period = "month",
  .f = ~data.frame(x = .x, y = .y, i = ..3)
)

}
\seealso{
\code{\link[=slide2]{slide2()}}, \code{\link[=slide_index2]{slide_index2()}}, \code{\link[=slide_period]{slide_period()}}
}
