% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_other.R
\name{stri_trans_char}
\alias{stri_trans_char}
\title{Translate Characters}
\usage{
stri_trans_char(str, pattern, replacement)
}
\arguments{
\item{str}{character vector}

\item{pattern}{a single character string providing code points to be translated}

\item{replacement}{a single character string giving translated code points}
}
\value{
Returns a character vector.
}
\description{
Translates Unicode code points in each input string.
}
\details{
Vectorized over \code{str} and with respect to each code point
in \code{pattern} and \code{replacement}.

If \code{pattern} and \code{replacement} consist of a different number
of code points, then the extra code points in the longer of the two
are ignored, with a warning.

If code points in a given \code{pattern} are not unique, the
last corresponding replacement code point is used.

Time complexity for each string in \code{str} is
O(\code{stri_length(str)*stri_length(pattern)}).
}
\examples{
stri_trans_char('id.123', '.', '_')
stri_trans_char('babaab', 'ab', '01')
stri_trans_char('GCUACGGAGCUUCGGAGCUAG', 'ACGT', 'TGCA')
}
\seealso{
The official online manual of \pkg{stringi} at \url{https://stringi.gagolewski.com/}

Other transform: 
\code{\link{stri_trans_general}()},
\code{\link{stri_trans_list}()},
\code{\link{stri_trans_nfc}()},
\code{\link{stri_trans_tolower}()}
}
\concept{transform}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski} and other contributors
}
