
;; #f means a symbol
;; X means fails (syntax forces it to be a number)
;; DBZ means fails because divide-by-zero
;; NOE means fails because no such exact

(define number-table
  `((,(+ 1/2 +i) "1/2+i")
    (100 "100")
    (100 "#d100")
    (0.1 ".1")
    (0.1 "#d.1")
    (1/20000 "#e1/2e-4")
    (10.0 "1e1")
    (10.0 "1E1")
    (10.0f0 "1s1")
    (10.0f0 "1S1")
    (10.0f0 "1f1")
    (10.0f0 "1F1")
    (1.0f32 "1f32")
    (1.0f32 "1F32")
    (1.0f32 "1f+32")
    (1.0f-32 "1f-32")
    (10.0 "1l1")
    (10.0 "1L1")
    (10.0 "1d1")
    (10.0 "1D1")
    (0.0 "0e13")
    (0.0 "#i0")
    (-0.0 "#i-0")
    (+inf.0 ".3e2666666666")
    (+inf.0 "+INF.0")
    (+nan.0 "+NaN.0")
    (+inf.0 "1e500") ; Check simple overflows
    (-inf.0 "-1e500")
    (0.0 "1e-500")
    (-0.0 "-1e-500")
    (+inf.0 "1#e500")
    (-inf.0 "-1#e500")
    (0.0 "1#e-500")
    (-0.0 "-1#e-500")
    (+inf.0 "1e10000000000000000000000000000000") ; Check avoidance of extreme computations
    (-inf.0 "-1e10000000000000000000000000000000")
    (+inf.0 "1#e10000000000000000000000000000000")
    (-inf.0 "-1#e10000000000000000000000000000000")
    (+inf.f "+inf.f")
    (-inf.f "-inf.f")
    (+nan.f "+nan.f")
    (-nan.f "-nan.f")
    (+0.0 "1e-10000000000000000000000000000000")
    (-0.0 "-1e-10000000000000000000000000000000")
    (+0.0 "1#e-10000000000000000000000000000000")
    (-0.0 "-1#e-10000000000000000000000000000000")
    (1e-134
     "0.00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001")
    (10.0 "1#")
    (10.0 "1#e0")
    (10.0 "1####e-3")
    (10.0 "1#.e0")
    (10.0 "10.#e0")
    (10.0 "10.e0")
    (10.0 "1#.e0")
    (10.0 "10.0#e0")
    (10.0 "1#.##e0")
    (10 "#e1#")
    (10 "#e1#e0")
    (10 "#e1#.e0")
    (5e-5 "1/2e-4")
    (5e-5 "#i1/2e-4")
    (0.5 "#i1/2")
    (1/2 "#e1/2")
    (0.5 "#i0.5")
    (1/2 "#e0.5")
    (1/20 "#e0.5e-1")
    (1/20 "#e0.005e1")
    (1.0+0.5i "1+0.5i")
    (1/2 "1/2@0")
    (-1/2 "-1/2@0")
    (1/2 "1/2@-0")
    (0 "#o#e0")
    (8 "#o#e10")
    (0 "#b#e0")
    (0.0 "#b#i0")
    (4.0 "#b1e10")
    (4 "#b#e1e10")
    (1/10+1/5i "#e0.1+0.2i")
    (0.0+80.0i "#i+8#i")
    (521976 "#x7f6f8")
    (1+8i "#b#e1+1#e10i")
    (1.125 "#x1.2")
    (1.1640625 "#x1.2a")
    (1.1640625 "#x1.2a####")
    (10.0 "#xa.")
    (10.25 "#xa.4")
    (160.0 "#xa#.")
    (416.0 "#x1a#.")
    (2816.0 "#xb##.##")
    (4e62 "#i4000000000000000000000000000000000000000000000000000000000000e2")
    (-0.0 "#b-0.0")
    (X "#b1000000000020e1")
    (#f "1.0/3")
    (#f "1/3.0")
    (#i10/3 "1#/3")
    (#i1/300 "1/3##")
    (#f "1#/#3")
    (#i10/3 "#d1#/3")
    (X "#d1#/#3")
    (+inf.0 "1/0#")
    (-inf.0 "-1/0#")
    (NOE "#e+inf.0")
    (NOE "#e-inf.0")
    (NOE "#e+nan.0")
    (NOE "#e1/0#")
    (500.0 "1/2#e4")
    (5000.0 "1#/2#e4")
    (500000000.0 "1/2#e10")
    (500000000 "#e1/2#e10")
    (16140901064495857664-50176i "#e#x+e#s+e@-e#l-e")

    (,(make-rectangular -inf.f 3.1415927f0) "-inf.f+3.1415927f0i")
    (,(make-rectangular -inf.0 3.1415927) "-inf.f+3.1415927i")
    (,(make-rectangular 3.1415927f0 -inf.f) "3.1415927f0-inf.fi")
    (,(make-rectangular 3.1415927 -inf.0) "3.1415927-inf.fi")
    (,(make-rectangular +inf.f -inf.f) "+inf.f-inf.fi")
    (,(make-rectangular +inf.0 -inf.0) "+inf.0-inf.fi")
    (,(make-rectangular +inf.0 -inf.0) "+inf.f-inf.0i")

    (#f "d")
    (D "D")
    (#f "i")
    (I "I")
    (#f "3i")
    (3I "3I")
    (#f "33i")
    (33I "33I")
    (#f "3.3i")
    (3.3I "3.3I")
    (#f "e")
    (#f "e1")
    (#f "e1")
    (#f "-")
    (#f "+")
    (X "#e-")
    (X "#e+")
    (X "#i-")
    (X "#i+")
    (#f "+.")
    (X "#e+.")
    (#f "/")
    (#f "+1+1")
    (#f "+1/+1")
    (#f "1//2")
    (#f "mod//")
    (#f "-1.0/2")
    (#f "/2")
    (#f "2..")
    (#f ".2.")
    (X "#e2..")
    (X "#e.2.")
    (#f "1#.0e4")
    (#f "1#0e4")
    (#f "1#0.e4")
    (#f "1##.##0e4")
    (#f "2i")
    (#f "/2i")
    (#f "2@2i")
    (#f "2@@2")
    (#f "-2@-+2")
    (#f "1/1-e4")
    (#f "1.-2")
    (#f "--1")
    (#f "-+1")
    (#f "-1+3-4")
    (#f "1\0002")
    (X "#xg")
    (X "#x")
    (X "#xa#a")
    (X "#i#j0")
    (X "#x12.a#b")
    (X "#e1.-2")
    (X "#b#b0")
    (X "#b#o0")
    (X "#i#i0")
    (X "#e#e0")
    (X "#i8#i")
    (X "#i4@#i5")
    (X "#i4+#d6i")
    (X "#i4+#d6")
    (#f "4ef5")
    (X "#e4ef5")
    (X "#d1e")
    (X "#b1e")
    (X "#o1e")
    (DBZ "1/0")
    (DBZ "5+1/0i")
    (DBZ "1/0+5i")
    (DBZ "5@1/0")
    (DBZ "1/0@5")
    (DBZ "1/0e2")
    (#f "1/0+hi")
    (#f "x+1/0i")
    (+nan.0+1i "+nan.0+1i")
    (1+nan.0i "1+nan.0i")
    (#f "1++nan.0i")
    (0.5+nan.0i "1/2+nan.0i")
    (1+inf.0i "1+inf.0i")
    (1-inf.0i "1-inf.0i")
    (+inf.0i "+inf.0i")
    (-inf.0i "-inf.0i")
    (+nan.0i "+nan.0i")
    (-nan.0i "-nan.0i")
    (+nan.fi "+nan.fi")
    (-nan.fi "-nan.fi")
    (+inf.0i "+INF.0i")
    (+inf.fi "+inf.fi")
    (-inf.fi "-inf.fi")
    (-inf.0-nan.0i "-inf.0-nan.0i")
    (#f "1++inf.0i")
    (+nan.0@1 "+nan.0@1")
    (+inf.0@1 "+inf.0@1")
    (#f "+inf.0@1@1")
    (1@+inf.0 "1@+inf.0")
    (1@+inf.0 "1/1@+inf.0")
    (+inf.0@1 "+inf.0@1/1")
    (1.0+0.0i "1@0000.0")
    (1.0 "0001.0@0")
    (#f "+inf.0@3@0")
    (#f "+inf.0@3+4i")
    (#f "+ina.0")
    (#f "1@3+4i")
    (#f "@2")
    (#f "+a@2")
    (#f "3.0t0+4.0i")
    (#f "3.0+4.0t0i")
    (#f "3.0t0@4.0")
    (#f "3.0@4.0t0")
    (#f "inf.t+4.0i")
    (#f "3.0+int.ti")
    (#f "inf.t@4.0")
    (#f "3.0@inf.t")
    (#f "1/0+inf.t")
    (#f "1/0@3.0t0")
    (#f "1/0+3.0t0i")
    (X "#e3.0t0")
    (X "#i3.0t0")
    (DBZ "+inf.0+1/0i")
    (DBZ "1/0@+inf.0")
    (DBZ "+inf.0@1/0")
    (#f "1e1/0")
    (#f "011111122222222223333333333444444x")))
