#lang racket/base
(require racket/gui/base
         framework
         racket/class
         racket/runtime-path)

#|

The computations done in this file could be done as
part of the documentation build, except that 
racket/gui/base isn't available then and disentangling
the indentation code from racket/gui/base seems painful.

|#

(define examples
  '((app-example1 "(f a\nb\nc)")
    (app-example2 "(f\na\nb\nc)")
    (begin-example1 "(begin a\nb\nc)")
    (begin-example2 "(begin\na\nb\nc)")
    (define-example1 "(define x\n1)")
    (define-example2 "(struct s t \n(a b c))")
    (define-example3 "(define\n(f x)\n1)")
    (lambda-example1 "(λ (x y)\n1)")
    (lambda-example2 "(lambda\n(x y)\n1)")
    (for/fold-example
     "(for/fold ([acc 0])\n([x (in-range 10)]\n[y (in-list l)])\nb\nc)")))


(define run-example
  (let ()
    (define f (new frame% [label ""]))
    (define t (new racket:text%))
    (define ec (new editor-canvas% [parent f] [editor t]))
    (λ (example)
      (send t erase)
      (send t insert example)
      (send t tabify-all)
      (send t get-text))))

(define-runtime-path indentation-table.rkt "indentation-table.rkt")

(module+ main
  (call-with-output-file indentation-table.rkt
    (λ (port)
      (fprintf port "#lang racket/base\n")
      (fprintf port ";; warning, this file is generated by another program\n")
      (fprintf port "~s\n" `(provide (all-defined-out)))
      (for ([example (in-list examples)])
        (fprintf port "~s\n" `(define ,(list-ref example 0) 
                                ,(run-example (list-ref example 1))))))
    #:exists 'truncate))
