# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2024 Raritan Inc. All rights reserved.
#
# This file was generated by IdlC from EventService.idl.

use strict;

package Raritan::RPC::event::Channel;

use parent qw(Raritan::RPC::RemoteObject);

use constant typeId => "event.Channel:1.0.0";

sub new {
    my ($class, $agent, $rid, $typeId) = @_;
    $typeId = $typeId || Raritan::RPC::event::Channel::typeId;
    return $class->SUPER::new($agent, $rid, $typeId);
}

sub demandEventType($$) {
    my ($self, $type) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'type'} = $type;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEventType', $args);
}

sub cancelEventType($$) {
    my ($self, $type) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'type'} = $type;
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEventType', $args);
}

sub demandEventTypes($$) {
    my ($self, $types) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'types'} = [];
    for (my $i0 = 0; $i0 <= $#{$types}; $i0++) {
        $args->{'types'}->[$i0] = $types->[$i0];
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEventTypes', $args);
}

sub cancelEventTypes($$) {
    my ($self, $types) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'types'} = [];
    for (my $i0 = 0; $i0 <= $#{$types}; $i0++) {
        $args->{'types'}->[$i0] = $types->[$i0];
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEventTypes', $args);
}

sub demandEvent($$$) {
    my ($self, $type, $src) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'type'} = $type;
    $args->{'src'} = Raritan::RPC::ObjectCodec::encode($src);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEvent', $args);
}

sub cancelEvent($$$) {
    my ($self, $type, $src) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'type'} = $type;
    $args->{'src'} = Raritan::RPC::ObjectCodec::encode($src);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEvent', $args);
}

use Raritan::RPC::event::Channel::EventSelect;

sub demandEvents($$) {
    my ($self, $events) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'events'} = [];
    for (my $i0 = 0; $i0 <= $#{$events}; $i0++) {
        $args->{'events'}->[$i0] = Raritan::RPC::event::Channel::EventSelect::encode($events->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'demandEvents', $args);
}

use Raritan::RPC::event::Channel::EventSelect;

sub cancelEvents($$) {
    my ($self, $events) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'events'} = [];
    for (my $i0 = 0; $i0 <= $#{$events}; $i0++) {
        $args->{'events'}->[$i0] = Raritan::RPC::event::Channel::EventSelect::encode($events->[$i0]);
    }
    my $rsp = $agent->json_rpc($self->{'rid'}, 'cancelEvents', $args);
}


sub subscribe($$) {
    my ($self, $consumer) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'consumer'} = Raritan::RPC::ObjectCodec::encode($consumer);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'subscribe', $args);
}


sub unsubscribe($$) {
    my ($self, $consumer) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    $args->{'consumer'} = Raritan::RPC::ObjectCodec::encode($consumer);
    my $rsp = $agent->json_rpc($self->{'rid'}, 'unsubscribe', $args);
    my $_ret_;
    $_ret_ = $rsp->{'_ret_'};
    return $_ret_;
}

use Raritan::RPC::idl::Event;

sub pollEvents($$) {
    my ($self, $events) = @_;
    my $agent = $self->{'agent'};
    my $args = {};
    my $rsp = $agent->json_rpc($self->{'rid'}, 'pollEvents', $args);
    $$events = [];
    for (my $i0 = 0; $i0 <= $#{$rsp->{'events'}}; $i0++) {
        $$events->[$i0] = Raritan::RPC::ValObjCodec::decode($agent, $rsp->{'events'}->[$i0], 'idl.Event');
    }
    my $_ret_;
    $_ret_ = ($rsp->{'_ret_'}) ? 1 : 0;
    return $_ret_;
}

Raritan::RPC::Registry::registerProxyClass('event.Channel', 1, 0, 0, 'Raritan::RPC::event::Channel');
1;
