///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// d_ds matrix for scalar valued space on lineic geometry
//
//  int_Gamma d phi/ds psi ds
//
// or, in axisymmetric geometries:
//
//  int_Gamma d phi/ds psi r ds
//
#include "d_ds.h"
#include "rheolef/ublas_matrix_range.h"
using namespace rheolef;
using namespace std;
using namespace ublas;

void 
d_ds::operator() (const geo_element& K, ublas::matrix<Float>& m) const
{
  size_type n_comp = get_first_space().n_component();
  check_macro (n_comp == 1, "only single-component fields supported for d_ds form") 
  build_d_ds (K, m);
}
void
d_ds::check_after_initialize () const
{
  // suppose also that multi-component spaces are homogeneous,
  // i.e. that all components have the same approx
  check_macro (get_first_space().n_component() == get_second_space().n_component(),
    "incompatible spaces for the `d_ds' form.");
}
