///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
///
// Permutation matrix algorithms
//
# include "rheolef/permutation.h"
# include "rheolef/rheostream.h"
# include "rheolef/csr.h"
# include "rheolef/iorheo.h"
# include "genrcm.h"
using namespace rheolef;
using namespace std;

namespace rheolef {
permutation
inv (const permutation& p)
{
    permutation ip(p.size());
    permutation::const_iterator p1 = p.begin();
    permutation::iterator       p2 = ip.begin();

    for (permutation::size_type i = 0; i < p.size(); i++) {
	p2[p1[i]] = i;
    }
    return ip;
}
template<class T>
permutation
gibbs (const csr<T>& a)
{
#ifdef BUG
#endif // BUG
    typedef permutation::size_type       size_type;
    typedef permutation::difference_type difference_type;

    assert_macro (a.nrow() == a.ncol(), 
	"csr(gibbs): square matrix is required while csr("
        << a.nrow() << "," << a.ncol() << ") found.");
    
    permutation p;
    p.resize(a.nrow());
    if (a.nrow() == 0) {
        // empty matrix case
        return p;
    }
    // ----------------------------------------------------
    // a lower triangular in CSC format (HB-like) is required
    // i.e. an upper in CSR one
    // get strict upper; will force diagonal entries after
    // since gibbs requires that diagonal elements exist
    // ----------------------------------------------------

    csr<T> ua = a;
    size_type nrowa  = a.nrow();
    size_type nnza   = a.nnz();
    size_type nnzua  = ua.nnz();
    size_t size_bug = 1; // may shift starting point of arrays !!
    vector<difference_type> xadj  (nrowa+1+size_bug);
    vector<difference_type> adjncy(nnzua+size_bug);
    vector<difference_type> mask  (nnzua+size_bug);
    vector<difference_type> xls   (nrowa+size_bug);
    vector<difference_type> perm  (nrowa+size_bug);

    // shift to fortran...
    for (size_type i = 0; i < ua.ia().size(); i++)
	xadj[i] = ua.ia().at(i) + 1;
    for (size_type i = 0; i < ua.ja().size(); i++)
	adjncy[i] = ua.ja().at(i) + 1;

    difference_type neqn = nrowa;
    genrcm (neqn, xadj.begin(), adjncy.begin(),
           perm.begin(), mask.begin(), xls.begin());

    // shift back
    for (size_type i = 0; i < p.size(); i++)
	p.at(i) = perm[i] - 1;

    permutation ip = inv(p);

    return ip;
}
// =====================[ INSTANCIATION IN LIBRARY ]=============================

template permutation gibbs (const csr<Float>&);

}// namespace rheolef
