% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rktest.expectError.R
\name{rktest.commandFailed}
\alias{rktest.commandFailed}
\alias{rktest.expectError}
\title{Helper functions to check for expected errors}
\usage{
rktest.commandFailed(expr, silent = FALSE)

rktest.expectError(expr, message = NULL, silent = FALSE)
}
\arguments{
\item{expr}{Expression to evaluate}

\item{silent}{if TRUE suppress the error message itself (and any warnings).}

\item{message}{Error message to generate, if the expected error failed to occur. If NULL, the deparsed expression itself is cited.}
}
\value{
TRUE if the command failed. rktest.commandFailed() returns FALSE, if the command did not fail.
}
\description{
\code{rktest.commandFailed()} runs the given statement(s), which is expected to produce an error. Returns TRUE, if the command failed, FALSE, if it succeeded.
\code{rktest.exptectError()} runs the given statement(s), which is expected to produce an error. If the command succeeds, and error is produced.
}
\note{
In both cases, the error message of the original command will still be printed, unless silent=TRUE (as a warning), but execution will continue afterwards.
}
\examples{
if(!rktest.commandFailed(stop("Expected error"))) stop("Failed to generate error")
}
\seealso{
\code{\link[rkwardtests:rktest.makeplugintests]{rktest.makeplugintests}}
}
\author{
Thomas Friedrichsmeier \email{rkward-devel@kde.org}
}
\keyword{utilities}
