## -*- encoding: utf-8 -*-
"""
This file (./lp_doctest.sage) was *autogenerated* from ./lp.tex,
with sagetex.sty version 2011/05/27 v2.3.1.
It contains the contents of all the sageexample environments from this file.
You should be able to doctest this file with:
sage -t ./lp_doctest.sage
It is always safe to delete this file; it is not used in typesetting your
document.

Sage example in ./lp.tex, line 14::

  sage: set_random_seed(158888)
  sage: sage.numerical.backends.generic_backend.default_solver = "Glpk"

Sage example in ./lp.tex, line 124::

  sage: p = MixedIntegerLinearProgram()

Sage example in ./lp.tex, line 137::

  sage: x, y, z = p['x'], p['y'], p['z']
  sage: p.set_min(x, 0)
  sage: p.set_min(y, 0)
  sage: p.set_min(z, 0)

Sage example in ./lp.tex, line 154::

  sage: p.set_objective( x + y + 3*z )

Sage example in ./lp.tex, line 166::

  sage: p.add_constraint( x + 2*y <= 4 )
  sage: p.add_constraint( 5*z - y  <= 8 )

Sage example in ./lp.tex, line 180::

  sage: p.solve() # abs tol 1e-10
  8.8

Sage example in ./lp.tex, line 194::

  sage: p.get_values(x), p.get_values(y), p.get_values(z) # abs tol 1e-10
  (4.0, 0.0, 1.6)

Sage example in ./lp.tex, line 214::

  sage: x = p.new_variable()

Sage example in ./lp.tex, line 224::

  sage: p.add_constraint( x[1] + x[12] - x[14] >= 8 )

Sage example in ./lp.tex, line 236::

  sage: p.add_constraint( x["i_am_a_valid_index"] + x["a",pi] <= 3 )

Sage example in ./lp.tex, line 248::

  sage: p.add_constraint( p.sum(
  ....:       x[i,j] for i in range(4) for j in range(4)) <= 1 )

Sage example in ./lp.tex, line 287::

  sage: p = MixedIntegerLinearProgram()
  sage: p.set_objective( p[3] + p[2] )
  sage: p.add_constraint( p[3] <= 5 )

Sage example in ./lp.tex, line 293::

  sage: p.solve()
  Traceback (most recent call last):
    ...
  MIPSolverException: GLPK: The LP (relaxation) problem has no dual feasible solution

Sage example in ./lp.tex, line 301::

  sage: p.add_constraint( p[2] <= 8 )
  sage: p.solve() # abs tol 1e-10
  13.0

Sage example in ./lp.tex, line 306::

  sage: p.add_constraint( p[3] >= 6 ); p.solve()
  Traceback (most recent call last):
    ...
  MIPSolverException: GLPK: Problem has no feasible solution

Sage example in ./lp.tex, line 319::

  sage: p = MixedIntegerLinearProgram()
  sage: p.set_objective( p[3] )
  sage: p.add_constraint( p[3] <= 4.75 ); p.add_constraint( p[3] >= 4.25 )
  sage: p.solve() # abs tol 1e-10
  4.75
  sage: p.set_integer(p[3]); p.solve()
  Traceback (most recent call last):
    ...
  MIPSolverException: GLPK: Problem has no feasible solution

Sage example in ./lp.tex, line 360::

  sage: try:
  ....:    p.solve()
  ....:    print("The problem has a solution!")
  ....: except RuntimeError:
  ....:    print("The problem is infeasible!")
  The problem is infeasible!

Sage example in ./lp.tex, line 429::

  sage: C = 1
  sage: L = ["Pan", "Book", "Knife", "Flask", "Flashlight"]
  sage: w = [0.57,0.35,0.98,0.39,0.08]; u = [0.57,0.26,0.29,0.85,0.23]
  sage: weight = {}; utility = {}
  sage: for o in L:
  ....:    weight[o] = w[L.index(o)]; utility[o] = u[L.index(o)]

Sage example in ./lp.tex, line 451::

  sage: p = MixedIntegerLinearProgram()
  sage: taken = p.new_variable( binary = True )
  sage: p.add_constraint(
  ....:   p.sum( weight[o] * taken[o] for o in L ) <= C )
  sage: p.set_objective(
  ....:   p.sum( utility[o] * taken[o] for o in L ) )
  sage: p.solve() # abs tol 1e-10
  1.4199999999999999
  sage: taken = p.get_values(taken)

Sage example in ./lp.tex, line 470::

  sage: sum( weight[o] * taken[o] for o in L ) # abs tol 1e-10
  0.960000000000000

Sage example in ./lp.tex, line 482::

  sage: taken["Flask"]
  1.0

Sage example in ./lp.tex, line 551::

  sage: g = graphs.PetersenGraph()
  sage: p = MixedIntegerLinearProgram()
  sage: matching = p.new_variable(binary = True)

Sage example in ./lp.tex, line 561::

  sage: p.set_objective(p.sum(matching[e]
  ....:                 for e in g.edges(labels = False)))

Sage example in ./lp.tex, line 573::

  sage: for v in g:
  ....:    p.add_constraint(p.sum(matching[e]
  ....:          for e in g.edges_incident(v, labels = False)) <= 1)
  sage: p.solve()
  5.0

Sage example in ./lp.tex, line 586::

  sage: matching = p.get_values(matching, convert=ZZ, tolerance=1e-3)
  sage: sorted(e for e, b in matching.items() if b == 1)
  [(0, 1), (2, 3), (4, 9), (5, 7), (6, 8)]

Sage example in ./lp.tex, line 665::

  sage: g = graphs.ChvatalGraph()
  sage: g = g.minimum_outdegree_orientation()

Sage example in ./lp.tex, line 669::

  sage: p = MixedIntegerLinearProgram()
  sage: f = p.new_variable()
  sage: s, t = 0, 2

Sage example in ./lp.tex, line 674::

  sage: for v in g:
  ....:    if v == s or v == t: continue
  ....:    p.add_constraint(
  ....:          p.sum(f[v,u] for u in g.neighbors_out(v)) ==
  ....:          p.sum(f[u,v] for u in g.neighbors_in(v)))

Sage example in ./lp.tex, line 681::

  sage: for e in g.edges(labels = False): p.add_constraint( f[e] <= 1 )

Sage example in ./lp.tex, line 684::

  sage: p.set_objective(p.sum( f[s,u] for u in g.neighbors_out(s)))

Sage example in ./lp.tex, line 687::

  sage: p.solve()
  2.0

Sage example in ./lp.tex, line 847::

  sage: g = graphs.Grid2dGraph(4, 6)
  sage: p = MixedIntegerLinearProgram()
  sage: b = p.new_variable(binary = True)

Sage example in ./lp.tex, line 861::

  sage: B = lambda x,y : b[frozenset([x,y])]

Sage example in ./lp.tex, line 874::

  sage: for u in g:
  ....:   p.add_constraint( p.sum( B(u,v) for v in g.neighbors(u) ) == 2 )

Sage example in ./lp.tex, line 892::

  sage: p.solve()
  0.0
  sage: h = Graph()
  sage: h.add_edges( [(u,v) for u, v in g.edges(labels = False)
  ....:                if p.get_values(B(u,v), convert=ZZ, tolerance=1e-3) == 1] )

Sage example in ./lp.tex, line 906::

  sage: while not h.is_connected():
  ....:     S = h.connected_components()[0]
  ....:     p.add_constraint(
  ....:            p.sum( B(u,v) for u,v
  ....:                 in g.edge_boundary(S, labels = False))
  ....:                >= 2)
  ....:     zero = p.solve()
  ....:     h = Graph()
  ....:     h.add_edges( [(u,v)
  ....:                   for u,v in g.edges(labels = False)
  ....:                   if p.get_values(B(u,v), convert=ZZ, tolerance=1e-3) == 1] )

"""

