Summary: An extensible window manager for the X Window System
Name: sawfish
Version: 1.11
Release: 1%{?dist}
License: GPLv2+ and Artistic 2.0
# GPLv2+ is for Sawfish
# Artistic 2.0 is for sounds
Group: User Interface/Desktops
Source0: http://download.tuxfamily.org/%{name}/%{name}-%{version}.tar.bz2
URL: http://sawfish.wikia.com/
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
BuildRequires: gmp-devel
BuildRequires: gtk2-devel
BuildRequires: libXft-devel
BuildRequires: libXtst-devel
BuildRequires: libICE-devel
BuildRequires: libSM-devel
BuildRequires: texinfo
BuildRequires: gettext
BuildRequires: kde-filesystem
BuildRequires: desktop-file-utils
BuildRequires: librep-devel >= 0.92.3
BuildRequires: rep-gtk-devel >= 0.90.7
Requires: control-center-filesystem
Requires: hicolor-icon-theme
Requires: kde-filesystem
Requires: librep >= 0.92.3
Requires: rep-gtk >= 0.90.7

%define rep_execdir %(pkg-config librep --variable=repcommonexecdir)

%description
Sawfish is an extensible window manager which uses a Lisp-based
scripting language.  All window decorations are configurable and the
basic idea is to have as much user-interface policy as possible
controlled through the Lisp language.  Configuration can be
accomplished by writing Lisp code in a personal .sawfishrc file, or
using a GTK+ interface.  Sawfish is mostly GNOME compliant

%package devel
Summary: Development files for Sawfish
Group: Development/Languages
Requires: %{name} = %{version}-%{release}, pkgconfig

%description devel
Include files for Sawfish development.

%prep
%setup -q

%build
/bin/sh autogen.sh --nocfg
/usr/bin/makeinfo --no-validate --no-headers man/news.texi >NEWS
%configure
make %{?_smp_mflags}

%install
make install DESTDIR=%{buildroot}
%find_lang %{name}
gzip -9nf %{buildroot}%{_infodir}/sawfish*
rm -f %{buildroot}%{_infodir}/dir
find %{buildroot}%{_libdir} -name \*.a -exec rm '{}' \;
find %{buildroot}%{_libdir} -name \*.la -exec rm '{}' \;
# Fix main.jl (sawfish-config) for rpmlint
sed -i -e '/^\#!/,/^!\#/d' %{buildroot}%{_datadir}/sawfish/lisp/sawfish/cfg/main.jl

desktop-file-validate %{buildroot}%{_datadir}/applications/sawfish.desktop
desktop-file-validate %{buildroot}%{_datadir}/gnome/wm-properties/sawfish-wm.desktop
desktop-file-validate %{buildroot}%{_kde4_appsdir}/ksmserver/windowmanagers/sawfish.desktop
desktop-file-validate %{buildroot}%{_datadir}/xsessions/sawfish.desktop

%post
/sbin/install-info %{_infodir}/sawfish.info.gz %{_infodir}/dir

%preun
if [ "$1" = 0 ]; then
    /sbin/install-info --delete %{_infodir}/sawfish.info.gz %{_infodir}/dir
fi

%files -f %{name}.lang
%doc COPYING COPYING.SOUNDS README README.IMPORTANT NEWS doc/*
%dir %{_kde4_appsdir}/ksmserver
%dir %{_kde4_appsdir}/ksmserver/windowmanagers
%{_bindir}/*
%{rep_execdir}/sawfish
%{_libdir}/sawfish
%{_datadir}/sawfish
%{_datadir}/applications/sawfish.desktop
%{_datadir}/gnome/wm-properties/sawfish-wm.desktop
%{_kde4_appsdir}/ksmserver/windowmanagers/sawfish.desktop
%{_datadir}/xsessions/sawfish.desktop
%{_datadir}/icons/hicolor/32x32/apps/sawfish-config.png
%{_mandir}/man1/sawfish*.gz
%{_infodir}/sawfish*

%files devel
%{_includedir}/sawfish
%{_libdir}/pkgconfig/sawfish.pc

# Note about rpmlint warning:
# W: devel-file-in-non-devel-package /usr/bin/sawfish-config
# This is sawfish GUI configurator, not devel config script.

%changelog
* Tue Apr 22 2014 Allan Duncan
- Shamelessly copied sawfish.spec from Fedora's distro and made a sawfish.spec.in
- Altered to run autorun.sh and makeinfo for NEWS for the git version

* Thu Sep 26 2013 Kim B. Heino <b@bbbs.net> - 1.10-1
- Update to 1.10

* Sun Aug 04 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.9.91-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_20_Mass_Rebuild

* Sun May 12 2013 Kim B. Heino <b@bbbs.net> - 1.9.91-1
- Update to 1.9.91

* Thu Feb 14 2013 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.9.90-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_19_Mass_Rebuild

* Thu Jan 17 2013 Kim B. Heino <b@bbbs.net> - 1.9.90-1
- Update to 1.9.90

* Sun Nov 11 2012 Kim B. Heino <b@bbbs.net> - 1.9.1-1
- Update to 1.9.1

* Mon Aug 27 2012 Adam Jackson <ajax@redhat.com> 1.9.0-3
- sawfish-1.9.0-no-pangox.patch: Adapt to pangox removal

* Sat Jul 21 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.9.0-2
- Rebuilt for https://fedoraproject.org/wiki/Fedora_18_Mass_Rebuild

* Fri Jun 29 2012 Kim B. Heino <b@bbbs.net> - 1.9.0-1
- Update to 1.9.0
- Cleanup spec file

* Mon Mar 26 2012 Kim B. Heino <b@bbbs.net> - 1.8.92-1
- Update to 1.8.92

* Sat Jan 14 2012 Fedora Release Engineering <rel-eng@lists.fedoraproject.org> - 1.8.91-3
- Rebuilt for https://fedoraproject.org/wiki/Fedora_17_Mass_Rebuild

* Wed Nov  2 2011 Kim B. Heino <b@bbbs.net> - 1.8.91-2
- Rebuild

* Sun Oct  9 2011 Kim B. Heino <b@bbbs.net> - 1.8.91-1
- Update to 1.8.91

* Mon Aug 22 2011 Kim B. Heino <b@bbbs.net> - 1.8.90-1
- Update to 1.8.90

* Sat Jul 30 2011 Kim B. Heino <b@bbbs.net> - 1.8.1-2
- Rebuild for new librep

* Mon May  2 2011 Kim B. Heino <b@bbbs.net> - 1.8.1-1
- Update to 1.8.1

* Fri Apr 15 2011 Kim B. Heino <b@bbbs.net> - 1.8.0-2
- Updated spec file

* Thu Mar 31 2011 Kim B. Heino <b@bbbs.net> - 1.8.0-1
- Update to 1.8.0

* Sat Sep 25 2010 Kim B. Heino <b@bbbs.net> - 1.7.0-1
- fix url, icons, misc fixes

* Sun Jan 10 2010 Kim B. Heino <b@bbbs.net> - 1.6.2-1
- fix devel package, fix rpmlint warnings

* Sat Sep 05 2009 Kim B. Heino <b@bbbs.net>
- add dist-tag, update files list

* Fri Jan 18 2008 Christopher Bratusek <zanghar@freenet.de>
- several fixups

* Mon Jun 12 2000 John Harper <john@dcs.warwick.ac.uk>
- merged differences from RH spec file

* Mon Apr 24 2000 John Harper <john@dcs.warwick.ac.uk>
- s/sawmill/sawfish/

* Fri Sep 17 1999 John Harper <john@dcs.warwick.ac.uk>
- don't patch the Makefile

* Tue Sep 14 1999 Aron Griffis <agriffis@bigfoot.com>
- 0.6 spec file update: added buildroot
