// -----------------------------------------------------------------------------------------------------
// Copyright (c) 2006-2023, Knut Reinert & Freie Universität Berlin
// Copyright (c) 2016-2023, Knut Reinert & MPI für molekulare Genetik
// This file may be used, modified and/or redistributed under the terms of the 3-clause BSD-License
// shipped with this file and also available at: https://github.com/seqan/seqan3/blob/master/LICENSE.md
// -----------------------------------------------------------------------------------------------------

/*!\file
 * \brief Meta-header for the \link core_debug_stream Core / Debug Stream submodule \endlink.
 * \author Marcel Ehrhardt <marcel.ehrhardt AT fu-berlin.de>
 */

/*!\defgroup core_debug_stream Debug Stream
 * \ingroup core
 * \see core
 * \brief Provides core functionality used to print seqan3 and std types.
 */

#pragma once

#include <seqan3/core/debug_stream/byte.hpp>
#include <seqan3/core/debug_stream/debug_stream_type.hpp>
#include <seqan3/core/debug_stream/optional.hpp>
#include <seqan3/core/debug_stream/range.hpp>
#include <seqan3/core/debug_stream/tuple.hpp>
#include <seqan3/core/debug_stream/variant.hpp>
