// Copyright (c) 2016, the SDSL Project Authors.  All rights reserved.
// Please see the AUTHORS file for details.  Use of this source code is governed
// by a BSD license that can be found in the LICENSE file.
/*!\file bp_support.hpp
 * \brief bp_support.hpp contains several classed which support find_open, find_close, enclose and rr-enclose queries.
 * \author Simon Gog
 */

#ifndef INCLUDED_SDSL_BP_SUPPORT
#define INCLUDED_SDSL_BP_SUPPORT

/** \defgroup bps Balanced Parentheses Supports (BPS)
 * This group contains data structures which supports a sdsl::bit_vector with the following methods:
 *   - find_open
 *   - find_close
 *   - enclose
 *   - double_enclose
 *   - rank
 *   - select
 *   - excess
 *   - rr_enclose
 */

// clang-format off
// Cyclic includes start
#include <sdsl/bp_support_g.hpp>
#include <sdsl/bp_support_gg.hpp>
#include <sdsl/bp_support_sada.hpp>
// Cyclic includes end
// clang-format on

#endif
