## Copyright (C) 1993,1994 by the author(s).
# 
# This software is published in the hope that it will be useful, but
# WITHOUT ANY WARRANTY for any part of this software to work correctly
# or as described in the manuals. See the ShapeTools Public License
# for details.
#
# Permission is granted to use, copy, modify, or distribute any part of
# this software but only under the conditions described in the ShapeTools 
# Public License. A copy of this license is supposed to have been given
# to you along with ShapeTools in a file named LICENSE. Among other
# things, this copyright notice and the Public License must be
# preserved on all copies.

#
# AtFS -- Attribute Filesystem
#
# mkatfs.sh -- initialize and configure AtFS repository
#
# Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
#
# $Header: mkatfs.sh[7.2] Mon Aug  8 13:51:43 1994 andy@cs.tu-berlin.de frozen $

usage () {
  echo "usage: mkatfs [-cT max_total_cache_size] [-cN max_cached_per_name]"
  echo "              [-cA max_cached_per_uniq_attribute] [-cQ]"
  echo "              [-g group] [-h] [-l path] [-m mode] [-v] pathnames"
}

trapexit () {
  exit 1
}

perror () {
  echo 1>&2 $*
}

trap trapexit 1 2 3 15 

argc=$#
pathgiven=false
curdir=`pwd`

maxTotal=0
maxPerName=0
maxPerAttr=0

configured=false

while [ $argc -gt 0 ]
do
  i=$1
  shift
  argc=`expr $argc - 1`
  case $i in
    -cT)
      if [ $argc -gt 0 ]
      then
	maxTotal=$1
	shift
	argc=`expr $argc - 1`
      else
	perror usage: mkatfs -cT requires an argument.
	exit 1
      fi;;
    -cN)
      if [ $argc -gt 0 ]
      then
	maxPerName=$1
	shift
	argc=`expr $argc - 1`
      else
	perror usage: mkatfs -cN requires an argument.
	exit 1
      fi;;
    -cA)
      if [ $argc -gt 0 ]
      then
	maxPerAttr=$1
	shift
	argc=`expr $argc - 1`
      else
	perror usage: mkatfs -cA requires an argument.
	exit 1
      fi;;
    -cQ)
      cacheadm
      exit 0;;
    -g)
      if [ $argc -gt 0 ]
      then
	group=$1
	shift
	argc=`expr $argc - 1`
      else
	perror usage: mkatfs -g requires a group argument.
	exit 1
      fi;;
    -h)
      usage
      exit 0;;
    -l)
      if [ $argc -gt 0 ]
      then
	linkto=`echo $1 | sed -e 's,/$,,'` # cut trailing slash
	shift
	argc=`expr $argc - 1`
      else
	perror usage: mkatfs -l requires a path argument.
	exit 1
      fi;;
    -m)
      if [ $argc -gt 0 ]
      then
	mode=$1
	shift
	argc=`expr $argc - 1`
      else
	perror usage: mkatfs -m requires a mode argument.
	exit 1
      fi;;
    -v)
      echo This is 'mkatfs release AtFS-1.71 (Tue Aug 23 17:54:06 1994 by andy@cs.tu-berlin.de).'
      exit 0;;
    -*)
      perror invalid option $i
      usage
      exit 1;;
    *)
      pathgiven=true
      cd $i
      if [ "$linkto" ]
      then
	linkbase=`basename $linkto`
	if [ $linkbase = AtFS ]
	then
	  linkto=`dirname $linkto`
	fi
	ln -s $linkto/AtFS AtFS 2> /dev/null
	if [ $? -gt 0 ]
	then
	  echo $linkto/AtFS > AtFS
	fi
        msg1=linked
      else
	if [ ! -d AtFS ]
	then
	  mkdir AtFS AtFS/Attr AtFS/Data AtFS/Lock
	  msg1=initialized
	else
	  msg1=exists
	fi
      fi
      if [ "$group" ]
      then
	chgrp $group AtFS AtFS/Attr AtFS/Data AtFS/Lock
	if [ "$msg1" = "exists" ]
	then
	  msg1="configured"
	else
	  msg1="$msg1 and configured"
	fi
	configured=true
      fi
      if [ "$mode" ]
      then
	chmod $mode AtFS AtFS/Attr AtFS/Data AtFS/Lock
	if [ "$configured" = "false" ]
	then
	  if [ "$msg1" = "exists" ]
	  then
	    msg1="configured"
	  else
	    msg1="$msg1 and configured"
	  fi
	fi
	configured=true
      fi
      if [ $maxTotal != 0 ] || [ $maxPerName != 0 ] || [ $maxPerAttr != 0 ]
      then
	cacheadm -T $maxTotal -N $maxPerName -A $maxPerAttr
	if [ $? -eq 0 ]
	then
	  if [ "$msg1" = "exists" ]
	  then
	    msg1="object cache configured"
	  else
	    msg1="$msg1 and object cache configured"
	  fi
	fi
      fi
      cd $curdir
  esac
done

if [ $pathgiven = false ]
then
  if [ "$linkto" ]
  then
    linkbase=`basename $linkto`
    if [ $linkbase = AtFS ]
    then
      linkto=`dirname $linkto`
    fi
    ln -s $linkto/AtFS AtFS 2> /dev/null
    if [ $? -gt 0 ]
    then
      echo $linkto/AtFS > AtFS
    fi
    msg1=linked
  else
    if [ ! -d AtFS ]
    then
      mkdir AtFS AtFS/Attr AtFS/Data AtFS/Lock
      msg1=initialized
    else
      msg1=exists
    fi
  fi
  if [ "$group" ]
  then
    chgrp $group AtFS AtFS/Attr AtFS/Data AtFS/Lock
    if [ "$msg1" = "exists" ]
    then
      msg1="configured"
    else
      msg1="$msg1 and configured"
    fi
    configured=true
  fi
  if [ "$mode" ]
  then
    chmod $mode AtFS AtFS/Attr AtFS/Data AtFS/Lock
    if [ "$configured" = "false" ]
    then
      if [ "$msg1" = "exists" ]
      then
        msg1="configured"
      else
        msg1="$msg1 and configured"
      fi
    fi
    configured=true
  fi
  if [ $maxTotal != 0 ] || [ $maxPerName != 0 ] || [ $maxPerAttr != 0 ]
  then
    cacheadm -T $maxTotal -N $maxPerName -A $maxPerAttr
    if [ $? -eq 0 ]
    then
      if [ "$msg1" = "exists" ]
      then
        msg1="object cache configured"
      else
        msg1="$msg1 and object cache configured"
      fi
    fi
  fi
fi

echo "AtFS repository $msg1."
exit 0
