/****************************************************************************
 **
 ** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
 ** All rights reserved.
 ** Contact: Nokia Corporation (qt-info@nokia.com)
 **
 ** This file is part of the examples of the Qt Toolkit.
 **
 ** $QT_BEGIN_LICENSE:LGPL$
 ** Commercial Usage
 ** Licensees holding valid Qt Commercial licenses may use this file in
 ** accordance with the Qt Commercial License Agreement provided with the
 ** Software or, alternatively, in accordance with the terms contained in
 ** a written agreement between you and Nokia.
 **
 ** GNU Lesser General Public License Usage
 ** Alternatively, this file may be used under the terms of the GNU Lesser
 ** General Public License version 2.1 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.LGPL included in the
 ** packaging of this file.  Please review the following information to
 ** ensure the GNU Lesser General Public License version 2.1 requirements
 ** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
 **
 ** In addition, as a special exception, Nokia gives you certain additional
 ** rights.  These rights are described in the Nokia Qt LGPL Exception
 ** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
 **
 ** GNU General Public License Usage
 ** Alternatively, this file may be used under the terms of the GNU
 ** General Public License version 3.0 as published by the Free Software
 ** Foundation and appearing in the file LICENSE.GPL included in the
 ** packaging of this file.  Please review the following information to
 ** ensure the GNU General Public License version 3.0 requirements will be
 ** met: http://www.gnu.org/copyleft/gpl.html.
 **
 ** If you have questions regarding the use of this file, please contact
 ** Nokia at qt-info@nokia.com.
 ** $QT_END_LICENSE$
 **
 ****************************************************************************/

#ifndef CODEEDITOR_H
#define CODEEDITOR_H

#include <QPlainTextEdit>
#include <QObject>
#include <QGroupBox>
#include <QLineEdit>
#include <QToolButton>
#include <QToolButton>
#include <QCheckBox>
#include <QGridLayout>
#include <QComboBox>
#include <QGraphicsScene>

#include "highlighter.h"
#include "multitextcursor.h"

#if defined Q_WS_WIN || defined Q_OS_WIN
#define FONTFAM "Lucida Console"
#elif defined Q_WS_MAC || defined Q_OS_MAC
#define FONTFAM "Monaco"
#else
#define FONTFAM "Droid Sans Mono"
#endif

QT_BEGIN_NAMESPACE
class QPaintEvent;
class QResizeEvent;
class QSize;
class QCompleter;
class QWidget;
class ChGL;
class PlayOpenGL;
QT_END_NAMESPACE

class LineNumberArea;
class AfixHighlightArea;

static inline bool isPrintableText(const QString &text) {
    return !text.isEmpty() && (text.at(0).isPrint() || text.at(0) == QLatin1Char('\t'));
}


/*! \brief CodeEditor is the editor of shelXle featuring syntax higlighter, code completer, LineNumberArea, AfixHighlightArea and Part Higlighter.
 *
 *
 */
class CodeEditor : public QPlainTextEdit {
  Q_OBJECT

  public:
    CodeEditor(QWidget *parent = 0);
    ~CodeEditor();
    QList<int> sfac;//!<List of Scattering factors.
    QStringList sfacsmbl;//!<List of Scattering factors pte symbols (needed as D has same atomic number as H)
    QStringList easf;//!Electron Atom Scattering Factors (SFAC)
    QStringList xasf;//!X-Ray Atom Scattering Factors (SFAC)
    int sortierWeise;
    int midCursorpos;
    bool ListFile;
    bool uCanSeeMe;
    bool dark;
    double smin;
    double smax;
    QString unitAlt, unitNeu;
    //QSyntaxHighlighter *highlighter;//!< Highlighter is the syntax higlighter. 
    Highlighter *highlighter;//!< Highlighter is the syntax higlighter. 
    void setCompleter(QCompleter *c);//!< setCompleter sets the QCompleter for the editor.
    QCompleter *completer() const;//!< completer is the QCompleter
    QStringList blocks; //!< blocks is a QStringList containing the lines of the editor.
    QList<int> errorInLine; //!< A list of line numbers with syntax errors.

    void lineNumberAreaPaintEvent(QPaintEvent *event);//!< The paint event of LineNumberArea.
    void afixHighlightAreaPaintEvent(QPaintEvent *event);//!< The paint event of AfixHighlightArea.
    void hoverLineNumber(QMouseEvent *event);
    int lineNumberAreaWidth();//!< calulates the width of the LineNumberArea.
    void diffTo(QString org);//!< A simple line diff used for the SaveHistoryWidget. Changes back ground color of differering lines into orange. @param org The original file content. 
    QList<int> parenthesis;//!< List of lines.  If the line in an afix environment the value is greater than zero. 
    QList<int> parenthesis2;//!< List of lines. The value is the current part number.
    //    QList<bool> parenthesis3;//!< List of lines. If it is OK to have nested afixes like in afix 66 it is true.
    QList<bool> comment;//!< List of all lines true if they are comments
    QList<double> fv;//!< List of 'Free Variables' in the SHELX res or ins file. 
    int fvMinLine;//!< fvMinLine specifies the line number of the FVAR istruction. 
    QGroupBox   *suchbox;
    QLineEdit   *searchLE, *replace;
    QToolButton *hidesearch;
    QToolButton *prev,*next,*replaceButton,*replacePButton,*replaceAButton; 
    QCheckBox   *wholeLine;
    QGridLayout *slt;
    QComboBox    *resiFinder;
    QString dispFromWave(int an);
    QString sortLabelList(CEnvironment &asymm, MyAtom &tatze);
    void searchchanged(bool current,bool back);
  //void searchchanged2(bool current,bool back);
    MultiTextCursor multiTextCursor() const;
    void setMultiTextCursor(const MultiTextCursor &cursor);
    QRect cursorUpdateRect(const MultiTextCursor &cursor);
    void doSetTextCursor1(const QTextCursor &cursor);
    void doSetTextCursor(const QTextCursor &cursor, bool keepMultiSelection);
    //void setExtraSelections(Utils::Id kind, const QList<QTextEdit::ExtraSelection> &selections);
    //    QHash<Utils::Id, QList<QTextEdit::ExtraSelection>> m_extraSelections;

    void startCursorFlashTimer();
    void resetCursorFlashTimer();
    QBasicTimer m_cursorFlashTimer;
    bool m_cursorVisible;
    //bool m_moveLineUndoHack = false;
    void updateCursorSelections();
    void moveCursor(QTextCursor::MoveOperation operation,  QTextCursor::MoveMode mode = QTextCursor::MoveAnchor);
    bool cursorMoveKeyEvent(QKeyEvent *e);
    void handleHomeKey(bool anchor, bool block);
    void handleBackspaceKey();
    struct BlockSelection{
        int blockNumber;
        int column;
        int anchorBlockNumber;
        int anchorColumn;
    };
    QList<BlockSelection> m_blockSelections;
    QList<QTextCursor> generateCursorsForBlockSelection(const BlockSelection &blockSelection);
    void initBlockSelection();
    void clearBlockSelection();
    void handleMoveBlockSelection(QTextCursor::MoveOperation op);
    struct CursorData
    {
        QTextLayout *layout;
        QPointF offset;
        int pos;
        QPen pen;
    };

    struct PaintEventData{
        PaintEventData(CodeEditor *editor, QPaintEvent *event, QPointF offset)
            : offset(offset)
            , viewportRect(editor->viewport()->rect())
            , eventRect(event->rect())
            , doc(editor->document())
            , documentLayout(qobject_cast<QPlainTextDocumentLayout *>(doc->documentLayout()))
            , documentWidth(int(doc->size().width()))
            , textCursor(editor->textCursor())
            , textCursorBlock(textCursor.block())
            , isEditable(!editor->isReadOnly())
        { }
        QPointF offset;
        const QRect viewportRect;
        const QRect eventRect;
        qreal rightMargin;
        const QTextDocument *doc;
        QPlainTextDocumentLayout *documentLayout;
        const int documentWidth;
        const QTextCursor textCursor;
        const QTextBlock textCursorBlock;
        const bool isEditable;
        const QTextCharFormat searchScopeFormat;
        const QTextCharFormat searchResultFormat;
        const QTextCharFormat visualWhitespaceFormat;
        const QTextCharFormat ifdefedOutFormat;
        QAbstractTextDocumentLayout::PaintContext context;
        QTextBlock  visibleCollapsedBlock;
        QPointF visibleCollapsedBlockOffset;
        QTextBlock block;
        QList<CursorData> cursors;
    };//PaintEventData
    struct PaintEventBlockData{
        QRectF boundingRect;
        QVector<QTextLayout::FormatRange> selections;
        QTextLayout *layout;
        int position;
        int length;
    };
    void setupBlockLayout(const PaintEventData &data, QPainter &painter, PaintEventBlockData &blockData) const;
    void setupSelections(const PaintEventData &data, PaintEventBlockData &blockData) const;
    void addCursorsPosition(PaintEventData &data, QPainter &painter, const PaintEventBlockData &blockData) const;
    void paintCursor(const PaintEventData &data, QPainter &painter) const;
    static bool blockContainsCursor(const PaintEventBlockData &blockData, const QTextCursor &cursor);
    static CursorData generateCursorData(const int cursorPos,
                                         const PaintEventData &data,
                                         const PaintEventBlockData &blockData,
                                         QPainter &painter);

signals:
    void findInStructure(const QString &);//!< findInStructure is emitted by a context menu to select and center an atom in the OpenGL representation of the structure.
    void openIncludeFile(const QString &);
    void electInStructure(const QString &);//!< electInStructure is emitted by a context menu to select atoms found in the editor text selection in the OpenGL representation.
    void deleteSelected();//!< deleteSelected is emitted by a context menu to select and delete atoms found in the editor text selection in the OpenGL representation.
    void saveMe(bool spell, bool loadafter);
    void updateLabel();//!< the rename mode is updated 
protected:
    void resizeEvent(QResizeEvent *event);
    bool viewportEvent(QEvent *event);
    void keyPressEvent(QKeyEvent *e);    
    void mouseMoveEvent(QMouseEvent *);
    void mousePressEvent(QMouseEvent *);    
    void timerEvent(QTimerEvent *);
    void focusInEvent(QFocusEvent *e);
    void contextMenuEvent(QContextMenuEvent *event);
    void focusOutEvent(QFocusEvent *e);
    void paintEvent(QPaintEvent *);

public slots:
    void testCpd();
    void mpaste();
    void mcut();
    void plotSFAC();
    void slotCursorPositionChanged();
    void updateCursorPosition();
    void handleCBstates(int  state);
    void vis(bool b){ uCanSeeMe=b; }
    void fitWidth();
    void restoreMinimumWidth();
    void updateLineNumberAreaWidth(int newBlockCount);//!< updateLineNumberAreaWidth sets the new width of LineNumberArea for the given amount of lines newBlockCount. @param newBlockCount number of lines in the editor.
    void insertAnis();//!< inserts ANIS instruction into the file.
    void insertActa();//!< inserts ACTA instruction into the file.
    void insertCONF();//!< inserts CONF instruction into the file.
    void insertList4();//!< inserts a LIST 4 instruction into the file.
    void insertList6();//!< inserts a LIST 6 instruction into the file.
    void insertBind();//!< inserts a BIND instruction into the file.
    void insertEXTI();//!< inserts a EXTI instruction into the file.
    void insertFree();//!< inserts a FREE instruction into the file.
    void insertElectronSFACs();
    void insertXRaySFACs();
    void findResi(int);//!<Searches a Residue via a string like "RESI 22 ALA" or "RESI ALA 22" in the editor and selects all atoms with the same residue number (eg: 22).
    void findText();//!<Find functionality of search and replace in the editor.
    void hideSearch();//!< Hides the search and replace widget for the editor.
    void replaceAll();//!<replace all functionality of search and replace in the editor.
    void replaceNext();//!<replace next functionality of search and replace in the editor.
    void replacePrev();//!<replace previous functionality of search and replace in the editor.
    void showSearch();//!< shows the search and repleace for the editor.
    void changeSortierWeise(QAction* action);//!<Changes the sorting option to action->data. @param action the calling QAction.
    void sortAtoms();//!< sorts atoms in file acording to the sort option.  
    void sortAtoms(CEnvironment &as);//!< sorts atoms in file acording to the sort option.
    void sortSelectedRegion();//!< sorts all atoms found in selected text in the structure @params info seleted text.
    void expandGreaterThan();//!< some SHELXL re- or constrainst use > to specify a range of atoms this is a problem for sorting atoms
    void findNext();//!<Find next (F3) functionality of search and replace in the editor. 
    void findPrev();//!<Find previous functionality of search and replace in the editor.
    void weedEmptySfacs();//!< weeds out unused scattering factors 
    void updateUnit();//!< the unit instruction gets the true amount of atoms per type
    void dispFromWave();//!<calculates f', f" and mu for the given wavelength and inserts DISP lines for each SFAC entry.
    void resiFinderDestroyed();
    void decreaseEdtiorFont();//!<Decreases the editor font by one point.
    void increaseEdtiorFont();//!< Increases the editor font by one point.
    void jumpToError();//!< the cursor points to the first syntax error in the file.a
    void jumpToAtom(int index);//!< if rename mode is visible the atom at index gets renamed if not the cursor of the editor is pointed to the specified atom.
    void omitsome(const QString &s);//!< insetrts a 'OMIT h k l\n' string in the res file.  
    void insertDFIX(double value, double esd, QList<MyAtom> selected, QString resiSpec=""); //!< Insert DFIX restraint into ins file
    void insertDANG(double value, double esd, QList<MyAtom> selected, QString resiSpec=""); //!< Insert DANG restraint into ins file
    void insertFLAT(double esd, QList<MyAtom> selected, QString resiSpec=""); //!< Insert FLAT restraint into ins file
    void insertEXYZ(QList<MyAtom> selected, QString resiSpec=""); //!< Insert EXYZ restraint into ins file
    void insertEADP(QList<MyAtom> selected, QString resiSpec=""); //!< Insert EADP restraint into ins file
    void insertDELU(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec=""); //!< Insert DELU restraint into ins file
    void insertSIMU(double esd1, double esd2, double dmax, QList<MyAtom> selected, QString resiSpec=""); //!< Insert SIMU restraint into ins file
    void insertISOR(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec=""); //!< Insert ISOR restraint into ins file
    void insertRIGU(double esd1, double esd2, QList<MyAtom> selected, QString resiSpec=""); //!< Insert RIGU restraint into ins file
    void insertCHIV(double vol, double esd1, QList<MyAtom> selected, QString resiSpec=""); //!< Insert CHIV restraint into ins file
    void insertANIS(QList<MyAtom> selected); //!< Insert ANIS for selected atoms
    void updateLineNumberArea(const QRect &, int);//!< updateLineNumberArea in the curent viewport.
    void updateAfix();//!< updateAfix updates the parenthesis list for the AfixHighlightArea. 
    void updateWght();//!< the WGHT instruction is updated from the back of the res file
    void insertCompletion(const QString &completion);//!< insertCompletion inserts the text selected in the completer. @param completion selected text of the completer.
    void searchInStructure();//!< Select and center an atom in the OpenGL representation of the structure.
    void openAnIncludeFile();
    void selectInStructure();//!< Select atoms found in the editor text selection in the OpenGL representation.
    void lineNumberToggled(QMouseEvent *event);//!< when the LineNumberArea is clicked the comment state of the secified line is toggled.
    void remark(int line);//!< toggles the comment state of the secified line. @param line The line number in file
    void toggleRemarks();//!< toggleRemarks toggles the comment state of the selected lines.
    /*
    void setgl(ChGL *g){
      chgl=g;
    }//!< setgl passes the ChGL widget to the CodeEditor
    // */
    //*
    void setgl(PlayOpenGL *g){
        chgl=g;
    }
    // */

private:
    QString selectedRestraintsAtoms(QString buffer, QList<MyAtom> selected, QString resiSpec, bool exclude_H=false);
    QString textUnderCursor() const;
    QWidget *lineNumberArea;
    QCompleter *c;
    QWidget *afixHighlightArea;
    //ChGL *chgl;
    PlayOpenGL *chgl;
    bool cbhandled=true;
    MultiTextCursor m_cursors;
    bool startMouseMoveCursor1;
    double cromerMann(double sintl, double a1, double b1,  double a2,  double b2, double a3, double b3, double a4, double b4, double c);
    const QRegularExpression spaces = QRegularExpression("\\s+");
    const QRegularExpression comments = QRegularExpression("^REM",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression onlydigits = QRegularExpression("^[0-9]+$");
    const QRegularExpression nodigits = QRegularExpression("\\D");
    const QRegularExpression digits = QRegularExpression("\\d+");
    const QRegularExpression plusfloat = QRegularExpression("[.0-9]+");
    const QRegularExpression grossbuch = QRegularExpression("^[A-Z]");
    const QRegularExpression onlysmall = QRegularExpression("^[a-z]$");
    const QRegularExpression linecontinue = QRegularExpression("^[0-9]+");
    const QRegularExpression listinst = QRegularExpression("\nLIST",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression unitinst = QRegularExpression("^UNIT",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression actainst = QRegularExpression("^ACTA",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression sfacinst = QRegularExpression("^SFAC",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression hklfinst = QRegularExpression("^HKLF",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression extiinst = QRegularExpression("^EXTI",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression confinst = QRegularExpression("^CONF",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression omithklinst = QRegularExpression("^OMIT\\s+\\d+\\s+\\d+\\s+\\d+");
    const QRegularExpression afix0inst = QRegularExpression("^AFIX\\s+0",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression afixinst = QRegularExpression("^AFIX\\s+\\d+",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression part0inst = QRegularExpression("^PART\\s+0",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression partinst = QRegularExpression("^PART\\s+[-0-9]{1,}",QRegularExpression::CaseInsensitiveOption);
    const QRegularExpression startsmall = QRegularExpression("^[a-z]+");
};

/////////////////////////////////////////////////
/*! \brief AfixHighlightArea is a colored bar right of the LineNumberArea to indicate if the line is in a AFIX environment.
 *
 *  This is just a dummy class to reimplement the paintEvent which is impemented in CodeEditor.
 *
 */
class AfixHighlightArea : public QWidget{
  public:
    AfixHighlightArea(CodeEditor *editor) : QWidget(editor){
      codeEditor = editor;
    }
    QSize sizeHint() const {
      return QSize(5,0);
    }
  protected:
    void paintEvent(QPaintEvent *event){
      codeEditor->afixHighlightAreaPaintEvent(event);
    }//!< calls afixHighlightAreaPaintEvent().
    void mouseMoveEvent(QMouseEvent *event){
        codeEditor->hoverLineNumber(event);
    }
  private:
    CodeEditor *codeEditor;
};
/////////////////////////////////////////////////
/*! \brief LineNumberArea is a area with line numbers left of the CodeEditor.
 *
 * This is just a dummy class to reimplement the paintEvent and mousePressEvent which are impemented in CodeEditor.
 */
class LineNumberArea : public QWidget{
  public:
    LineNumberArea(CodeEditor *editor) : QWidget(editor) {
      codeEditor = editor;
    }

    QSize sizeHint() const {
      return QSize(codeEditor->lineNumberAreaWidth(), 0);
    }

  protected:
    void paintEvent(QPaintEvent *event) {
      codeEditor->lineNumberAreaPaintEvent(event);
    }//!< calls lineNumberAreaPaintEvent().
    void mousePressEvent ( QMouseEvent * event ){
      codeEditor->lineNumberToggled(event);
    }//!< calls lineNumberToggled().
    void mouseMoveEvent(QMouseEvent *event){
        codeEditor->hoverLineNumber(event);
    }

  private:
    CodeEditor *codeEditor;
};

class CheckBox : public QCheckBox{
public:
    CheckBox(QGraphicsScene * scene, const QString & text, QWidget * parent = 0);
protected:
    void hoverEnter(QHoverEvent *event);
    void hoverLeave(QHoverEvent *event);
    void hoverMove(QHoverEvent *event);
    bool event(QEvent *event){
        switch (event->type()){
        case QEvent::HoverEnter:
            hoverEnter(static_cast<QHoverEvent*>(event));
            return true;
            break;
        case QEvent::HoverLeave:
            hoverLeave(static_cast<QHoverEvent*>(event));
            return true;
            break;
        case QEvent::HoverMove:
            hoverMove(static_cast<QHoverEvent*>(event));
            return true;
            break;
        default:
            break;
        }
        return QWidget::event(event);
    }
private:
    QGraphicsScene *scene;
};

#endif
