/*!
 * MediaElement.js
 * http://www.mediaelementjs.com/
 *
 * Wrapper that mimics native HTML5 MediaElement (audio and video)
 * using a variety of technologies (pure JavaScript, Flash, iframe)
 *
 * Copyright 2010-2017, John Dyer (http://j.hn/)
 * License: MIT
 *
 */
function getQueryStringValue(a){return decodeURIComponent(window.location.search.replace(new RegExp("^(?:.*[&?]"+encodeURIComponent(a).replace(/[.+*]/g,"$&")+"(?:=([^&]*))?)?.*$","i"),"$1"))}function updateUrlParameter(d,b,e){var a=d.indexOf("#"),g=a===-1?"":d.substr(a);d=a===-1?d:d.substr(0,a);var c=new RegExp("([?&])"+b+"=.*?(&|$)","i"),f=d.indexOf("?")!==-1?"&":"?";if(!e){d=d.replace(new RegExp("([?&]?)"+b+"=[^&]*","i"),"");if(d.slice(-1)==="?"){d=d.slice(0,-1)}if(d.indexOf("?")===-1){d=d.replace(/&/,"?")}}else{if(d.match(c)){d=d.replace(c,"$1"+b+"="+e+"$2")}else{d=d+f+b+"="+e}}return d+g}var lang=getQueryStringValue("lang")||"en",stretching=getQueryStringValue("stretching")||"auto",languageSelector=document.querySelector("select[name=lang]"),stretchingSelector=document.querySelector("select[name=stretching]"),sourcesSelector=document.querySelectorAll("select[name=sources]"),sourcesTotal=sourcesSelector.length;languageSelector.value=lang;languageSelector.addEventListener("change",function(){window.location.href=updateUrlParameter(window.location.href,"lang",languageSelector.value)});stretchingSelector.value=stretching;stretchingSelector.addEventListener("change",function(){window.location.href=updateUrlParameter(window.location.href,"stretching",stretchingSelector.value)});for(var i=0;i<sourcesTotal;i++){sourcesSelector[i].addEventListener("change",function(){var c=this.closest(".players").querySelector(".mejs__container").id,a=mejs.players[c];a.setSrc(this.value.replace("&amp;","&"));a.load();if(!mejs.Features.isiOS&&!mejs.Features.isAndroid){a.play()}var b=document.getElementById(a.media.id+"-rendername");b.querySelector(".src").innerHTML='<a href="'+this.value+'" target="_blank">'+this.value+"</a>";b.querySelector(".renderer").innerHTML=a.media.rendererName;b.querySelector(".error").innerHTML=""});if(mejs.Features.isiOS){sourcesSelector[i].querySelector('option[value^="rtmp"]').disabled=true;if(sourcesSelector[i].querySelector('option[value$="webm"]')){sourcesSelector[i].querySelector('option[value$="webm"]').disabled=true}if(sourcesSelector[i].querySelector('option[value$=".mpd"]')){sourcesSelector[i].querySelector('option[value$=".mpd"]').disabled=true}if(sourcesSelector[i].querySelector('option[value$=".ogg"]')){sourcesSelector[i].querySelector('option[value$=".ogg"]').disabled=true}}}document.addEventListener("DOMContentLoaded",function(){mejs.i18n.language(lang);var b=document.querySelectorAll("video, audio"),a,c=b.length;for(a=0;a<c;a++){new MediaElementPlayer(b[a],{stretching:stretching,pluginPath:"../build/",success:function(e){var d=document.getElementById(e.id+"-rendername");e.addEventListener("loadedmetadata",function(){var f=e.originalNode.getAttribute("src").replace("&amp;","&");if(f!==null&&f!==undefined){d.querySelector(".src").innerHTML='<a href="'+f+'" target="_blank">'+f+"</a>";d.querySelector(".renderer").innerHTML=e.rendererName;d.querySelector(".error").innerHTML=""}});e.addEventListener("error",function(f){d.querySelector(".error").innerHTML="<strong>Error</strong>: "+f.message})}})}});