// GENERATED FILE - DO NOT EDIT.
// Generated by generate_tests.py
//
// Copyright (c) 2022 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

#include "../diff_test_utils.h"

#include "gtest/gtest.h"

namespace spvtools {
namespace diff {
namespace {

// Test that OpTypeForwardPointer is matched when one SPIR-V doesn't have debug
// info
constexpr char kSrc[] = R"(               OpCapability Kernel
               OpCapability Addresses
               OpCapability Linkage
               OpMemoryModel Logical OpenCL
               OpName %structptr "structptr"
               OpTypeForwardPointer %structptr UniformConstant
       %uint = OpTypeInt 32 0
   %structt1 = OpTypeStruct %structptr %uint
   %structt2 = OpTypeStruct %uint %structptr
   %structt3 = OpTypeStruct %uint %uint %structptr
   %structt4 = OpTypeStruct %uint %uint %uint %structptr
  %structptr = OpTypePointer UniformConstant %structt1)";
constexpr char kDst[] = R"(               OpCapability Kernel
               OpCapability Addresses
               OpCapability Linkage
               OpMemoryModel Logical OpenCL
               OpTypeForwardPointer %structptr UniformConstant
       %uint = OpTypeInt 32 0
   %structt1 = OpTypeStruct %structptr %uint
   %structt2 = OpTypeStruct %uint %structptr
   %structt3 = OpTypeStruct %uint %uint %structptr
   %structt4 = OpTypeStruct %uint %uint %uint %structptr
  %structptr = OpTypePointer UniformConstant %structt1
)";

TEST(DiffTest, OptypeforwardpointerOnesidedDebug) {
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
 ; Bound: 7
 ; Schema: 0
 OpCapability Kernel
 OpCapability Addresses
 OpCapability Linkage
 OpMemoryModel Logical OpenCL
-OpName %1 "structptr"
 OpTypeForwardPointer %1 UniformConstant
 %2 = OpTypeInt 32 0
 %3 = OpTypeStruct %1 %2
 %4 = OpTypeStruct %2 %1
 %5 = OpTypeStruct %2 %2 %1
 %6 = OpTypeStruct %2 %2 %2 %1
 %1 = OpTypePointer UniformConstant %3
)";
  Options options;
  DoStringDiffTest(kSrc, kDst, kDiff, options);
}

TEST(DiffTest, OptypeforwardpointerOnesidedDebugNoDebug) {
  constexpr char kSrcNoDebug[] = R"(               OpCapability Kernel
               OpCapability Addresses
               OpCapability Linkage
               OpMemoryModel Logical OpenCL
               OpTypeForwardPointer %structptr UniformConstant
       %uint = OpTypeInt 32 0
   %structt1 = OpTypeStruct %structptr %uint
   %structt2 = OpTypeStruct %uint %structptr
   %structt3 = OpTypeStruct %uint %uint %structptr
   %structt4 = OpTypeStruct %uint %uint %uint %structptr
  %structptr = OpTypePointer UniformConstant %structt1
)";
  constexpr char kDstNoDebug[] = R"(               OpCapability Kernel
               OpCapability Addresses
               OpCapability Linkage
               OpMemoryModel Logical OpenCL
               OpTypeForwardPointer %structptr UniformConstant
       %uint = OpTypeInt 32 0
   %structt1 = OpTypeStruct %structptr %uint
   %structt2 = OpTypeStruct %uint %structptr
   %structt3 = OpTypeStruct %uint %uint %structptr
   %structt4 = OpTypeStruct %uint %uint %uint %structptr
  %structptr = OpTypePointer UniformConstant %structt1
)";
  constexpr char kDiff[] = R"( ; SPIR-V
 ; Version: 1.6
 ; Generator: Khronos SPIR-V Tools Assembler; 0
 ; Bound: 7
 ; Schema: 0
 OpCapability Kernel
 OpCapability Addresses
 OpCapability Linkage
 OpMemoryModel Logical OpenCL
 OpTypeForwardPointer %1 UniformConstant
 %2 = OpTypeInt 32 0
 %3 = OpTypeStruct %1 %2
 %4 = OpTypeStruct %2 %1
 %5 = OpTypeStruct %2 %2 %1
 %6 = OpTypeStruct %2 %2 %2 %1
 %1 = OpTypePointer UniformConstant %3
)";
  Options options;
  DoStringDiffTest(kSrcNoDebug, kDstNoDebug, kDiff, options);
}

}  // namespace
}  // namespace diff
}  // namespace spvtools
