/******************************COPYRIGHT NOTICE*******************************/
/*  (c) Centro de Regulacio Genomica                                                        */
/*  and                                                                                     */
/*  Cedric Notredame                                                                        */
/*  22 Oct 2013 - 15:51.                                                                    */
/*All rights reserved.                                                                      */
/*This file is part of T-COFFEE.                                                            */
/*                                                                                          */
/*    T-COFFEE is free software; you can redistribute it and/or modify                      */
/*    it under the terms of the GNU General Public License as published by                  */
/*    the Free Software Foundation; either version 2 of the License, or                     */
/*    (at your option) any later version.                                                   */
/*                                                                                          */
/*    T-COFFEE is distributed in the hope that it will be useful,                           */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of                        */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the                         */
/*    GNU General Public License for more details.                                          */
/*                                                                                          */
/*    You should have received a copy of the GNU General Public License                     */
/*    along with Foobar; if not, write to the Free Software                                 */
/*    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA             */
/*...............................................                                           */
/*  If you need some more information                                                       */
/*  cedric.notredame@europe.com                                                             */
/*...............................................                                           */
/******************************COPYRIGHT NOTICE*******************************/
#ifndef MATRICES_H
#define MATRICES_H


char *amino_acid_order = "ABCDEFGHIKLMNPQRSTVWXYZ";

//Jones Taylor Thornton, tm matrix, 
//H JOND940101
//D The 250 PAM transmembrane protein exchange matrix (Jones et al., 1994)
//R LIT:2006072 PMID:8112466
//A Jones, D.T., Taylor, W.R. and Thornton, J.M.
//T A mutation data matrix for transmembrane proteins
//J FEBS Lett. 339, 269-275 (1994)
int jtttm250mt[]={
  2,
  0,   0,
  0,   0,   6,
  0,   0,  -3,  12,
  0,   0,  -3,   8,  13,
 -2,   0,   1,  -6,  -6,   5,
  1,   0,  -1,   3,   3,  -4,   6,
 -3,   0,  -1,   3,   2,  -3,  -3,  11,
  0,   0,  -1,  -3,  -4,  -1,  -2,  -4,   2,
 -2,   0,  -3,   3,   1,  -5,  -1,   4,  -4,  12,
 -2,   0,  -1,  -5,  -5,   1,  -4,  -4,   1,  -4,   3,
 -1,   0,  -1,  -3,  -3,   0,  -3,  -3,   1,  -1,   1,   3,
 -1,   0,  -1,   6,   1,  -4,  -2,   3,  -3,   5,  -4,  -2,  11,
  0,   0,  -4,  -2,  -3,  -4,  -2,  -4,  -3,  -4,  -1,  -3,  -2,  11,
 -2,   0,  -3,   2,   7,  -4,  -1,   7,  -4,   6,  -2,  -2,   3,   0,  11,
 -1,   0,  -1,   1,   2,  -4,   0,   5,  -3,   9,  -3,   0,   2,  -3,   6,   7,
  2,   0,   1,   0,   0,  -1,   1,  -2,  -1,  -1,  -2,  -2,   2,  -1,  -1,  -1,   3,
  1,   0,   0,   0,  -1,  -2,   0,  -2,   0,  -2,  -1,   0,   1,  -1,  -2,  -1,   2,   3,
  0,   0,   0,  -3,  -2,  -1,  -1,  -4,   2,  -4,   0,   1,  -3,  -3,  -4,  -2,  -1,   0,   2,
 -4,   0,   1,  -4,  -3,  -3,  -2,  -1,  -3,   3,  -2,  -2,  -3,  -6,   0,   5,  -3,  -4,  -2,  12,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
 -3,   0,   3,  -2,  -5,   2,  -5,   6,  -4,   1,  -3,  -3,  -1,  -5,   0,  -1,   0,  -3,  -4,  -2,   0,  10,
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0};


int blosum30mt[]={
  4,
  0,  5,
 -3, -2, 17,
  0,  5, -3,  9,
  0,  0,  1,  1,  6,
 -2, -3, -3, -5, -4, 10,
  0,  0, -4, -1, -2, -3,  8,
 -2, -2, -5, -2,  0, -3, -3, 14,
  0, -2, -2, -4, -3,  0, -1, -2,  6,
  0,  0, -3,  0,  2, -1, -1, -2, -2,  4,
 -1, -1,  0, -1, -1,  2, -2, -1,  2, -2,  4,
  1, -2, -2, -3, -1, -2, -2,  2,  1,  2,  2,  6,
  0,  4, -1,  1, -1, -1,  0, -1,  0,  0, -2,  0,  8,
 -1, -2, -3, -1,  1, -4, -1,  1, -3,  1, -3, -4, -3, 11,
  1, -1, -2, -1,  2, -3, -2,  0, -2,  0, -2, -1, -1,  0,  8,
 -1, -2, -2, -1, -1, -1, -2, -1, -3,  1, -2,  0, -2, -1,  3,  8,
  1,  0, -2,  0,  0, -1,  0, -1, -1,  0, -2, -2,  0, -1, -1, -1,  4,
  1,  0, -2, -1, -2, -2, -2, -2,  0, -1,  0,  0,  1,  0,  0, -3,  2,  5,
  1, -2, -2, -2, -3,  1, -3, -3,  4, -2,  1,  0, -2, -4, -3, -1, -1,  1,  5,
 -5, -5, -2, -4, -1,  1,  1, -5, -3, -2, -2, -3, -7, -3, -1,  0, -3, -5, -3, 20,
  0, -1, -2, -1, -1, -1, -1, -1,  0,  0,  0,  0,  0, -1,  0, -1,  0,  0,  0, -2, -1,
 -4, -3, -6, -1, -2,  3, -3,  0, -1, -1,  3, -1, -4, -2, -1,  0, -2, -1,  1,  5, -1,  9,
  0,  0,  0,  0,  5, -4, -2,  0, -3,  1, -1, -1, -1,  0,  4,  0, -1, -1, -3, -1,  0, -2,  4};

int blosum40mt[]={
  5,
 -1,  5,
 -2, -2, 16,
 -1,  6, -2,  9,
 -1,  1, -2,  2,  7,
 -3, -3, -2, -4, -3,  9,
  1, -1, -3, -2, -3, -3,  8,
 -2,  0, -4,  0,  0, -2, -2, 13,
 -1, -3, -4, -4, -4,  1, -4, -3,  6,
 -1,  0, -3,  0,  1, -3, -2, -1, -3,  6,
 -2, -3, -2, -3, -2,  2, -4, -2,  2, -2,  6,
 -1, -3, -3, -3, -2,  0, -2,  1,  1, -1,  3,  7,
 -1,  4, -2,  2, -1, -3,  0,  1, -2,  0, -3, -2,  8,
 -2, -2, -5, -2,  0, -4, -1, -2, -2, -1, -4, -2, -2, 11,
  0,  0, -4, -1,  2, -4, -2,  0, -3,  1, -2, -1,  1, -2,  8,
 -2, -1, -3, -1, -1, -2, -3,  0, -3,  3, -2, -1,  0, -3,  2,  9,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -3, -2,  1, -1,  1, -1,  5,
  0,  0, -1, -1, -1, -1, -2, -2, -1,  0, -1, -1,  0,  0, -1, -2,  2,  6,
  0, -3, -2, -3, -3,  0, -4, -4,  4, -2,  2,  1, -3, -3, -3, -2, -1,  1,  5,
 -3, -4, -6, -5, -2,  1, -2, -5, -3, -2, -1, -2, -4, -4, -1, -2, -5, -4, -3, 19,
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1,  0, -1, -2, -1, -1,  0,  0, -1, -2, -1,
 -2, -3, -4, -3, -2,  4, -3,  2,  0, -1,  0,  1, -2, -3, -1, -1, -2, -1, -1,  3, -1,  9,
 -1,  2, -3,  1,  5, -4, -2,  0, -4,  1, -2, -2,  0, -1,  4,  0,  0, -1, -3, -2, -1, -2,  5};

int blosum45mt[]={
  5,
 -1,  4,
 -1, -2, 12,
 -2,  5, -3,  7,
 -1,  1, -3,  2,  6,
 -2, -3, -2, -4, -3,  8,
  0, -1, -3, -1, -2, -3,  7,
 -2,  0, -3,  0,  0, -2, -2, 10,
 -1, -3, -3, -4, -3,  0, -4, -3,  5,
 -1,  0, -3,  0,  1, -3, -2, -1, -3,  5,
 -1, -3, -2, -3, -2,  1, -3, -2,  2, -3,  5,
 -1, -2, -2, -3, -2,  0, -2,  0,  2, -1,  2,  6,
 -1,  4, -2,  2,  0, -2,  0,  1, -2,  0, -3, -2,  6,
 -1, -2, -4, -1,  0, -3, -2, -2, -2, -1, -3, -2, -2,  9,
 -1,  0, -3,  0,  2, -4, -2,  1, -2,  1, -2,  0,  0, -1,  6,
 -2, -1, -3, -1,  0, -2, -2,  0, -3,  3, -2, -1,  0, -2,  1,  7,
  1,  0, -1,  0,  0, -2,  0, -1, -2, -1, -3, -2,  1, -1,  0, -1,  4,
  0,  0, -1, -1, -1, -1, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  2,  5,
  0, -3, -1, -3, -3,  0, -3, -3,  3, -2,  1,  1, -3, -3, -3, -2, -1,  0,  5,
 -2, -4, -5, -4, -3,  1, -2, -3, -2, -2, -2, -2, -4, -3, -2, -2, -4, -3, -3, 15,  
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,  0,  0, -1, -2, -1,
 -2, -2, -3, -2, -2,  3, -3,  2,  0, -1,  0,  0, -2, -3, -1, -1, -2, -1, -1,  3, -1,  8,
 -1,  2, -3,  1,  4, -3, -2,  0, -3,  1, -2, -1,  0, -1,  4,  0,  0, -1, -3, -2, -1, -2,  4};

int blosum50mt[] = {
   5,
  -2,   5,
  -1,  -3,  13,
  -2,   5,  -4,   8,
  -1,   1,  -3,   2,   6,
  -3,  -4,  -2,  -5,  -3,   8,
   0,  -1,  -3,  -1,  -3,  -4,   8,
  -2,   0,  -3,  -1,   0,  -1,  -2,  10,
  -1,  -4,  -2,  -4,  -4,   0,  -4,  -4,   5,
  -1,   0,  -3,  -1,   1,  -4,  -2,   0,  -3,   6,
  -2,  -4,  -2,  -4,  -3,   1,  -4,  -3,   2,  -3,   5,
  -1,  -3,  -2,  -4,  -2,   0,  -3,  -1,   2,  -2,   3,   7,
  -1,   4,  -2,   2,   0,  -4,   0,   1,  -3,   0,  -4,  -2,   7,
  -1,  -2,  -4,  -1,  -1,  -4,  -2,  -2,  -3,  -1,  -4,  -3,  -2,  10,
  -1,   0,  -3,   0,   2,  -4,  -2,   1,  -3,   2,  -2,   0,   0,  -1,   7,
  -2,  -1,  -4,  -2,   0,  -3,  -3,   0,  -4,   3,  -3,  -2,  -1,  -3,   1,   7,
   1,   0,  -1,   0,  -1,  -3,   0,  -1,  -3,   0,  -3,  -2,   1,  -1,   0,  -1,   5,
   0,   0,  -1,  -1,  -1,  -2,  -2,  -2,  -1,  -1,  -1,  -1,   0,  -1,  -1,  -1,   2,   5,
   0,  -4,  -1,  -4,  -3,  -1,  -4,  -4,   4,  -3,   1,   1,  -3,  -3,  -3,  -3,  -2,   0,   5,
  -3,  -5,  -5,  -5,  -3,   1,  -3,  -3,  -3,  -3,  -2,  -1,  -4,  -4,  -1,  -3,  -4,  -3,  -3,  15,
  -1,  -1,  -2,  -1,  -1,  -2,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -2,  -1,  -1,  -1,   0,  -1,  -3,  -1,
  -2,  -3,  -3,  -3,  -2,   4,  -3,   2,  -1,  -2,  -1,   0,  -2,  -3,  -1,  -1,  -2,  -2,  -1,   2,  -1,   8,
  -1,   2,  -3,   1,   5,  -4,  -2,   0,  -3,   1,  -3,  -1,   0,  -1,   4,   0,   0,  -1,  -3,  -2,  -1,  -2,   5};


int blosum55mt[]={
  5,
 -2,  5,
  0, -4, 13,
 -2,  5, -4,  8,
 -1,  1, -4,  2,  7,
 -3, -5, -3, -5, -4,  9,
  0, -1, -3, -2, -3, -4,  8,
 -2,  0, -4, -1, -1, -1, -2, 11,
 -2, -4, -2, -4, -4,  0, -5, -4,  6,
 -1,  0, -4, -1,  1, -4, -2,  0, -4,  6,
 -2, -4, -2, -5, -4,  1, -5, -3,  2, -3,  6,
 -1, -3, -2, -4, -3,  0, -3, -2,  2, -2,  3,  8,
 -2,  4, -3,  2,  0, -4,  0,  1, -4,  0, -4, -3,  8,
 -1, -2, -3, -2, -1, -5, -3, -3, -3, -1, -4, -3, -2, 10,
 -1,  0, -4,  0,  2, -4, -2,  1, -4,  2, -3,  0,  0, -1,  7,
 -2, -1, -4, -2,  0, -3, -3,  0, -4,  3, -3, -2, -1, -3,  1,  8,
  2,  0, -1,  0,  0, -3,  0, -1, -3,  0, -3, -2,  1, -1,  0, -1,  5,
  0, -1, -1, -1, -1, -3, -2, -2, -1, -1, -2, -1,  0, -1, -1, -1,  2,  6,
  0, -4, -1, -4, -3, -1, -4, -4,  4, -3,  1,  1, -4, -3, -3, -3, -2,  0,  5,
 -4, -5, -4, -5, -3,  2, -3, -3, -3, -4, -3, -2, -5, -5, -2, -3, -4, -3, -4, 15,
 -1, -1, -2, -2, -1, -2, -2, -1, -1, -1, -1, -1, -1, -2, -1, -1, -1, -1, -1, -3, -1,
 -2, -3, -3, -3, -2,  4, -4,  2, -1, -2, -1, -1, -2, -4, -1, -2, -2, -2, -2,  3, -1,  9,
 -1,  2, -4,  1,  5, -4, -3,  0, -4,  1, -3, -2,  0, -1,  4,  0,  0, -1, -3, -3, -1, -2,  5};

int blosum62mt[]={
  4,
 -2,  4,
  0, -3,  9,
 -2,  4, -3,  6,
 -1,  1, -4,  2,  5,
 -2, -3, -2, -3, -3,  6,
  0, -1, -3, -1, -2, -3,  6,
 -2,  0, -3, -1,  0, -1, -2,  8,
 -1, -3, -1, -3, -3,  0, -4, -3,  4,
 -1,  0, -3, -1,  1, -3, -2, -1, -3,  5,
 -1, -4, -1, -4, -3,  0, -4, -3,  2, -2,  4,
 -1, -3, -1, -3, -2,  0, -3, -2,  1, -1,  2,  5,
 -2,  3, -3,  1,  0, -3,  0,  1, -3,  0, -3, -2,  6,
 -1, -2, -3, -1, -1, -4, -2, -2, -3, -1, -3, -2, -2,  7,
 -1,  0, -3,  0,  2, -3, -2,  0, -3,  1, -2,  0,  0, -1,  5,
 -1, -1, -3, -2,  0, -3, -2,  0, -3,  2, -2, -1,  0, -2,  1,  5,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -2, -1,  1, -1,  0, -1,  4,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  1,  5,
  0, -3, -1, -3, -2, -1, -3, -3,  3, -2,  1,  1, -3, -2, -2, -3, -2,  0,  4,
 -3, -4, -2, -4, -3,  1, -2, -2, -3, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 11,
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1,  0,  0, -1, -2, -1,
 -2, -3, -2, -3, -2,  3, -3,  2, -1, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1,  2, -1,  7,
 -1,  1, -3,  1,  4, -3, -2,  0, -3,  1, -3, -1,  0, -1,  3,  0,  0, -1, -2, -3, -1, -2,  4};

int blosum62mt3[]={
  0,
 -2,  0,
  0, -3,  0,
 -2,  4, -3,  0,
 -1,  1, -4,  2,  0,
 -2, -3, -2, -3, -3,  0,
  0, -1, -3, -1, -2, -3,  0,
 -2,  0, -3, -1,  0, -1, -2,  0,
 -1, -3, -1, -3, -3,  0, -4, -3,  0,
 -1,  0, -3, -1,  1, -3, -2, -1, -3,  0,
 -1, -4, -1, -4, -3,  0, -4, -3,  2, -2,  0,
 -1, -3, -1, -3, -2,  0, -3, -2,  1, -1,  2,  0,
 -2,  3, -3,  1,  0, -3,  0,  1, -3,  0, -3, -2,  0,
 -1, -2, -3, -1, -1, -4, -2, -2, -3, -1, -3, -2, -2,  0,
 -1,  0, -3,  0,  2, -3, -2,  0, -3,  1, -2,  0,  0, -1,  0,
 -1, -1, -3, -2,  0, -3, -2,  0, -3,  2, -2, -1,  0, -2,  1,  0,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -2, -1,  1, -1,  0, -1,  0,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  1,  0,
  0, -3, -1, -3, -2, -1, -3, -3,  3, -2,  1,  1, -3, -2, -2, -3, -2,  0,  0,
 -3, -4, -2, -4, -3,  1, -2, -2, -3, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 0,
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1,  0,  0, -1, -2, 0,
 -2, -3, -2, -3, -2,  3, -3,  2, -1, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1,  2, -1,  0,
 -1,  1, -3,  1,  4, -3, -2,  0, -3,  1, -3, -1,  0, -1,  3,  0,  0, -1, -2, -3, -1, -2,  0};

int blosum62mt2[]={
  0,
 -2,  4,
  0, -3,  0,
 -2,  4, -3,  2,
 -1,  1, -4,  2,  2,
 -2, -3, -2, -3, -3,  3,
  0, -1, -3, -1, -2, -3,  0,
 -2,  0, -3, -1,  0, -1, -2,  2,
 -1, -3, -1, -3, -3,  0, -4, -3,  2,
 -1,  0, -3, -1,  1, -3, -2, -1, -3,  2,
 -1, -4, -1, -4, -3,  0, -4, -3,  2, -2,  1,
 -1, -3, -1, -3, -2,  0, -3, -2,  1, -1,  2,  0,
 -2,  3, -3,  1,  0, -3,  0,  1, -3,  0, -3, -2,  0,
 -1, -2, -3, -1, -1, -4, -2, -2, -3, -1, -3, -2, -2,  0,
 -1,  0, -3,  0,  2, -3, -2,  0, -3,  1, -2,  0,  0, -1,  2,
 -1, -1, -3, -2,  0, -3, -2,  0, -3,  2, -2, -1,  0, -2,  1,  0,
  1,  0, -1,  0,  0, -2,  0, -1, -2,  0, -2, -1,  1, -1,  0, -1,  1,
  0, -1, -1, -1, -1, -2, -2, -2, -1, -1, -1, -1,  0, -1, -1, -1,  1,  1,
  0, -3, -1, -3, -2, -1, -3, -3,  3, -2,  1,  1, -3, -2, -2, -3, -2,  0,  1,
 -3, -4, -2, -4, -3,  1, -2, -2, -3, -3, -2, -1, -4, -4, -2, -3, -3, -2, -3, 1,
  0, -1, -2, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1, -1,  0,  0, -1, -2, -1,
 -2, -3, -2, -3, -2,  3, -3,  2, -1, -2, -1, -1, -2, -3, -1, -2, -2, -2, -1,  2, -1,  3,
 -1,  1, -3,  1,  4, -3, -2,  0, -3,  1, -3, -1,  0, -1,  3,  0,  0, -1, -2, -3, -1, -2,  4};
 

int blosum80mt[]={
  7,
 -3,  6,
 -1, -6, 13,
 -3,  6, -7, 10,
 -2,  1, -7,  2,  8,
 -4, -6, -4, -6, -6, 10,
  0, -2, -6, -3, -4, -6,  9,
 -3, -1, -7, -2,  0, -2, -4, 12,
 -3, -6, -2, -7, -6, -1, -7, -6,  7,
 -1, -1, -6, -2,  1, -5, -3, -1, -5,  8,
 -3, -7, -3, -7, -6,  0, -7, -5,  2, -4,  6,
 -2, -5, -3, -6, -4,  0, -5, -4,  2, -3,  3,  9,
 -3,  5, -5,  2, -1, -6, -1,  1, -6,  0, -6, -4,  9,
 -1, -4, -6, -3, -2, -6, -5, -4, -5, -2, -5, -4, -4, 12,
 -2, -1, -5, -1,  3, -5, -4,  1, -5,  2, -4, -1,  0, -3,  9,
 -3, -2, -6, -3, -1, -5, -4,  0, -5,  3, -4, -3, -1, -3,  1,  9,
  2,  0, -2, -1, -1, -4, -1, -2, -4, -1, -4, -3,  1, -2, -1, -2,  7,
  0, -1, -2, -2, -2, -4, -3, -3, -2, -1, -3, -1,  0, -3, -1, -2,  2,  8,
 -1, -6, -2, -6, -4, -2, -6, -5,  4, -4,  1,  1, -5, -4, -4, -4, -3,  0,  7,
 -5, -8, -5, -8, -6,  0, -6, -4, -5, -6, -4, -3, -7, -7, -4, -5, -6, -5, -5, 16,
 -1, -3, -4, -3, -2, -3, -3, -2, -2, -2, -2, -2, -2, -3, -2, -2, -1, -1, -2, -5, -2,
 -4, -5, -5, -6, -5,  4, -6,  3, -3, -4, -2, -3, -4, -6, -3, -4, -3, -3, -3,  3, -3, 11,
 -2,  0, -7,  1,  6, -6, -4,  0, -6,  1, -5, -3, -1, -2,  5,  0, -1, -2, -4, -5, -1, -4,  6};

int pam120mt[]={
  3,
  0,  4,
 -3, -6,  9,
  0,  4, -7,  5,
  0,  3, -7,  3,  5,
 -4, -5, -6, -7, -7,  8,
  1,  0, -4,  0, -1, -5,  5,
 -3,  1, -4,  0, -1, -3, -4,  7,
 -1, -3, -3, -3, -3,  0, -4, -4,  6,
 -2,  0, -7, -1, -1, -7, -3, -2, -3,  5,
 -3, -4, -7, -5, -4,  0, -5, -3,  1, -4,  5,
 -2, -4, -6, -4, -3, -1, -4, -4,  1,  0,  3,  8,
 -1,  3, -5,  2,  1, -4,  0,  2, -2,  1, -4, -3,  4,
  1, -2, -4, -3, -2, -5, -2, -1, -3, -2, -3, -3, -2,  6,
 -1,  0, -7,  1,  2, -6, -3,  3, -3,  0, -2, -1,  0,  0,  6,
 -3, -2, -4, -3, -3, -5, -4,  1, -2,  2, -4, -1, -1, -1,  1,  6,
  1,  0,  0,  0, -1, -3,  1, -2, -2, -1, -4, -2,  1,  1, -2, -1,  3,
  1,  0, -3, -1, -2, -4, -1, -3,  0, -1, -3, -1,  0, -1, -2, -2,  2,  4,
  0, -3, -3, -3, -3, -3, -2, -3,  3, -4,  1,  1, -3, -2, -3, -3, -2,  0,  5,
 -7, -6, -8, -8, -8, -1, -8, -3, -6, -5, -3, -6, -4, -7, -6,  1, -2, -6, -8, 12,
 -1, -1, -4, -2, -1, -3, -2, -2, -1, -2, -2, -2, -1, -2, -1, -2, -1, -1, -1, -5, -2,
 -4, -3, -1, -5, -5,  4, -6, -1, -2, -5, -2, -4, -2, -6, -5, -5, -3, -3, -3, -2, -3,  8,
 -1,  2, -7,  3,  4, -6, -2,  1, -3, -1, -3, -2,  0, -1,  4, -1, -1, -2, -3, -7, -1, -5,  4};

int pam160mt[]={
  2,
  0,  3,
 -2, -4,  9,
  0,  3, -5,  4,
  0,  2, -5,  3,  4,
 -3, -4, -5, -6, -5,  7,
  1,  0, -3,  0,  0, -4,  4,
 -2,  1, -3,  0,  0, -2, -3,  6,
 -1, -2, -2, -3, -2,  0, -3, -3,  5,
 -2,  0, -5,  0, -1, -5, -2, -1, -2,  4,
 -2, -4, -6, -4, -3,  1, -4, -2,  2, -3,  5,
 -1, -3, -5, -3, -2,  0, -3, -3,  2,  0,  3,  7,
  0,  2, -4,  2,  1, -3,  0,  2, -2,  1, -3, -2,  3,
  1, -1, -3, -2, -1, -4, -1, -1, -2, -2, -3, -2, -1,  5,
 -1,  1, -5,  1,  2, -5, -2,  2, -2,  0, -2, -1,  0,  0,  5,
 -2, -1, -3, -2, -2, -4, -3,  1, -2,  3, -3, -1, -1, -1,  1,  6,
  1,  0,  0,  0,  0, -3,  1, -1, -2, -1, -3, -2,  1,  1, -1, -1,  2,
  1,  0, -2, -1, -1, -3, -1, -2,  0,  0, -2, -1,  0,  0, -1, -1,  1,  3,
  0, -2, -2, -3, -2, -2, -2, -2,  3, -3,  1,  1, -2, -2, -2, -3, -1,  0,  4,
 -5, -5, -7, -6, -7, -1, -7, -3, -5, -4, -2, -4, -4, -5, -5,  1, -2, -5, -6, 12,
  0, -1, -3, -1, -1, -3, -1, -1, -1, -1, -2, -1,  0, -1, -1, -1,  0,  0, -1, -4, -1,
 -3, -3,  0, -4, -4,  5, -5,  0, -2, -4, -2, -3, -2, -5, -4, -4, -3, -3, -3, -1, -3,  8,
  0,  2, -5,  2,  3, -5, -1,  1, -2,  0, -3, -2,  1, -1,  3,  0, -1, -1, -2, -6, -1, -4,  3};

int pam250mt[]={
  2,
  0,  3,
 -2, -4, 12,
  0,  3, -5,  4,
  0,  3, -5,  3,  4,
 -3, -4, -4, -6, -5,  9,
  1,  0, -3,  1,  0, -5,  5,
 -1,  1, -3,  1,  1, -2, -2,  6,
 -1, -2, -2, -2, -2,  1, -3, -2,  5,
 -1,  1, -5,  0,  0, -5, -2,  0, -2,  5,
 -2, -3, -6, -4, -3,  2, -4, -2,  2, -3,  6,
 -1, -2, -5, -3, -2,  0, -3, -2,  2,  0,  4,  6,
  0,  2, -4,  2,  1, -3,  0,  2, -2,  1, -3, -2,  2,
  1, -1, -3, -1, -1, -5,  0,  0, -2, -1, -3, -2,  0,  6,
  0,  1, -5,  2,  2, -5, -1,  3, -2,  1, -2, -1,  1,  0,  4,
 -2, -1, -4, -1, -1, -4, -3,  2, -2,  3, -3,  0,  0,  0,  1,  6,
  1,  0,  0,  0,  0, -3,  1, -1, -1,  0, -3, -2,  1,  1, -1,  0,  2,
  1,  0, -2,  0,  0, -3,  0, -1,  0,  0, -2, -1,  0,  0, -1, -1,  1,  3,
  0, -2, -2, -2, -2, -1, -1, -2,  4, -2,  2,  2, -2, -1, -2, -2, -1,  0,  4,
 -6, -5, -8, -7, -7,  0, -7, -3, -5, -3, -2, -4, -4, -6, -5,  2, -2, -5, -6, 17,
  0, -1, -3, -1, -1, -2, -1, -1, -1, -1, -1, -1,  0, -1, -1, -1,  0,  0, -1, -4, -1,
 -3, -3,  0, -4, -4,  7, -5,  0, -1, -4, -1, -2, -2, -5, -4, -4, -3, -3, -2,  0, -2, 10,
  0,  2, -5,  3,  3, -5,  0,  2, -2,  0, -3, -2,  1,  0,  3,  0,  0, -1, -2, -6, -1, -4,  3};

int pam350mt[]={
  2,
  1,  3,
 -2, -5, 18,
  1,  3, -6,  4,
  1,  3, -6,  4,  4,
 -4, -5, -5, -6, -6, 13,
  2,  1, -4,  1,  1, -6,  5,
 -1,  1, -4,  1,  1, -2, -2,  7,
  0, -2, -3, -2, -2,  2, -2, -2,  5,
 -1,  1, -6,  1,  0, -6, -1,  1, -2,  5,
 -2, -4, -7, -4, -4,  3, -4, -2,  4, -3,  8,
 -1, -2, -6, -3, -2,  1, -3, -2,  3,  0,  5,  6,
  0,  2, -4,  2,  2, -4,  1,  2, -2,  1, -3, -2,  2,
  1,  0, -3,  0,  0, -5,  0,  0, -2, -1, -3, -2,  0,  6,
  0,  2, -6,  2,  3, -5, -1,  3, -2,  1, -2, -1,  1,  1,  4,
 -1,  0, -4, -1,  0, -5, -2,  2, -2,  4, -3,  0,  1,  0,  2,  7,
  1,  1,  0,  1,  0, -4,  1, -1, -1,  0, -3, -2,  1,  1,  0,  0,  1,
  1,  0, -2,  0,  0, -3,  1, -1,  0,  0, -2, -1,  1,  1,  0, -1,  1,  2,
  0, -2, -2, -2, -2, -1, -1, -2,  4, -2,  3,  2, -2, -1, -2, -3, -1,  0,  5,
 -7, -6,-10, -8, -8,  1, -8, -3, -6, -4, -2, -5, -5, -7, -5,  4, -3, -6, -7, 27,
  0,  0, -3, -1,  0, -2, -1,  0,  0, -1, -1,  0,  0,  0,  0, -1,  0,  0,  0, -5, -1,
 -4, -4,  1, -5, -5, 11, -6,  0,  0, -5,  0, -2, -3, -6, -5, -5, -3, -3, -2,  1, -2, 14,
  0,  2, -6,  3,  3, -6,  0,  2, -2,  1, -3, -2,  2,  0,  3,  1,  0,  0, -2, -7,  0, -5,  3};

int md_40mt[]={
  9,
  0,  0,
 -7,  0, 16,
 -6,  0,-13, 11,
 -5,  0,-15,  3, 11,
-11,  0, -5,-15,-16, 13,
 -3,  0, -7, -4, -4,-15, 10,
 -9,  0, -6, -4, -8, -7,-10, 14,
 -6,  0,-11,-12,-12, -5,-13,-11, 11,
 -8,  0,-12, -8, -3,-16, -9, -6,-11, 11,
 -9,  0,-10,-14,-13, -1,-14, -7, -1,-12,  9,
 -6,  0, -9,-12,-11, -7,-12, -9,  1, -7,  1, 14,
 -6,  0, -8,  1, -5,-12, -5,  0, -8, -1,-12, -9, 12,
 -2,  0,-11,-11,-11,-11, -9, -4,-11,-10, -5,-10, -9, 12,
 -7,  0,-12, -6,  0,-14, -9,  2,-12, -1, -6, -8, -5, -3, 12,
 -7,  0, -5,-10, -8,-15, -4,  0,-10,  3, -9, -8, -6, -6,  0, 11,
  0,  0, -2, -6, -8, -6, -2, -6, -8, -7, -7, -8,  1, -1, -7, -5,  9,
  1,  0, -7, -8, -8,-11, -7, -7, -2, -5, -9, -2, -2, -4, -7, -6,  1, 10,
 -1,  0, -7, -9, -8, -6, -8,-12,  4,-12, -2,  0,-10, -9,-11,-11, -7, -4, 10,
-14,  0, -4,-15,-15, -7, -7,-13,-13,-13, -8,-11,-14,-14,-11, -4, -9,-12,-10, 18,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
-13,  0, -2, -8,-14,  2,-13,  2, -9,-13, -9,-11, -6,-13, -9,-10, -7,-10,-11, -6,  0, 14,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

int md_120mt[]={
  6,
  0,  0,
 -3,  0, 14,
 -2,  0, -7,  8,
 -2,  0, -8,  5,  8,
 -6,  0, -2, -9,-10, 11,
  0,  0, -3,  0, -1, -9,  8,
 -4,  0, -2, -1, -3, -2, -4, 11,
 -1,  0, -5, -7, -7, -1, -6, -6,  7,
 -4,  0, -6, -2,  0, -9, -4, -1, -6,  8,
 -4,  0, -5, -8, -8,  2, -8, -4,  2, -6,  7,
 -2,  0, -5, -7, -6, -2, -6, -5,  3, -4,  3, 10,
 -1,  0, -3,  3, -1, -6, -1,  2, -4,  1, -6, -5,  8,
  0,  0, -5, -5, -5, -5, -4, -1, -5, -4, -2, -5, -3,  9,
 -3,  0, -6, -1,  2, -7, -4,  4, -6,  2, -3, -4, -1,  0,  9,
 -3,  0, -2, -4, -3, -8, -1,  2, -6,  4, -5, -4, -2, -2,  2,  8,
  2,  0,  0, -2, -3, -3,  0, -2, -3, -3, -3, -3,  2,  1, -3, -2,  5,
  2,  0, -3, -3, -4, -6, -2, -3,  0, -2, -4,  0,  1,  0, -3, -3,  2,  6,
  1,  0, -3, -5, -5, -2, -4, -6,  5, -6,  1,  2, -5, -4, -6, -6, -3,  0,  7,
 -8,  0,  0, -9, -9, -3, -3, -6, -7, -6, -4, -6, -8, -8, -6, -1, -5, -7, -6, 17,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 -7,  0,  2, -4, -7,  5, -8,  4, -5, -7, -4, -6, -2, -7, -4, -5, -3, -6, -6, -2,  0, 12,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

int md_250mt[]={
  2,
  0,  0,
 -1,  0, 11,
 -1,  0, -3,  5,
 -1,  0, -4,  4,  5,
 -3,  0,  0, -5, -5,  8,
  1,  0, -1,  1,  1, -5,  5,
 -2,  0,  0,  0,  0,  0, -2,  6,
  0,  0, -2, -3, -3,  0, -3, -3,  4,
 -1,  0, -3,  0,  1, -5, -1,  1, -3,  5,
 -1,  0, -2, -4, -4,  2, -4, -2,  2, -3,  5,
  0,  0, -2, -3, -3,  0, -3, -2,  3, -2,  3,  6,
  0,  0, -1,  2,  1, -3,  0,  1, -2,  1, -3, -2,  3,
  1,  0, -2, -2, -2, -2, -1,  0, -2, -1,  0, -2, -1,  6,
 -1,  0, -3,  0,  2, -4, -1,  3, -3,  2, -2, -2,  0,  0,  5,
 -1,  0, -1, -1,  0, -4,  0,  2, -3,  4, -3, -2,  0, -1,  2,  5,
  1,  0,  1,  0, -1, -2,  1, -1, -1, -1, -2, -1,  1,  1, -1, -1,  2,
  2,  0, -1, -1, -1, -2,  0, -1,  1, -1, -1,  0,  1,  1, -1, -1,  1,  2,
  1,  0, -2, -3, -2,  0, -2, -3,  4, -3,  2,  2, -2, -1, -3, -3, -1,  0,  4,
 -4,  0,  1, -5, -5, -1, -1, -3, -4, -3, -2, -3, -4, -4, -3,  0, -3, -4, -3, 15,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 -3,  0,  2, -2, -4,  5, -4,  4, -2, -3, -1, -3, -1, -3, -2, -2, -1, -3, -3,  0,  0,  9,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

int md_350mt[]={
  1,
  0,  0,
  0,  0,  9,
  0,  0, -2,  3,
  0,  0, -2,  3,  3,
 -2,  0,  1, -3, -4,  6,
  1,  0,  0,  1,  1, -3,  4,
 -1,  0,  0,  0,  0,  0, -1,  3,
  0,  0, -1, -2, -2,  1, -2, -2,  3,
 -1,  0, -1,  0,  1, -3,  0,  1, -2,  3,
 -1,  0, -1, -3, -3,  2, -2, -1,  2, -2,  3,
  0,  0, -1, -2, -2,  1, -2, -1,  2, -2,  2,  3,
  0,  0, -1,  1,  1, -2,  0,  1, -1,  1, -2, -1,  2,
  1,  0, -1, -1, -1, -2, -1,  0, -1, -1,  0, -1,  0,  4,
 -1,  0, -2,  1,  1, -2,  0,  2, -2,  2, -1, -1,  0,  0,  3,
 -1,  0,  0,  0,  0, -3,  0,  1, -2,  3, -2, -1,  0,  0,  2,  3,
  1,  0,  0,  0,  0, -1,  1,  0, -1,  0, -1, -1,  1,  1,  0,  0,  1,
  1,  0,  0,  0, -1, -1,  0, -1,  0,  0, -1,  0,  0,  1, -1,  0,  1,  1,
  0,  0, -1, -2, -2,  0, -1, -2,  2, -2,  1,  2, -1, -1, -2, -2,  0,  0,  2,
 -3,  0,  1, -4, -3,  0, -1, -2, -3, -2, -1, -2, -3, -3, -2,  0, -2, -3, -2, 14,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
 -2,  0,  2, -2, -2,  5, -3,  3, -1, -2,  0, -1, -1, -2, -1, -1, -1, -2, -2,  0,  0,  7,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

int idmat[]={
10,
 0, 10,
 0, 0, 10,
 0, 0, 0, 10,
 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10,
 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,10};

int dna_idmat[]={
10,
 -1, 10,
 -1, -1, 10,
 -1, -1, -1, 10,
 -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,10,
 -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,10};

int est_idmat[]={
10,
 -10, 10,
 -10, -10, 10,
 -10, -10, -10, 10,
 -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, 10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,10,
 -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10, -10,10};

/*These are the three structure specific matrices descibed by Luthy, R., McLachlan, A.D. and Eisenberg, D.
  in  Proteins 10, 229-239 (1991), taken from http://www.genome.ad.jp/dbget/dbget2.html
  ID: coil :LUTR910107 
  ID: alpha:LUTR910108
  ID: beta :LUTR910109
*/
int coil_mat []={
 11, 
  0,   0, 
  3,   0, 108, 
  2,   0,  -5,  27, 
  2,   0,   7,  -9,  15, 
-15,   0,   3, -11,  -4,  83, 
  1,   0,   4, -15,  -4,   2,  41, 
  5,   0,   4, 108,  -6, -13,  -3,  55, 
 27,   0, -11,   3,  -2, -14,   0,  -1,  49, 
 -9,   0,   3,   4, -21,  -2,  -3,  -4,  -7,  38, 
 -5,   0,  14,   7,  -5,   2,   2,  -6,  -3,   1,  48, 
 -9,   0,   3,   4,  -6, -16, -23,  -9,  -7,  -1,   7,  52, 
 28,   0,   1,   2,  27,   7,  -5,  -9,  -9, 108, -15,   3,  10, 
108,   0,   8,  14,  41,   0,  -2,  -4, -10,  -3,   1, -15,   4,  58, 
 10,   0,   3,  -9,   3,  -4,   3,   3,   8,   6, -15,  15,   5,  -6,  14, 
  1,   0,  10,   3,   1, 108,   5,  27,  -5,  -9,  -9, -15,   2,   3,   2,  28, 
  3,   0, -15,   3,  -3,  -8, -12,  -5,  -6,  -9, -19, -14,   4,   4,  -2,   7,  19, 
  7,   0,   6,   3,   0,  -7,  55, -18,  -8,  -7,   6, -20, -11,   2,  -5,   4,   3,  31, 
-11,   0,  -6, -15, -23,  -6,  -4,  -3,  19, -15,  -6, -22,   3, -11,  -4,  14,  -1,  -7,  37, 
  4,   0,  15,   3,   2,  -8,  -1, -12, -22,  -2,   5, -19,  14,   4, -21,   4,   0,  -9,  -1, 129, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  4,   0,  -4,   8,  -3, -30,  -6,  49, -10,  -7, -12, -18,   3,   3,  -6, -11,   3,   2,   2,  -5,   0,  59, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 };

int alpha_mat []={
 23, 
  0,   0, 
  5,   0,  51, 
  1,   0,   4,  28, 
  0,   0,   5,   1,  23, 
 -4,   0,   5,   1,   3,  88, 
  3,   0,   5,  -4,   2,   4,  37, 
  7,   0,   6,  51,   3,   5,  -6,  52, 
 28,   0,   1,   1,   6, -21,   2,  -6,  38, 
  1,   0,   0,   5,   4,  -2,   3,  -7, -10,  34, 
  4,   0,  11,   5,   4,   3,   5,  -6, -19,  -6,  45, 
  1,   0,   4,   6,   3, -23,  -5, -12, -14,  -4,   9,  40, 
 19,   0,   3,   0,  28,   5,   4,   1,   1,  51,  -4,   1,  13, 
 51,   0,  10,  11,  37,   1,   1,  -6,  -8,  -5,   2, -22,   5,  59, 
 13,   0,   1,   1,   0,   2,   4,   5,  10,   7,  -5,  23,   7,   3,  11, 
 -1,   0,  13,   5,   3,  51,   7,  28,   4,   1,   1,  -4,   1,   1,   0,  19, 
  1,   0,  -5,   0,  -6,   2,  -1, -10, -14,  -9,  -6, -22,   6,   3,   6,   5,  17, 
  5,   0,   7,   4,   2,   3,  52,  -8, -18,   3,   4, -24,   1,   4,   4,   5,   2,  14, 
  1,   0,   3,  -5,  -5,   5,  -7, -19,   7,  -6,  -2, -28,   4,   7,   3,  11,   2, -38,  40, 
  5,   0,  23,   5,   5,   5,  -6,  -9, -19,  -2,   3,  -4,  11,   5,   4,   6,   2, -43,  -8, 162, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  6,   0,   2,  10,   3,  -2,  -6,  38, -14,  -7,  -1, -19,   0,   5,   3,   1,   4, -29,  -6, -19,   0,  97, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 };

int beta_mat []={
 23, 
  0,   0, 
  4,   0,  97, 
  1,   0,  -5,  49, 
 -1,   0,   9,  -5,  31, 
-16,   0,   8, -11,   6,  57, 
  2,   0,   7, -16,  12,   8,  54, 
 13,   0,   9,  97,   2, -30,  -4,  55, 
 49,   0, -11,   0,   0, -22,   2,  -7,  28, 
-19,   0,   0,   7, -18,   2,  17, -12, -10,  34, 
 -5,   0,  31,   9,   1,   7,  13,  -9,  -7,  -3,  34, 
 -5,   0,   2,   9,   4,  -9, -12, -17, -13,   1,  14,  25, 
 40,   0,   2,  -1,  49,   9,  -5, -19,  -5,  97, -16,   0,  15, 
 97,   0,  17,  31,  54,   5,   5, -13, -34,  -2,   8, -11,   7,  78, 
 15,   0,   0, -19,   0,  12,   2,   8,  17,  11, -21,  31,  13,   2,  31, 
 -2,   0,  15,   4,   2,  97,  13,  49,  -5,  -5, -19, -16,   1,   0,  -1,  40, 
  0,   0, -21,   0,  -4,  -6,  -5, -13, -12,  -5, -23,  -9,   9,   7,   0,   9,  26, 
  9,   0,  11,   2,   2,   2,  55, -11, -14, -28,  12, -21, -11,   1,   1,   7,   4,  21, 
-11,   0,   2, -21, -12,  -2, -12,  -7,  13,   2,  -1, -13,   2, -10,   6,  31,   2, -22,  23, 
  7,   0,  31,   8,  13,  -7,  -7, -15, -15,  -3,  10, -31,  31,   6, -18,   9,   6, -17,  -5, 133, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  9,   0,  12,  17,  17, -12,  -9,  28, -13,  -3,   0, -12,   0,   8,   4, -11,   2,  -5,  -5,  -5,   0,  47, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0 };
/*EXPERIMENTAL MATRICES: Blosum Series*/
/*Blosum Series rescaled on blosum62mt, 
Lambda Blosum30mt=17
Lambda Blosum62mt=10
Lambda Blosum80mt=4.5
*/

int rblosum30mt []={
 52, 
 33,  56, 
 18,  23, 113, 
 33,  56,  18,  75, 
 33,  33,  37,  37,  61, 
 23,  18,  18,   9,  14,  80, 
 33,  33,  14,  28,  23,  18,  71, 
 23,  23,   9,  23,  33,  18,  18,  99, 
 33,  23,  23,  14,  18,  33,  28,  23,  61, 
 33,  33,  18,  33,  42,  28,  28,  23,  23,  52, 
 28,  28,  33,  28,  28,  42,  23,  28,  42,  23,  52, 
 37,  23,  23,  18,  28,  23,  23,  42,  37,  42,  42,  61, 
 33,  52,  28,  37,  28,  28,  33,  28,  33,  33,  23,  33,  71, 
 28,  23,  18,  28,  37,  14,  28,  37,  18,  37,  18,  14,  18,  85, 
 37,  28,  23,  28,  42,  18,  23,  33,  23,  33,  23,  28,  28,  33,  71, 
 28,  23,  23,  28,  28,  28,  23,  28,  18,  37,  23,  33,  23,  28,  47,  71, 
 37,  33,  23,  33,  33,  28,  33,  28,  28,  33,  23,  23,  33,  28,  28,  28,  52, 
 37,  33,  23,  28,  23,  23,  23,  23,  33,  28,  33,  33,  37,  33,  33,  18,  42,  56, 
 37,  23,  23,  23,  18,  37,  18,  18,  52,  23,  37,  33,  23,  14,  18,  28,  28,  37,  56, 
  9,   9,  23,  14,  28,  37,  37,   9,  18,  23,  23,  18,   0,  18,  28,  33,  18,   9,  18, 128, 
  0,  -1,  -2,  -1,  -1,  -1,  -1,  -1,   0,   0,   0,   0,   0,  -1,   0,  -1,   0,   0,   0,  -2,  -1, 
 -4,  -3,  -6,  -1,  -2,   3,  -3,   0,  -1,  -1,   3,  -1,  -4,  -2,  -1,   0,  -2,  -1,   1,   5,  -1,   9, 
  0,   0,   0,   0,   5,  -4,  -2,   0,  -3,   1,  -1,  -1,  -1,   0,   4,   0,  -1,  -1,  -3,  -1,   0,  -2,   4, 


};

 

int rblosum62mt[]={
 80, 
 20,  80, 
 40,  10, 130, 
 20,  80,  10, 100, 
 30,  50,   0,  60,  90, 
 20,  10,  20,  10,  10, 100, 
 40,  30,  10,  30,  20,  10, 100, 
 20,  40,  10,  30,  40,  30,  20, 120, 
 30,  10,  30,  10,  10,  40,   0,  10,  80, 
 30,  40,  10,  30,  50,  10,  20,  30,  10,  90, 
 30,   0,  30,   0,  10,  40,   0,  10,  60,  20,  80, 
 30,  10,  30,  10,  20,  40,  10,  20,  50,  30,  60,  90, 
 20,  70,  10,  50,  40,  10,  40,  50,  10,  40,  10,  20, 100, 
 30,  20,  10,  30,  30,   0,  20,  20,  10,  30,  10,  20,  20, 110, 
 30,  40,  10,  40,  60,  10,  20,  40,  10,  50,  20,  40,  40,  30,  90, 
 30,  30,  10,  20,  40,  10,  20,  40,  10,  60,  20,  30,  40,  20,  50,  90, 
 50,  40,  30,  40,  40,  20,  40,  30,  20,  40,  20,  30,  50,  30,  40,  30,  80, 
 40,  30,  30,  30,  30,  20,  20,  20,  30,  30,  30,  30,  40,  30,  30,  30,  50,  90, 
 40,  10,  30,  10,  20,  30,  10,  10,  70,  20,  50,  50,  10,  20,  20,  10,  20,  40,  80, 
 10,   0,  20,   0,  10,  50,  20,  20,  10,  10,  20,  30,   0,   0,  20,  10,  10,  20,  10, 150, 
  0,  -1,  -2,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -1,  -2,  -1,  -1,   0,   0,  -1,  -2,  -1, 
 -2,  -3,  -2,  -3,  -2,   3,  -3,   2,  -1,  -2,  -1,  -1,  -2,  -3,  -1,  -2,  -2,  -2,  -1,   2,  -1,   7, 
 -1,   1,  -3,   1,   4,  -3,  -2,   0,  -3,   1,  -3,  -1,   0,  -1,   3,   0,   0,  -1,  -2,  -3,  -1,  -2,   4, 

 };
int rblosum80mt[]={
77, 
 25,  72, 
 36,  10, 108, 
 25,  72,   5,  93, 
 31,  46,   5,  51,  82, 
 20,  10,  20,  10,  10,  93, 
 41,  31,  10,  25,  20,  10,  87, 
 25,  36,   5,  31,  41,  31,  20, 103, 
 25,  10,  31,   5,  10,  36,   5,  10,  77, 
 36,  36,  10,  31,  46,  15,  25,  36,  15,  82, 
 25,   5,  25,   5,  10,  41,   5,  15,  51,  20,  72, 
 31,  15,  25,  10,  20,  41,  15,  20,  51,  25,  56,  87, 
 25,  67,  15,  51,  36,  10,  36,  46,  10,  41,  10,  20,  87, 
 36,  20,  10,  25,  31,  10,  15,  20,  15,  31,  15,  20,  20, 103, 
 31,  36,  15,  36,  56,  15,  20,  46,  15,  51,  20,  36,  41,  25,  87, 
 25,  31,  10,  25,  36,  15,  20,  41,  15,  56,  20,  25,  36,  25,  46,  87, 
 51,  41,  31,  36,  36,  20,  36,  31,  20,  36,  20,  25,  46,  31,  36,  31,  77, 
 41,  36,  31,  31,  31,  20,  25,  25,  31,  36,  25,  36,  41,  25,  36,  31,  51,  82, 
 36,  10,  31,  10,  20,  31,  10,  15,  62,  20,  46,  46,  15,  20,  20,  20,  25,  41,  77, 
 15,   0,  15,   0,  10,  41,  10,  20,  15,  10,  20,  25,   5,   5,  20,  15,  10,  15,  15, 124, 
 -1,  -3,  -4,  -3,  -2,  -3,  -3,  -2,  -2,  -2,  -2,  -2,  -2,  -3,  -2,  -2,  -1,  -1,  -2,  -5,  -2, 
 -4,  -5,  -5,  -6,  -5,   4,  -6,   3,  -3,  -4,  -2,  -3,  -4,  -6,  -3,  -4,  -3,  -3,  -3,   3,  -3,  11, 
 -2,   0,  -7,   1,   6,  -6,  -4,   0,  -6,   1,  -5,  -3,  -1,  -2,   5,   0,  -1,  -2,  -4,  -5,  -1,  -4,   6,   
};
int rpam120mt[]={
 52, 
 38,  57, 
 24,   9,  81, 
 38,  57,   4,  62, 
 38,  52,   4,  52,  62, 
 19,  14,   9,   4,   4,  77, 
 43,  38,  19,  38,  33,  14,  62, 
 24,  43,  19,  38,  33,  24,  19,  72, 
 33,  24,  24,  24,  24,  38,  19,  19,  67, 
 28,  38,   4,  33,  33,   4,  24,  28,  24,  62, 
 24,  19,   4,  14,  19,  38,  14,  24,  43,  19,  62, 
 28,  19,   9,  19,  24,  33,  19,  19,  43,  38,  52,  77, 
 33,  52,  14,  48,  43,  19,  38,  48,  28,  43,  19,  24,  57, 
 43,  28,  19,  24,  28,  14,  28,  33,  24,  28,  24,  24,  28,  67, 
 33,  38,   4,  43,  48,   9,  24,  52,  24,  38,  28,  33,  38,  38,  67, 
 24,  28,  19,  24,  24,  14,  19,  43,  28,  48,  19,  33,  33,  33,  43,  67, 
 43,  38,  38,  38,  33,  24,  43,  28,  28,  33,  19,  28,  43,  43,  28,  33,  52, 
 43,  38,  24,  33,  28,  19,  33,  24,  38,  33,  24,  33,  38,  33,  28,  28,  48,  57, 
 38,  24,  24,  24,  24,  24,  28,  24,  52,  19,  43,  43,  24,  28,  24,  24,  28,  38,  62, 
  4,   9,   0,   0,   0,  33,   0,  24,   9,  14,  24,   9,  19,   4,   9,  43,  28,   9,   0,  96, 
 -1,  -1,  -4,  -2,  -1,  -3,  -2,  -2,  -1,  -2,  -2,  -2,  -1,  -2,  -1,  -2,  -1,  -1,  -1,  -5,  -2, 
 -4,  -3,  -1,  -5,  -5,   4,  -6,  -1,  -2,  -5,  -2,  -4,  -2,  -6,  -5,  -5,  -3,  -3,  -3,  -2,  -3,   8, 
 -1,   2,  -7,   3,   4,  -6,  -2,   1,  -3,  -1,  -3,  -2,   0,  -1,   4,  -1,  -1,  -2,  -3,  -7,  -1,  -5,   4, 
};
int  rpam160mt[]={
 47, 
 36,  52, 
 26,  15,  83, 
 36,  52,  10,  57, 
 36,  47,  10,  52,  57, 
 20,  15,  10,   5,  10,  73, 
 41,  36,  20,  36,  36,  15,  57, 
 26,  41,  20,  36,  36,  26,  20,  68, 
 31,  26,  26,  20,  26,  36,  20,  20,  62, 
 26,  36,  10,  36,  31,  10,  26,  31,  26,  57, 
 26,  15,   5,  15,  20,  41,  15,  26,  47,  20,  62, 
 31,  20,  10,  20,  26,  36,  20,  20,  47,  36,  52,  73, 
 36,  47,  15,  47,  41,  20,  36,  47,  26,  41,  20,  26,  52, 
 41,  31,  20,  26,  31,  15,  31,  31,  26,  26,  20,  26,  31,  62, 
 31,  41,  10,  41,  47,  10,  26,  47,  26,  36,  26,  31,  36,  36,  62, 
 26,  31,  20,  26,  26,  15,  20,  41,  26,  52,  20,  31,  31,  31,  41,  68, 
 41,  36,  36,  36,  36,  20,  41,  31,  26,  31,  20,  26,  41,  41,  31,  31,  47, 
 41,  36,  26,  31,  31,  20,  31,  26,  36,  36,  26,  31,  36,  36,  31,  31,  41,  52, 
 36,  26,  26,  20,  26,  26,  26,  26,  52,  20,  41,  41,  26,  26,  26,  20,  31,  36,  57, 
 10,  10,   0,   5,   0,  31,   0,  20,  10,  15,  26,  15,  15,  10,  10,  41,  26,  10,   5,  99, 
  0,  -1,  -3,  -1,  -1,  -3,  -1,  -1,  -1,  -1,  -2,  -1,   0,  -1,  -1,  -1,   0,   0,  -1,  -4,  -1, 
 -3,  -3,   0,  -4,  -4,   5,  -5,   0,  -2,  -4,  -2,  -3,  -2,  -5,  -4,  -4,  -3,  -3,  -3,  -1,  -3,   8, 
  0,   2,  -5,   2,   3,  -5,  -1,   1,  -2,   0,  -3,  -2,   1,  -1,   3,   0,  -1,  -1,  -2,  -6,  -1,  -4,   3, 
};
int rpam250mt[]={
 42, 
 34,  47, 
 25,  17,  85, 
 34,  47,  12,  51, 
 34,  47,  12,  47,  51, 
 21,  17,  17,   8,  12,  72, 
 38,  34,  21,  38,  34,  12,  55, 
 30,  38,  21,  38,  38,  25,  25,  60, 
 30,  25,  25,  25,  25,  38,  21,  25,  55, 
 30,  38,  12,  34,  34,  12,  25,  34,  25,  55, 
 25,  21,   8,  17,  21,  42,  17,  25,  42,  21,  60, 
 30,  25,  12,  21,  25,  34,  21,  25,  42,  34,  51,  60, 
 34,  42,  17,  42,  38,  21,  34,  42,  25,  38,  21,  25,  42, 
 38,  30,  21,  30,  30,  12,  34,  34,  25,  30,  21,  25,  34,  60, 
 34,  38,  12,  42,  42,  12,  30,  47,  25,  38,  25,  30,  38,  34,  51, 
 25,  30,  17,  30,  30,  17,  21,  42,  25,  47,  21,  34,  34,  34,  38,  60, 
 38,  34,  34,  34,  34,  21,  38,  30,  30,  34,  21,  25,  38,  38,  30,  34,  42, 
 38,  34,  25,  34,  34,  21,  34,  30,  34,  34,  25,  30,  34,  34,  30,  30,  38,  47, 
 34,  25,  25,  25,  25,  30,  30,  25,  51,  25,  42,  42,  25,  30,  25,  25,  30,  34,  51, 
  8,  12,   0,   4,   4,  34,   4,  21,  12,  21,  25,  17,  17,   8,  12,  42,  25,  12,   8, 107, 
  0,  -1,  -3,  -1,  -1,  -2,  -1,  -1,  -1,  -1,  -1,  -1,   0,  -1,  -1,  -1,   0,   0,  -1,  -4,  -1, 
 -3,  -3,   0,  -4,  -4,   7,  -5,   0,  -1,  -4,  -1,  -2,  -2,  -5,  -4,  -4,  -3,  -3,  -2,   0,  -2,  10, 
  0,   2,  -5,   3,   3,  -5,   0,   2,  -2,   0,  -3,  -2,   1,   0,   3,   0,   0,  -1,  -2,  -6,  -1,  -4,   3, 
};
int rpam350mt[]={
 39, 
 36,  43, 
 26,  16,  92, 
 36,  43,  13,  46, 
 36,  43,  13,  46,  46, 
 19,  16,  16,  13,  13,  76, 
 39,  36,  19,  36,  36,  13,  49, 
 29,  36,  19,  36,  36,  26,  26,  56, 
 33,  26,  23,  26,  26,  39,  26,  26,  49, 
 29,  36,  13,  36,  33,  13,  29,  36,  26,  49, 
 26,  19,   9,  19,  19,  43,  19,  26,  46,  23,  59, 
 29,  26,  13,  23,  26,  36,  23,  26,  43,  33,  49,  53, 
 33,  39,  19,  39,  39,  19,  36,  39,  26,  36,  23,  26,  39, 
 36,  33,  23,  33,  33,  16,  33,  33,  26,  29,  23,  26,  33,  53, 
 33,  39,  13,  39,  43,  16,  29,  43,  26,  36,  26,  29,  36,  36,  46, 
 29,  33,  19,  29,  33,  16,  26,  39,  26,  46,  23,  33,  36,  33,  39,  56, 
 36,  36,  33,  36,  33,  19,  36,  29,  29,  33,  23,  26,  36,  36,  33,  33,  36, 
 36,  33,  26,  33,  33,  23,  36,  29,  33,  33,  26,  29,  36,  36,  33,  29,  36,  39, 
 33,  26,  26,  26,  26,  29,  29,  26,  46,  26,  43,  39,  26,  29,  26,  23,  29,  33,  49, 
  9,  13,   0,   6,   6,  36,   6,  23,  13,  19,  26,  16,  16,   9,  16,  46,  23,  13,   9, 122, 
  0,   0,  -3,  -1,   0,  -2,  -1,   0,   0,  -1,  -1,   0,   0,   0,   0,  -1,   0,   0,   0,  -5,  -1, 
 -4,  -4,   1,  -5,  -5,  11,  -6,   0,   0,  -5,   0,  -2,  -3,  -6,  -5,  -5,  -3,  -3,  -2,   1,  -2,  14, 
  0,   2,  -6,   3,   3,  -6,   0,   2,  -2,   1,  -3,  -2,   2,   0,   3,   1,   0,   0,  -2,  -7,   0,  -5,   3, 
};
int ralpha_mat []={
 42, 
 27,  27, 
 31,  27,  60, 
 28,  27,  30,  46, 
 27,  27,  31,  28,  42, 
 25,  27,  31,  28,  29,  84, 
 29,  27,  31,  25,  29,  30,  51, 
 32,  27,  31,  60,  29,  31,  23,  61, 
 46,  27,  28,  28,  31,  14,  29,  23,  52, 
 28,  27,  27,  31,  30,  26,  29,  23,  21,  49, 
 30,  27,  35,  31,  30,  29,  31,  23,  15,  23,  57, 
 28,  27,  30,  31,  29,  12,  24,  20,  18,  25,  33,  53, 
 40,  27,  29,  27,  46,  31,  30,  28,  28,  60,  25,  28,  36, 
 60,  27,  34,  35,  51,  28,  28,  23,  22,  24,  29,  13,  31,  66, 
 36,  27,  28,  28,  27,  29,  30,  31,  34,  32,  24,  42,  32,  29,  35, 
 27,  27,  36,  31,  29,  60,  32,  46,  30,  28,  28,  25,  28,  28,  27,  40, 
 28,  27,  24,  27,  23,  29,  27,  21,  18,  22,  23,  13,  31,  29,  31,  31,  38, 
 31,  27,  32,  30,  29,  29,  61,  22,  16,  29,  30,  12,  28,  30,  30,  31,  29,  36, 
 28,  27,  29,  24,  24,  31,  23,  15,  32,  23,  26,   9,  30,  32,  29,  35,  29,   3,  53, 
 31,  27,  42,  31,  31,  31,  23,  22,  15,  26,  29,  25,  35,  31,  30,  31,  29,   0,  22, 132, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  6,   0,   2,  10,   3,  -2,  -6,  38, -14,  -7,  -1, -19,   0,   5,   3,   1,   4, -29,  -6, -19,   0,  97, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
};

int rbeta_mat[]={
 44, 
 26,  26, 
 29,  26, 102, 
 27,  26,  22,  64, 
 25,  26,  33,  22,  50, 
 14,  26,  32,  17,  31,  70, 
 28,  26,  31,  14,  35,  32,  68, 
 36,  26,  33, 102,  28,   3,  23,  69, 
 64,  26,  17,  26,  26,   9,  28,  21,  48, 
 11,  26,  26,  31,  12,  28,  39,  17,  18,  52, 
 22,  26,  50,  33,  27,  31,  36,  19,  21,  24,  52, 
 22,  26,  28,  33,  29,  19,  17,  13,  16,  27,  37,  45, 
 57,  26,  28,  25,  64,  33,  22,  11,  22, 102,  14,  26,  38, 
102,  26,  39,  50,  68,  30,  30,  16,   0,  24,  32,  17,  31,  87, 
 38,  26,  26,  11,  26,  35,  28,  32,  39,  35,  10,  50,  36,  28,  50, 
 24,  26,  38,  29,  28, 102,  36,  64,  22,  22,  11,  14,  27,  26,  25,  57, 
 26,  26,  10,  26,  23,  21,  22,  16,  17,  22,   8,  19,  33,  31,  26,  33,  46, 
 33,  26,  35,  28,  28,  28,  69,  17,  15,   4,  35,  10,  17,  27,  27,  31,  29,  42, 
 17,  26,  28,  10,  17,  24,  17,  21,  36,  28,  25,  16,  28,  18,  31,  50,  28,   9,  44, 
 31,  26,  50,  32,  36,  21,  21,  14,  14,  24,  34,   2,  50,  31,  12,  33,  31,  13,  22, 130, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  9,   0,  12,  17,  17, -12,  -9,  28, -13,  -3,   0, -12,   0,   8,   4, -11,   2,  -5,  -5,  -5,   0,  47, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
};
int rcoil_mat[]={
 36, 
 27,  27, 
 29,  27, 124, 
 28,  27,  22,  51, 
 28,  27,  33,  18,  40, 
 13,  27,  29,  17,  23, 101, 
 27,  27,  30,  13,  23,  28,  64, 
 31,  27,  30, 124,  21,  15,  24,  76, 
 51,  27,  17,  29,  25,  14,  27,  26,  71, 
 18,  27,  29,  30,   8,  25,  24,  23,  20,  61, 
 22,  27,  39,  33,  22,  28,  28,  21,  24,  27,  70, 
 18,  27,  29,  30,  21,  12,   6,  18,  20,  26,  33,  73, 
 52,  27,  27,  28,  51,  33,  22,  18,  18, 124,  13,  29,  36, 
124,  27,  34,  39,  64,  27,  25,  23,  18,  24,  27,  13,  30,  79, 
 36,  27,  29,  18,  29,  23,  29,  29,  34,  32,  13,  40,  31,  21,  39, 
 27,  27,  36,  29,  27, 124,  31,  51,  22,  18,  18,  13,  28,  29,  28,  52, 
 29,  27,  13,  29,  24,  19,  16,  22,  21,  18,   9,  14,  30,  30,  25,  33,  44, 
 33,  27,  32,  29,  27,  20,  76,  10,  19,  20,  32,   9,  17,  28,  22,  30,  29,  55, 
 17,  27,  21,  13,   6,  21,  23,  24,  44,  13,  21,   7,  29,  17,  23,  39,  26,  20,  60, 
 30,  27,  40,  29,  28,  19,  26,  16,   7,  25,  31,   9,  39,  30,   8,  30,  27,  18,  26, 143, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  4,   0,  -4,   8,  -3, -30,  -6,  49, -10,  -7, -12, -18,   3,   3,  -6, -11,   3,   2,   2,  -5,   0,  59, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
};
int tmpam250mt[]={
  2, 
  0,   0, 
  2,   0,   6, 
 -1,   0,   0,  12, 
  0,   0,   6,  -1,  13, 
 -3,   0,   1,  -3,   3,   5, 
  1,   0,   3,  -3,   1,   7,   6, 
  6,   0,   2,   6,   0,  -1,  -3,  11, 
 12,   0,  -3,  -2,  -2,  -5,   5,   0,   2, 
 -1,   0,   0,   3,  -1,   0,   3,  -3,  -3,  12, 
  0,   0,  11,   6,   3,   5,   3,  -3,  -2,  -2,   3, 
 -1,   0,   2,   2,  -1,  -2,  -1,  -3,  -4,  -1,   9,   3, 
  7,   0,   1,   0,  12,   6,   0,  -1,  -1,   6,  -3,  -2,  11, 
  6,   0,   8,  11,   6,   0,   2,  -4,  -1,  -2,   3,  -4,   3,  11, 
 11,   0,  -2,  -1,   0,   1,   2,   1,   8,   7,  -3,  13,   6,   0,  11, 
 -1,   0,  11,   2,   1,   6,   6,  12,   0,  -1,  -1,  -3,  -1,  -2,   0,   7, 
 -2,   0,  -3,   0,  -3,  -3,  -3,  -4,  -2,  -3,  -3,  -4,   2,   2,  -2,   6,   3, 
  6,   0,   7,   2,   5,  -2,  11,  -2,  -5,  -1,   6,  -6,  -3,  -1,   3,   3,   1,   3, 
 -3,   0,   0,  -3,  -1,   0,  -3,  -2,   1,  -3,   4,  -6,   2,   1,   3,  11,   0,  -3,   2, 
  3,   0,  13,   1,   3,  -2,   0,  -4,  -4,  -2,   1,   1,  11,   2,  -1,   2,  -1,  -4,  -1,  12, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  2,   0,   1,   8,   3,  -4,  -3,   2,  -4,  -3,  -1,  -4,   0,   0,  -1,  -3,   1,   5,   0,  -3,   0,  10, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, };
int  rtmpam250mt[]={
 32, 
 24,  24, 
 32,  24,  49, 
 20,  24,  24,  73, 
 24,  24,  49,  20,  77, 
 12,  24,  28,  12,  36,  45, 
 28,  24,  36,  12,  28,  53,  49, 
 49,  24,  32,  49,  24,  20,  12,  69, 
 73,  24,  12,  16,  16,   4,  45,  24,  32, 
 20,  24,  24,  36,  20,  24,  36,  12,  12,  73, 
 24,  24,  69,  49,  36,  45,  36,  12,  16,  16,  36, 
 20,  24,  32,  32,  20,  16,  20,  12,   8,  20,  61,  36, 
 53,  24,  28,  24,  73,  49,  24,  20,  20,  49,  12,  16,  69, 
 49,  24,  57,  69,  49,  24,  32,   8,  20,  16,  36,   8,  36,  69, 
 69,  24,  16,  20,  24,  28,  32,  28,  57,  53,  12,  77,  49,  24,  69, 
 20,  24,  69,  32,  28,  49,  49,  73,  24,  20,  20,  12,  20,  16,  24,  53, 
 16,  24,  12,  24,  12,  12,  12,   8,  16,  12,  12,   8,  32,  32,  16,  49,  36, 
 49,  24,  53,  32,  45,  16,  69,  16,   4,  20,  49,   0,  12,  20,  36,  36,  28,  36, 
 12,  24,  24,  12,  20,  24,  12,  16,  28,  12,  40,   0,  32,  28,  36,  69,  24,  12,  32, 
 36,  24,  77,  28,  36,  16,  24,   8,   8,  16,  28,  28,  69,  32,  20,  32,  20,   8,  20,  73, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  2,   0,   1,   8,   3,  -4,  -3,   2,  -4,  -3,  -1,  -4,   0,   0,  -1,  -3,   1,   5,   0,  -3,   0,  10, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
};
int promoter_tf1[]={
  0, 
  0,   0, 
  0,   0,   0, 
  0,   0,   0,   5, 
  0,   0,   0,   4,   6, 
  0,   0,   0,   5,   7,   5, 
  0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   5,   5,   5,   0,   5, 
  0,   0,   0,  -7,  -3,  -3,   0,  -6,   6, 
  0,   0,   0,  -7,  -6,  -2,   0,  -7,   3,   5, 
  0,   0,   0,  -4,  -2,  -2,   0,  -4,   5,   5,   7, 
  0,   0,   0,  -3,  -2,  -1,   0,  -5,   6,   6,   7,   6, 
  0,   0,   0,  -7,  -3,   0,   0,  -5,  -7,  -5,  -2,  -3,   5, 
  0,   0,   0,  -5,  -5,  -2,   0,  -5,  -4,  -7,  -3,  -3,   7,   4, 
  0,   0,   0,  -5,  -6,  -4,   0,  -9,  -7,  -6,  -7,  -6,   4,   2,   3, 
  0,   0,   0,  -5,  -3,  -2,   0,  -5,  -5,  -6,  -4,  -4,   4,   5,   3,   4, 
  0,   0,   0,  -6,  -3,  -2,   0,  -3,  -6,  -4,  -4,  -2,  -7,  -5,  -8,  -2,   6, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  -5,  -5,  -2,   0,  -4,  -3,  -5,  -2,  -1,  -4,  -6,  -6,  -2,   4,   0,   6, 
  0,   0,   0,  -4,  -3,  -3,   0,  -2,  -4,  -3,  -3,   0,  -2,  -4,  -7,   0,   6,   0,   6,   6, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,  -1, 
  0,   0,   0,  -4,  -5,  -2,   0,  -4,  -4,  -5,  -4,  -4,  -6,  -7,  -9,  -6,   5,   0,   4,   5,   0,   5, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
}; 
int blosumR[]={
  0, 
  0,   0, 
  0,   0,   0, 
  0,   0,   0,   6, 
  0,   0,   0,   1,   6, 
  0,   0,   0,   2,   2,   5, 
  0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,   2,   2,   1,   0,   6, 
  0,   0,   0,   1,  -1,  -1,   0,  -2,   6, 
  0,   0,   0,  -3,   1,  -2,   0,  -3,   1,   6, 
  0,   0,   0,  -2,  -1,   2,   0,  -2,   2,   1,   6, 
  0,   0,   0,  -1,  -1,  -1,   0,   1,   2,   2,   2,   6, 
  0,   0,   0,   1,  -1,   0,   0,  -2,   1,  -2,  -1,  -1,   6, 
  0,   0,   0,  -2,   2,  -1,   0,  -2,  -2,   1,  -2,  -1,   2,   6, 
  0,   0,   0,  -3,  -3,   2,   0,  -4,  -3,  -3,   0,  -3,   1,   0,   4, 
  0,   0,   0,  -2,  -1,  -2,   0,   2,  -2,  -2,  -2,   2,   1,   2,   0,   6, 
  0,   0,   0,   1,  -1,  -1,   0,  -1,   1,  -2,  -2,  -1,   1,  -2,  -3,  -1,   6, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  -2,   2,  -2,   0,  -2,  -1,   2,  -2,   0,  -2,   1,  -3,  -1,   1,   0,   6, 
  0,   0,   0,  -2,  -2,   2,   0,  -2,  -2,  -2,   2,  -1,  -1,  -2,   0,  -1,   2,   0,   1,   5, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 
  0,   0,   0,  -1,  -2,  -2,   0,   2,  -2,  -2,  -2,   2,  -2,  -3,  -4,   1,   2,   0,   2,   1,   0,   6, 
  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,};

#endif // MATRICES_H
