from django.db import models

RATING_CHOICES = (
	('G', "Great!"),
	('A', "Average"),
	('U', "Uninteresting"),
)

class Entry(models.Model):
	name = models.CharField("Your Name", max_length=100)
	rating = models.CharField("Rate this site", max_length=1,
		choices=RATING_CHOICES)
	comment = models.TextField("Your Comments (optional)", blank=True)
	posted = models.DateTimeField(auto_now_add=True)

