#include <iostream>
#include <ctype.h>

#include "Symmetry.hh"
#include "PointConfiguration.hh"

int main(const int argc, const char** argv) {
  if (argc < 2) {
    std::cerr << "usage: " << argv[0] << " n" << std::endl;
    return 1;
  }
  parameter_type n = atoi(argv[1]);
  if (n <= 0) {
    std::cerr << "n > 0 required" << std::endl;
    return 1;
  }

  CommandlineOptions::init(argc, argv);

  // first compute the group A_n generated by all 3-cycles:
  symmetry_data A_data;
  Permutation cycle(n,3);
  do {
    Symmetry s(cycle);
    A_data.insert(s);
  } while (cycle.lexnext());
  SymmetryGroup A(n, A_data);

  // transform symmetries into permutation matrices:
  PointConfiguration B_A;
  
  const Vector identity(Symmetry(n).ReducedPermutationMatrix().StackOfAllColumns());
  B_A.append(identity);
  Vector center(identity);
  for (SymmetryGroup::const_iterator iter = A.begin();
       iter != A.end();
       ++iter) {
    const Symmetry s(*iter);
    const Vector next_column(s.ReducedPermutationMatrix().StackOfAllColumns());
    B_A.append(next_column);
    center.add(next_column);
  }
  center.scale(ONE/B_A.coldim());
  B_A.append(center);
  B_A.homogenize();
  std::cout << B_A << std::endl;
  std::cout << A << std::endl;
  return 0;
}
