/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef HOMEPAGEWIDGET_H
#define HOMEPAGEWIDGET_H

#include <QWidget>
#include <QPixmap>
#include <QPainter>
#include <QLabel>
#include <QVariantMap>
#include <QGSettings>

#include "tristatelabel.h"

#ifdef WITHKYSEC
#include <kysec/libkysec.h>
#include <kysec/status.h>
#endif

enum COLOR{
    BLUE,
    WHITE,
    BLACK,
    GRAY,
    HIGHLIGHT,
};

class MainWindow;
class QListWidgetItem;

#define PLUGIN_STATUS_SCHEMA "org.ukui.control-center.pluginstatus"
#define PLUGINS_SCHEMA       "org.ukui.control-center.plugins"
#define PLUGINS_PATH         "/org/ukui/control-center/plugins/"
#define PLUGIN_NAME          "plugin-name"
#define SHOW_KEY             "show"

namespace Ui {
class HomePageWidget;
}

class HomePageWidget : public QWidget
{
    Q_OBJECT

public:
    explicit HomePageWidget(QWidget *parent = nullptr, QMap<QString, QGSettings *> map = {});
    ~HomePageWidget();

public:
    void initUI();
    QGSettings * setGsettingsPath(QList<char *> list , QString name);

private:
    const QPixmap loadSvg(const QString &fileName, COLOR color);
    QPixmap drawSymbolicColoredPixmap(const QPixmap &source, COLOR color);
    bool eventFilter(QObject *watched, QEvent *event);
public:
     QMap<QString, QGSettings *> vecGsettins;
private:
    Ui::HomePageWidget *ui;
    MainWindow * pmainWindow;
    QVariantMap mModuleMap;
    QList<QList<TristateLabel *>> mLabels;
};

#endif // HOMEPAGEWIDGET_H
