/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEUSERLOGO_H
#define CHANGEUSERLOGO_H

#include <QDialog>
#include <QPainterPath>
#include "elipsemaskwidget.h"

class QVBoxLayout;
class QHBoxLayout;
class QPushButton;
class QLabel;
class QFrame;
class QButtonGroup;
class FlowLayout;
class QPixmap;
class QDBusInterface;

class ChangeUserLogo : public QDialog
{
    Q_OBJECT

public:
    explicit ChangeUserLogo(QString n, QWidget *parent = nullptr);
    ~ChangeUserLogo();

public:
    void initUI();
    void loadSystemLogo();
    void requireUserInfo(QString logo, QString type);
    void refreshUserLogo(QString logo);
    void setupConnect();
    void showLocalFaceDialog();

public:
    QVBoxLayout * culMainVerLayout;
    QHBoxLayout * culUserHorLayout;
    QVBoxLayout * culUserInfoVerLayout;
    QHBoxLayout * culLogoNoteHorLayout;
    QHBoxLayout * culMoreLogoHorLayout;
    QHBoxLayout * culBottomBtnsHorLayout;

    QLabel * culNickNameLabel;
    QLabel * culLogoLabel;
    QLabel * culTypeLabel;
    QLabel * culNoteLabel;

    QPushButton * culMoreLogoBtn;
    QPushButton * culCancelBtn;
    QPushButton * culConfirmBtn;

    QButtonGroup * logosBtnGroup;

    QFrame * logosFrame;

    FlowLayout * logosFlowLayout;

private:
    QString name;
    QString selected;

private:
    QPixmap makeRoundLogo(QString logo, int wsize, int hsize, int radius);
    bool setCulTextDynamic(QLabel * label, QString string);

Q_SIGNALS:
    void confirmChanged(QString filename);
};

#endif // CHANGEUSERLOGO_H
