/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef CHANGEUSERTYPE_H
#define CHANGEUSERTYPE_H

#include <QDialog>
#include <QWidget>
#include <QApplication>
#include <QMessageBox>
#include "lightlabel.h"

class QHBoxLayout;
class QVBoxLayout;
class QLabel;
class QPushButton;
class QRadioButton;
class QButtonGroup;
class QFrame;

class QDBusInterface;

class ChangeUserType : public QDialog
{
    Q_OBJECT

public:
    explicit ChangeUserType(QWidget *parent = nullptr);
    ~ChangeUserType();

public:
    void requireUserInfo(QString logo, QString nname, int id, QString utype);
    void initUI();
    void setConnect();

public:
    QVBoxLayout * cutMainVerLayout;
    QHBoxLayout * cutUserHorLayout;
    QVBoxLayout * cutUserInfoVerLayout;
    QVBoxLayout * cutAdminVerLayout;
    QVBoxLayout * cutStandardVerLayout;
    QHBoxLayout * cutAdminInfoHorLayout;
    QHBoxLayout * cutStandardInfoHorLayout;
    QHBoxLayout * cutAdminInfo2HorLayout;
    QHBoxLayout * cutStandardInfo2HorLayout;
    QHBoxLayout * cutBtnGroupsHorLayout;
    QHBoxLayout * tipHorLayout;

    QRadioButton * cutAdminRadioBtn;
    QRadioButton * cutStandardRadioBtn;

    QButtonGroup * cutTypesBtnGroup;

    QLabel * cutNickNameLabel;
    LightLabel * cutUserTypeLabel;
    QLabel * cutNoteLabel;
    QLabel * cutAdminLabel;
    QLabel * cutStandardLabel;
    LightLabel * cutAdminNoteLabel;
    LightLabel * cutStandardNoteLabel;
    QLabel * tipLabel;

    QPushButton * cutUserLogoBtn;
    QPushButton * cutConfirmBtn;
    QPushButton * cutCancelBtn;

    QFrame * cutAdminFrame;
    QFrame * cutStandardFrame;

protected:
    bool eventFilter(QObject *watched, QEvent *event);
    bool setTextDynamic(QLabel *label, QString string);

private:
    QString _objpath;
    QString username;
    QString nickname;
    int type;
    QString logo;
    int oldid;

    QDBusInterface * cutiface;

signals:
    void confirmChanged(int id);

};

#endif // CHANGEUSERTYPE_H
